/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.CompiledClasses;
import net.sf.jasperreports.engine.util.ClassLoaderFilter;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledClassesLoader
extends JRClassLoader {
    private static final Logger log = LoggerFactory.getLogger(CompiledClassesLoader.class);
    private CompiledClasses compiledClasses;

    protected CompiledClassesLoader(ClassLoaderFilter classLoaderFilter, CompiledClasses compiledClasses) {
        super(classLoaderFilter);
        this.compiledClasses = compiledClasses;
    }

    protected CompiledClassesLoader(ClassLoader parent, ClassLoaderFilter classLoaderFilter, CompiledClasses compiledClasses) {
        super(parent, classLoaderFilter);
        this.compiledClasses = compiledClasses;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.compiledClasses.getClassBytes(name);
        if (classBytes == null) {
            return super.findClass(name);
        }
        if (log.isDebugEnabled()) {
            log.debug("found compiled class " + name);
        }
        return this.loadClass(name, classBytes);
    }

    protected Class<?> loadCompiledClass(String name) {
        byte[] classBytes = this.compiledClasses.getClassBytes(name);
        if (classBytes == null) {
            throw new JRRuntimeException("Unkonwn class " + name);
        }
        if (log.isDebugEnabled()) {
            log.debug("loading compiled class " + name);
        }
        return this.loadClass(name, classBytes);
    }
}

