/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRHibernateAbstractDataSource;
import net.sf.jasperreports.engine.data.JRHibernateIterateDataSource;
import net.sf.jasperreports.engine.data.JRHibernateListDataSource;
import net.sf.jasperreports.engine.data.JRHibernateScrollDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRHibernateQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Logger log;
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_QUERY_RUN_TYPE = "query.hibernate.unknown.query.run.type";
    public static final String EXCEPTION_MESSAGE_KEY_UNRESOLVED_TYPE_CONSTANT = "query.hibernate.unresolved.type.constant";
    public static final String CANONICAL_LANGUAGE = "HQL";
    private static final Map<Class<?>, Type> hibernateTypeMap;
    private final Integer reportMaxCount;
    private Session session = (Session)this.getParameterValue("HIBERNATE_SESSION");
    private Query query;
    private boolean queryRunning;
    private ScrollableResults scrollableResults;
    private boolean isClearCache;

    private static final Type loadTypeConstant(Class<?> typeConstantsClass, String name) {
        try {
            Field constant = typeConstantsClass.getField(name);
            if (!Modifier.isStatic(constant.getModifiers()) || !Type.class.isAssignableFrom(constant.getType())) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNRESOLVED_TYPE_CONSTANT, name, typeConstantsClass.getName());
            }
            Type type = (Type)constant.get(null);
            return type;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new JRRuntimeException(e);
        }
    }

    public JRHibernateQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(jasperReportsContext, dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        this.isClearCache = this.getPropertiesUtil().getBooleanProperty(dataset, "net.sf.jasperreports.hql.clear.cache", false);
        if (this.session == null) {
            log.warn("The supplied org.hibernate.Session object is null.");
        }
        this.parseQuery();
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.session != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected JRDataSource createResultDatasource() {
        JRHibernateAbstractDataSource resDatasource;
        String runType = this.getPropertiesUtil().getProperty(this.dataset, "net.sf.jasperreports.hql.query.run.type");
        boolean useFieldDescriptions = this.getPropertiesUtil().getBooleanProperty(this.dataset, "net.sf.jasperreports.hql.field.mapping.descriptions", true);
        if (runType == null || runType.equals("list")) {
            try {
                int pageSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.hql.query.list.page.size", 0);
                resDatasource = new JRHibernateListDataSource(this, useFieldDescriptions, pageSize);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("query.numeric.type.required", new Object[]{"net.sf.jasperreports.hql.query.list.page.size"}, e);
            }
        } else if (runType.equals("iterate")) {
            resDatasource = new JRHibernateIterateDataSource(this, useFieldDescriptions);
        } else if (runType.equals("scroll")) {
            resDatasource = new JRHibernateScrollDataSource(this, useFieldDescriptions);
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_QUERY_RUN_TYPE, "net.sf.jasperreports.hql.query.run.type", "list", "iterate", "scroll");
        }
        return resDatasource;
    }

    protected synchronized void createQuery(String queryString) {
        Object filterCollection;
        if (log.isDebugEnabled()) {
            log.debug("HQL query: " + queryString);
        }
        this.query = (filterCollection = this.getParameterValue("HIBERNATE_FILTER_COLLECTION")) == null ? this.session.createQuery(queryString) : this.session.createFilter(filterCollection, queryString);
        this.query.setReadOnly(true);
        int fetchSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.jdbc.fetch.size", 0);
        if (fetchSize != 0) {
            this.query.setFetchSize(fetchSize);
        }
        this.setParameters();
    }

    protected void setParameters() {
        List<String> parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            for (String parameterName : parameterNames) {
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                this.setParameter(parameter);
            }
        }
    }

    protected void setParameter(JRValueParameter parameter) {
        Type type;
        String hqlParamName = this.getHqlParameterName(parameter.getName());
        Class<?> clazz = parameter.getValueClass();
        Object parameterValue = parameter.getValue();
        if (log.isDebugEnabled()) {
            log.debug("Parameter " + hqlParamName + " of type " + clazz.getName() + ": " + parameterValue);
        }
        if ((type = hibernateTypeMap.get(clazz)) != null) {
            this.query.setParameter(hqlParamName, parameterValue, type);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.query.setParameterList(hqlParamName, (Collection)parameterValue);
        } else if (this.session.getSessionFactory().getClassMetadata(clazz) != null) {
            this.query.setEntity(hqlParamName, parameterValue);
        } else {
            this.query.setParameter(hqlParamName, parameterValue);
        }
    }

    @Override
    public synchronized void close() {
        this.closeScrollableResults();
        this.query = null;
    }

    public void closeScrollableResults() {
        if (this.scrollableResults != null) {
            try {
                this.scrollableResults.close();
            }
            finally {
                this.scrollableResults = null;
            }
        }
    }

    @Override
    public synchronized boolean cancelQuery() throws JRException {
        if (this.queryRunning) {
            this.session.cancelQuery();
            return true;
        }
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getHqlParameterName(parameterName);
    }

    protected String getHqlParameterName(String parameterName) {
        return '_' + JRStringUtil.getJavaIdentifier(parameterName);
    }

    public Type[] getReturnTypes() {
        return this.query.getReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.query.getReturnAliases();
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    public List<?> list() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            List list = this.query.list();
            return list;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    protected synchronized void setQueryRunning(boolean queryRunning) {
        this.queryRunning = queryRunning;
    }

    private void setMaxCount() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
    }

    public List<?> list(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        if (this.isClearCache) {
            this.clearCache();
        }
        return this.query.list();
    }

    public Iterator<?> iterate() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            Iterator iterator = this.query.iterate();
            return iterator;
        }
        finally {
            this.setQueryRunning(false);
        }
    }

    public ScrollableResults scroll() {
        this.setMaxCount();
        this.setQueryRunning(true);
        try {
            this.scrollableResults = this.query.scroll(ScrollMode.FORWARD_ONLY);
        }
        finally {
            this.setQueryRunning(false);
        }
        return this.scrollableResults;
    }

    public void clearCache() {
        this.session.flush();
        this.session.clear();
    }

    static {
        Class typeConstantsClass;
        log = LoggerFactory.getLogger(JRHibernateQueryExecuter.class);
        try {
            typeConstantsClass = Class.forName("org.hibernate.type.StandardBasicTypes", true, Hibernate.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            typeConstantsClass = Hibernate.class;
        }
        if (log.isDebugEnabled()) {
            log.debug("Hibernate type constants class is " + typeConstantsClass);
        }
        hibernateTypeMap = new HashMap();
        hibernateTypeMap.put(Boolean.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "BOOLEAN"));
        hibernateTypeMap.put(Byte.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "BYTE"));
        hibernateTypeMap.put(Double.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "DOUBLE"));
        hibernateTypeMap.put(Float.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "FLOAT"));
        hibernateTypeMap.put(Integer.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "INTEGER"));
        hibernateTypeMap.put(Long.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "LONG"));
        hibernateTypeMap.put(Short.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "SHORT"));
        hibernateTypeMap.put(BigDecimal.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "BIG_DECIMAL"));
        hibernateTypeMap.put(BigInteger.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "BIG_INTEGER"));
        hibernateTypeMap.put(Character.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "CHARACTER"));
        hibernateTypeMap.put(String.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "STRING"));
        hibernateTypeMap.put(Date.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "DATE"));
        hibernateTypeMap.put(Timestamp.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "TIMESTAMP"));
        hibernateTypeMap.put(Time.class, JRHibernateQueryExecuter.loadTypeConstant(typeConstantsClass, "TIME"));
    }
}

