/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.ObjectConstructionExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectConstructionExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ObjectConstructionExpressionEvaluator.class);
    private ObjectConstructionExpression expression;

    public ObjectConstructionExpressionEvaluator(EvaluationContext evaluationContext, ObjectConstructionExpression expression) {
        super(evaluationContext);
        this.expression = expression;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        if (log.isDebugEnabled()) {
            log.debug("---> evaluating expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")");
        }
        JsonNodeContainer result = new JsonNodeContainer();
        switch (this.expression.getDirection()) {
            case DOWN: {
                for (JRJsonNode node : contextNode.getNodes()) {
                    result.addNodes(this.goDown(node));
                }
                break;
            }
            case ANYWHERE_DOWN: {
                for (JRJsonNode node : contextNode.getNodes()) {
                    result.addNodes(this.goAnywhereDown(node));
                }
                break;
            }
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private List<JRJsonNode> goDown(JRJsonNode jrJsonNode) {
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        JsonNode dataNode = jrJsonNode.getDataNode();
        if (dataNode.isObject()) {
            JRJsonNode deeperNode = this.constructNewObjectNodeWithKeys(jrJsonNode);
            if (deeperNode != null) {
                result.add(deeperNode);
            }
        } else if (dataNode.isArray()) {
            for (JsonNode node : dataNode) {
                JRJsonNode childWithKeys = this.constructNewObjectNodeWithKeys(jrJsonNode.createChild(node));
                if (childWithKeys == null) continue;
                result.add(childWithKeys);
            }
        }
        return result;
    }

    private JRJsonNode constructNewObjectNodeWithKeys(JRJsonNode from) {
        ObjectNode newNode = this.getEvaluationContext().getObjectMapper().createObjectNode();
        for (String objectKey : this.expression.getObjectKeys()) {
            JRJsonNode deeperChild;
            JsonNode deeperNode = from.getDataNode().get(objectKey);
            if (deeperNode == null || !deeperNode.isObject() && !deeperNode.isValueNode() && !deeperNode.isArray() || !this.applyFilter(deeperChild = from.createChild(deeperNode))) continue;
            newNode.set(objectKey, deeperNode);
        }
        if (newNode.size() > 0) {
            return from.createChild((JsonNode)newNode);
        }
        return null;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        if (log.isDebugEnabled()) {
            log.debug("initial stack population with: " + jrJsonNode.getDataNode());
        }
        stack.push(jrJsonNode);
        while (!stack.isEmpty()) {
            JRJsonNode childWithKeys;
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (log.isDebugEnabled()) {
                log.debug("processing stack element: " + stackDataNode);
            }
            if (!stackDataNode.isObject() || (childWithKeys = this.constructNewObjectNodeWithKeys(stackNode)) == null) continue;
            result.add(childWithKeys);
        }
        return result;
    }
}

