/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.ArrayIndexExpression;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayIndexExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ArrayIndexExpressionEvaluator.class);
    private ArrayIndexExpression expression;

    public ArrayIndexExpressionEvaluator(EvaluationContext evaluationContext, ArrayIndexExpression expression) {
        super(evaluationContext);
        this.expression = expression;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        if (log.isDebugEnabled()) {
            log.debug("---> evaluating arrayIndex expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")");
        }
        JsonNodeContainer result = new JsonNodeContainer();
        switch (this.expression.getDirection()) {
            case DOWN: {
                List<JRJsonNode> containerNodes;
                JRJsonNode nodeAtIndex;
                if (this.expression.getIndex() < 0 || this.expression.getIndex() >= contextNode.getContainerSize() || !this.applyFilter(nodeAtIndex = (containerNodes = contextNode.getContainerNodes()).get(this.expression.getIndex()))) break;
                result.add(nodeAtIndex);
                break;
            }
            case ANYWHERE_DOWN: {
                List<JRJsonNode> nodes = contextNode.getContainerNodes();
                for (JRJsonNode node : nodes) {
                    result.addNodes(this.goAnywhereDown(node));
                }
                break;
            }
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        JsonNode initialDataNode = jrJsonNode.getDataNode();
        if (log.isDebugEnabled()) {
            log.debug("initial stack population with: " + initialDataNode);
        }
        stack.push(jrJsonNode);
        while (!stack.isEmpty()) {
            JsonNode nodeAtIndex;
            JRJsonNode child;
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (!stackDataNode.isArray()) continue;
            if (log.isDebugEnabled()) {
                log.debug("processing stack element: " + stackDataNode);
            }
            if (this.expression.getIndex() < 0 || this.expression.getIndex() >= stackDataNode.size() || !this.applyFilter(child = stackNode.createChild(nodeAtIndex = stackDataNode.get(this.expression.getIndex())))) continue;
            result.add(child);
        }
        return result;
    }
}

