/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.ArrayConstructionExpression;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayConstructionExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ArrayConstructionExpressionEvaluator.class);
    private ArrayConstructionExpression expression;

    public ArrayConstructionExpressionEvaluator(EvaluationContext evaluationContext, ArrayConstructionExpression expression) {
        super(evaluationContext);
        this.expression = expression;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        if (log.isDebugEnabled()) {
            log.debug("---> evaluating arrayIndex expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")");
        }
        JsonNodeContainer result = new JsonNodeContainer();
        switch (this.expression.getDirection()) {
            case DOWN: {
                List<JRJsonNode> containerNodes = contextNode.getContainerNodes();
                int containerSize = contextNode.getContainerSize();
                for (Integer idx : this.expression.getIndexes()) {
                    JRJsonNode nodeAtIndex;
                    if (idx < 0 || idx >= containerSize || !this.applyFilter(nodeAtIndex = containerNodes.get(idx))) continue;
                    result.add(nodeAtIndex);
                }
                break;
            }
            case ANYWHERE_DOWN: {
                List<JRJsonNode> nodes = contextNode.getContainerNodes();
                for (JRJsonNode node : nodes) {
                    result.addNodes(this.goAnywhereDown(node));
                }
                break;
            }
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        JsonNode initialDataNode = jrJsonNode.getDataNode();
        if (log.isDebugEnabled()) {
            log.debug("initial stack population with: " + initialDataNode);
        }
        stack.push(jrJsonNode);
        while (!stack.isEmpty()) {
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (!stackDataNode.isArray()) continue;
            if (log.isDebugEnabled()) {
                log.debug("processing stack element: " + stackDataNode);
            }
            ArrayNode newNode = this.getEvaluationContext().getObjectMapper().createArrayNode();
            for (Integer idx : this.expression.getIndexes()) {
                JRJsonNode nodeAtIndex;
                if (idx < 0 || idx >= stackDataNode.size() || !this.applyFilter(nodeAtIndex = stackNode.createChild(stackDataNode.get(idx.intValue())))) continue;
                newNode.add(nodeAtIndex.getDataNode());
            }
            if (newNode.size() <= 0) continue;
            result.add(stackNode.createChild((JsonNode)newNode));
        }
        return result;
    }
}

