/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontExtensionsRegistry
implements ExtensionsRegistry {
    private static final Logger log = LoggerFactory.getLogger(FontExtensionsRegistry.class);
    private final List<String> fontFamiliesLocations;
    private List<FontFamily> fontFamilies;
    private List<FontSet> fontSets;

    public FontExtensionsRegistry(List<String> fontFamiliesLocations) {
        this.fontFamiliesLocations = fontFamiliesLocations;
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (FontFamily.class.equals(extensionType)) {
            this.ensureFontExtensions();
            List<FontFamily> extensions = this.fontFamilies;
            return extensions;
        }
        if (FontSet.class.equals(extensionType)) {
            this.ensureFontExtensions();
            List<FontSet> extensions = this.fontSets;
            return extensions;
        }
        return null;
    }

    protected void ensureFontExtensions() {
        if ((this.fontFamilies == null || this.fontSets == null) && this.fontFamiliesLocations != null) {
            SimpleFontExtensionHelper fontExtensionHelper = SimpleFontExtensionHelper.getInstance();
            DefaultJasperReportsContext context = DefaultJasperReportsContext.getInstance();
            FontExtensionsCollector extensionsCollector = new FontExtensionsCollector();
            for (String location : this.fontFamiliesLocations) {
                if (log.isDebugEnabled()) {
                    log.debug("Loading font extensions from " + location);
                }
                try {
                    fontExtensionHelper.loadFontExtensions((JasperReportsContext)context, location, (FontExtensionsReceiver)extensionsCollector);
                }
                catch (JRRuntimeException e) {
                    log.error("Error loading font extensions from " + location, (Throwable)e);
                }
            }
            this.fontFamilies = extensionsCollector.getFontFamilies();
            this.fontSets = extensionsCollector.getFontSets();
        }
    }
}

