/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.BoundActionExecutionContext;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualizedPageEvaluationAction
implements EvaluationBoundAction {
    private static final Logger log = LoggerFactory.getLogger(VirtualizedPageEvaluationAction.class);
    private final JRVirtualizable<?> object;
    private final int sourceId;

    public VirtualizedPageEvaluationAction(JRVirtualizable<?> object, int sourceId) {
        this.object = object;
        this.sourceId = sourceId;
    }

    @Override
    public void execute(BoundActionExecutionContext executionContext) throws JRException {
        if (log.isDebugEnabled()) {
            log.debug(this + " Resolving delayed evaluations for virtualized page " + executionContext.getCurrentPageIndex() + " on " + executionContext.getEvaluationTime());
        }
        this.object.ensureVirtualData();
    }

    public int getSourceId() {
        return this.sourceId;
    }
}

