/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.OffsetElements;
import net.sf.jasperreports.engine.fill.OffsetElementsContainer;
import net.sf.jasperreports.engine.fill.OffsetElementsIterator;
import net.sf.jasperreports.engine.util.VirtualizableElementCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualizableFrame
implements JRPrintElementContainer,
OffsetElementsContainer {
    private static final Logger log = LoggerFactory.getLogger(VirtualizableFrame.class);
    public static final String PROPERTY_FRAME_VIRTUALIZATION_ENABLED = "net.sf.jasperreports.frame.virtualization.enabled";
    private JRTemplatePrintFrame frame;
    private List<Object> elements;
    private int contentsWidth;
    private JRVirtualizationContext virtualizationContext;
    private JRVirtualPrintPage page;
    private int virtualizationPageElementSize;
    private int deepSize;

    public VirtualizableFrame(JRTemplatePrintFrame frame, JRVirtualizationContext virtualizationContext, JRPrintPage page) {
        boolean virtualizationEnabled;
        this.frame = frame;
        this.elements = new ArrayList<Object>();
        boolean bl = virtualizationEnabled = virtualizationContext != null && page instanceof JRVirtualPrintPage && JRPropertiesUtil.getInstance(virtualizationContext.getJasperReportsContext()).getBooleanProperty(PROPERTY_FRAME_VIRTUALIZATION_ENABLED, true);
        if (virtualizationEnabled) {
            this.virtualizationContext = virtualizationContext;
            this.page = (JRVirtualPrintPage)page;
            this.virtualizationPageElementSize = virtualizationContext.getPageElementSize();
            this.deepSize = 0;
        } else {
            this.virtualizationPageElementSize = 0;
        }
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.deepSize += VirtualizableElementCounter.count(element);
        this.elements.add(element);
    }

    @Override
    public void addOffsetElements(Collection<? extends JRPrintElement> elements, int offsetX, int offsetY) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        this.deepSize += VirtualizableElementCounter.count(elements);
        OffsetElements offsetElements = new OffsetElements(elements, offsetX, offsetY);
        this.elements.add(offsetElements);
    }

    public void fill() {
        if (this.virtualizationPageElementSize > 0 && this.deepSize > this.virtualizationPageElementSize) {
            PrintElementId frameID = PrintElementId.forElement(this.frame);
            if (log.isDebugEnabled()) {
                log.debug("creating virtualized list for frame " + this.frame.getUUID() + " (" + frameID + ")");
            }
            JRVirtualizationContext framesContext = this.virtualizationContext.getFramesContext();
            VirtualizableElementList virtualizableList = new VirtualizableElementList(framesContext, this.page);
            this.frame.setElementsList(virtualizableList);
            framesContext.cacheVirtualizableList(frameID, virtualizableList);
        }
        OffsetElementsIterator it = new OffsetElementsIterator(this.elements);
        while (it.hasNext()) {
            JRPrintElement element = it.next();
            this.frame.addElement(element);
        }
    }

    @Override
    public List<JRPrintElement> getElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHeight() {
        return this.frame.getHeight();
    }

    @Override
    public void setHeight(int height) {
        this.frame.setHeight(height);
    }

    @Override
    public void setContentsWidth(int width) {
        this.contentsWidth = width;
    }

    public int getContentsWidth() {
        return this.contentsWidth;
    }
}

