/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizerStore;
import net.sf.jasperreports.engine.fill.VirtualizerStoreFactory;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreFactoryVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Logger log = LoggerFactory.getLogger(StoreFactoryVirtualizer.class);
    public static final String EXCEPTION_MESSAGE_KEY_STORE_NOT_FOUND = "fill.virtualizer.store.not.found";
    private final VirtualizerStoreFactory storeFactory;
    private final ReferenceMap<JRVirtualizationContext, VirtualizerStore> contextStores;

    public StoreFactoryVirtualizer(int maxSize, VirtualizerStoreFactory storeFactory) {
        super(maxSize);
        this.storeFactory = storeFactory;
        this.contextStores = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    }

    protected VirtualizerStore store(JRVirtualizable o, boolean create) {
        JRVirtualizationContext masterContext = o.getContext().getMasterContext();
        return this.store(masterContext, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualizerStore store(JRVirtualizationContext context, boolean create) {
        VirtualizerStore store;
        ReferenceMap<JRVirtualizationContext, VirtualizerStore> referenceMap = this.contextStores;
        synchronized (referenceMap) {
            store = (VirtualizerStore)this.contextStores.get((Object)context);
        }
        if (store != null || !create) {
            if (log.isTraceEnabled()) {
                log.trace("found " + store + " for " + context);
            }
            return store;
        }
        store = this.storeFactory.createStore(context);
        if (log.isDebugEnabled()) {
            log.debug("created " + store + " for " + context);
        }
        referenceMap = this.contextStores;
        synchronized (referenceMap) {
            this.contextStores.put((Object)context, (Object)store);
        }
        return store;
    }

    @Override
    protected void pageOut(JRVirtualizable o) throws IOException {
        VirtualizerStore store = this.store(o, true);
        boolean stored = store.store(o, this.serializer);
        if (!stored && !this.isReadOnly(o)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o.getUID() + "\" already exists.");
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o) throws IOException {
        VirtualizerStore store = this.store(o, false);
        if (store == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_STORE_NOT_FOUND, o.getUID());
        }
        store.retrieve(o, !this.isReadOnly(o), this.serializer);
    }

    @Override
    protected void dispose(JRVirtualizable o) {
        VirtualizerStore store = this.store(o, false);
        if (store == null) {
            if (log.isTraceEnabled()) {
                log.trace("no store found for " + o.getUID() + " for disposal");
            }
            return;
        }
        store.remove(o.getUID());
    }

    @Override
    protected void dispose(String id) {
        throw new UnsupportedOperationException();
    }

    public void dispose(JRVirtualizationContext context) {
        context.lock();
        try {
            context.dispose();
            VirtualizerStore store = this.store(context, false);
            if (log.isDebugEnabled()) {
                log.debug("found " + store + " for " + context + " for disposal");
            }
            if (store != null) {
                store.dispose();
            }
        }
        finally {
            context.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug("disposing " + this);
        }
        ReferenceMap<JRVirtualizationContext, VirtualizerStore> referenceMap = this.contextStores;
        synchronized (referenceMap) {
            for (VirtualizerStore store : this.contextStores.values()) {
                store.dispose();
            }
            this.contextStores.clear();
        }
    }
}

