/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.BandReportFillerParent;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.FillerPageAddedEvent;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import org.apache.commons.javaflow.api.continuable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillerSubreportParent
implements BandReportFillerParent {
    private static final Logger log = LoggerFactory.getLogger(FillerSubreportParent.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_OVERFLOW = "fill.subreport.parent.unsupported.overflow";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUBREPORT_RUNNER = "fill.subreport.parent.no.subreport.runner";
    private final JRFillSubreport parentElement;
    private final JRBaseFiller parentFiller;
    private final DatasetExpressionEvaluator evaluator;
    private JRSubreportRunner subreportRunner;
    private int currentPageStretchHeight;

    public FillerSubreportParent(JRFillSubreport parentElement, DatasetExpressionEvaluator evaluator) {
        this.parentElement = parentElement;
        this.parentFiller = parentElement.filler;
        this.evaluator = evaluator;
    }

    @Override
    public String getReportName() {
        return this.parentElement.getReportName();
    }

    @Override
    public BaseReportFiller getFiller() {
        return this.parentFiller;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public void registerSubfiller(JRBaseFiller filler) {
        this.parentFiller.registerSubfiller(filler);
    }

    @Override
    public void unregisterSubfiller(JRBaseFiller filler) {
        this.parentFiller.unregisterSubfiller(filler);
    }

    @Override
    public void abortSubfiller(JRBaseFiller filler) {
        if (this.subreportRunner != null) {
            this.subreportRunner.abort();
        }
    }

    @Override
    public boolean isRunToBottom() {
        return this.parentElement.isRunToBottom() != null && this.parentElement.isRunToBottom() != false;
    }

    @Override
    public boolean isParentPagination() {
        return true;
    }

    @Override
    public boolean isPageBreakInhibited() {
        return this.parentElement.getBand().isPageBreakInhibited();
    }

    @Override
    public boolean isSplitTypePreventInhibited(boolean isTopLevelCall) {
        return this.parentElement.isSplitTypePreventInhibited(isTopLevelCall);
    }

    @Override
    public DatasetExpressionEvaluator getCachedEvaluator() {
        return this.evaluator;
    }

    public void setSubreportRunner(JRSubreportRunner subreportRunner) {
        this.subreportRunner = subreportRunner;
    }

    @Override
    @continuable
    public void addPage(FillerPageAddedEvent pageAdded) throws JRException {
        this.currentPageStretchHeight = pageAdded.getPageStretchHeight();
        if (!pageAdded.hasReportEnded()) {
            if (!this.parentFiller.isBandOverFlowAllowed()) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_OVERFLOW, (Object[])null);
            }
            this.suspendSubreportRunner(pageAdded);
        }
    }

    @continuable
    protected void suspendSubreportRunner(FillerPageAddedEvent pageAdded) throws JRException {
        if (this.subreportRunner == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SUBREPORT_RUNNER, (Object[])null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + pageAdded.getFiller().fillerId + ": suspeding subreport runner");
        }
        this.subreportRunner.suspend();
    }

    public int getCurrentPageStretchHeight() {
        return this.currentPageStretchHeight;
    }

    @Override
    public void updateBookmark(JRPrintElement element) {
        this.parentFiller.updateBookmark(element);
    }

    @Override
    public String getReportLocation() {
        return this.parentElement.getReportLocation();
    }

    @Override
    public void registerReportStyles(List<JRStyle> styles) {
        this.parentElement.registerReportStyles(styles);
    }
}

