/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.fill.BoundActionExecutionContext;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementEvaluationAction
implements EvaluationBoundAction {
    private static final Logger log = LoggerFactory.getLogger(ElementEvaluationAction.class);
    protected final JRFillElement element;
    protected final JRPrintElement printElement;

    public ElementEvaluationAction(JRFillElement element, JRPrintElement printElement) {
        this.element = element;
        this.printElement = printElement;
    }

    @Override
    public void execute(BoundActionExecutionContext executionContext) throws JRException {
        JREvaluationTime evaluationTime;
        if (log.isDebugEnabled()) {
            log.debug("resolving element " + this.printElement + " by " + this.element + " on " + executionContext.getEvaluationTime());
        }
        if ((evaluationTime = executionContext.getEvaluationTime()).getType() == EvaluationTimeEnum.MASTER) {
            int currentPageIndex = executionContext.getCurrentPageIndex();
            int totalPages = executionContext.getTotalPages();
            this.element.filler.setMasterPageVariables(currentPageIndex, totalPages);
        }
        this.element.resolveElement(this.printElement, executionContext.getExpressionEvaluationType(), evaluationTime);
    }

    public String toString() {
        return "delayed evaluation {element: " + this.element + ", printElement: " + this.printElement + "}";
    }
}

