/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.BookmarkHelper;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.fill.CompositeFillListener;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.DelayedFillActions;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.FillPageKey;
import net.sf.jasperreports.engine.fill.FillerParent;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.ReportFiller;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.javaflow.api.continuable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportFiller
implements ReportFiller {
    private static final Logger log = LoggerFactory.getLogger(BaseReportFiller.class);
    protected JasperReportsContext jasperReportsContext;
    protected JRPropertiesUtil propertiesUtil;
    protected JRFillContext fillContext;
    protected FillerParent parent;
    protected final int fillerId;
    protected List<String> printTransferPropertyPrefixes;
    protected JasperReportSource reportSource;
    protected JasperReport jasperReport;
    protected RepositoryContext repositoryContext;
    protected JRCalculator calculator;
    protected final JRFillObjectFactory factory;
    protected JRFillDataset mainDataset;
    protected Map<String, JRFillDataset> datasetMap;
    protected DelayedFillActions delayedActions;
    protected JRAbstractScriptlet scriptlet;
    protected FormatFactory formatFactory;
    protected boolean ignorePagination;
    protected BookmarkHelper bookmarkHelper;
    protected JRVirtualizationContext virtualizationContext;
    protected JasperPrint jasperPrint;
    protected Thread fillingThread;
    private boolean isInterrupted;
    private boolean threadInterrupted;
    protected FillListener fillListener;
    protected int usedPageWidth = 0;

    public BaseReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport, FillerParent parent) throws JRException {
        this(jasperReportsContext, SimpleJasperReportSource.from(jasperReport), parent);
    }

    public BaseReportFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, FillerParent parent) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setJasperReportsContext(jasperReportsContext);
        this.reportSource = reportSource;
        this.jasperReport = reportSource.getReport();
        this.repositoryContext = SimpleRepositoryContext.of(jasperReportsContext, reportSource.getRepositoryReportContext());
        this.jasperReportSet();
        this.parent = parent;
        DatasetExpressionEvaluator initEvaluator = null;
        if (parent == null) {
            this.fillContext = new JRFillContext(this);
            this.printTransferPropertyPrefixes = this.readPrintTransferPropertyPrefixes();
        } else {
            this.fillContext = parent.getFiller().fillContext;
            this.printTransferPropertyPrefixes = parent.getFiller().printTransferPropertyPrefixes;
            initEvaluator = parent.getCachedEvaluator();
        }
        this.fillerId = this.fillContext.generatedFillerId();
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": created for " + this.jasperReport.getName());
        }
        this.calculator = initEvaluator == null ? JRFillDataset.createCalculator(jasperReportsContext, this.jasperReport, this.jasperReport.getMainDataset()) : new JRCalculator(initEvaluator);
        this.jasperPrint = new JasperPrint();
        this.factory = this.initFillFactory();
        this.createDatasets();
        this.mainDataset = this.factory.getDataset(this.jasperReport.getMainDataset());
        if (parent == null) {
            FillDatasetPosition masterFillPosition = new FillDatasetPosition(null);
            this.mainDataset.setFillPosition(masterFillPosition);
        }
        this.delayedActions = new DelayedFillActions(this);
        if (log.isDebugEnabled()) {
            log.debug("created delayed actions " + this.delayedActions.getId() + " for filler " + this.fillerId);
        }
    }

    protected abstract void jasperReportSet();

    private List<String> readPrintTransferPropertyPrefixes() {
        List<JRPropertiesUtil.PropertySuffix> transferProperties = this.propertiesUtil.getProperties("net.sf.jasperreports.print.transfer.");
        ArrayList<String> prefixes = new ArrayList<String>(transferProperties.size());
        for (JRPropertiesUtil.PropertySuffix property : transferProperties) {
            String transferPrefix = property.getValue();
            if (transferPrefix == null || transferPrefix.length() <= 0) continue;
            prefixes.add(transferPrefix);
        }
        return prefixes;
    }

    protected abstract JRFillObjectFactory initFillFactory();

    private void createDatasets() throws JRException {
        this.datasetMap = new HashMap<String, JRFillDataset>();
        JRDataset[] datasets = this.jasperReport.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRFillDataset fillDataset = this.factory.getDataset(datasets[i]);
                fillDataset.createCalculator(this.jasperReport);
                this.datasetMap.put(datasets[i].getName(), fillDataset);
            }
        }
    }

    protected final void initDatasets() throws JRException {
        this.mainDataset.initElementDatasets(this.factory);
        this.initDatasets(this.factory);
        this.mainDataset.checkVariableCalculationReqs(this.factory);
        this.mainDataset.setCalculator(this.calculator);
        this.mainDataset.initCalculator();
    }

    private void initDatasets(JRFillObjectFactory factory) {
        for (JRFillDataset dataset : this.datasetMap.values()) {
            dataset.inheritFromMain();
            dataset.initElementDatasets(factory);
        }
    }

    protected final void createBoundElementMaps(JREvaluationTime evaluationTime) {
        this.delayedActions.createDelayedEvaluationTime(evaluationTime);
    }

    @Override
    public void addFillListener(FillListener fillListener) {
        this.fillListener = CompositeFillListener.addListener(this.fillListener, fillListener);
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    public JasperReportSource getReportSource() {
        return this.reportSource;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    protected void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
    }

    protected final void setParametersToContext(Map<String, Object> parameterValues) {
        JasperReportsContext localContext = LocalJasperReportsContext.getLocalContext(this.jasperReportsContext, parameterValues);
        if (localContext != this.jasperReportsContext) {
            this.setJasperReportsContext(localContext);
        }
    }

    protected void initVirtualizationContext(Map<String, Object> parameterValues) {
        if (this.isSubreport()) {
            if (this.fillContext.isUsingVirtualizer()) {
                if (this.parent.isParentPagination()) {
                    this.virtualizationContext = new JRVirtualizationContext(this.fillContext.getVirtualizationContext());
                    this.setVirtualPageSize(parameterValues);
                } else {
                    this.virtualizationContext = this.fillContext.getVirtualizationContext();
                }
            }
        } else {
            JRVirtualizer virtualizer = (JRVirtualizer)parameterValues.get("REPORT_VIRTUALIZER");
            if (virtualizer == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": using virtualizer " + virtualizer);
            }
            this.fillContext.setUsingVirtualizer(true);
            this.virtualizationContext = this.fillContext.getVirtualizationContext();
            this.virtualizationContext.setVirtualizer(virtualizer);
            this.setVirtualPageSize(parameterValues);
            JRVirtualizationContext.register(this.virtualizationContext, this.jasperPrint);
        }
        if (this.virtualizationContext != null && log.isDebugEnabled()) {
            log.debug("filler " + this.fillerId + " created virtualization context " + this.virtualizationContext);
        }
    }

    protected void setVirtualPageSize(Map<String, Object> parameterValues) {
        String pageSizeProp;
        Integer virtualPageSize = (Integer)parameterValues.get("net.sf.jasperreports.virtual.page.element.size");
        if (virtualPageSize == null && (pageSizeProp = this.jasperReport.getPropertiesMap().getProperty("net.sf.jasperreports.virtual.page.element.size")) != null) {
            virtualPageSize = JRPropertiesUtil.asInteger(pageSizeProp);
        }
        if (virtualPageSize != null) {
            if (log.isDebugEnabled()) {
                log.debug("virtual page size " + virtualPageSize);
            }
            this.virtualizationContext.setPageElementSize(virtualPageSize);
        }
    }

    @Override
    @continuable
    public JasperPrint fill(Map<String, Object> parameterValues, Connection conn) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        this.setConnectionParameterValue(parameterValues, conn);
        return this.fill(parameterValues);
    }

    protected void setConnectionParameterValue(Map<String, Object> parameterValues, Connection conn) {
        this.mainDataset.setConnectionParameterValue(parameterValues, conn);
    }

    @Override
    @continuable
    public JasperPrint fill(Map<String, Object> parameterValues, JRDataSource ds) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        this.setDatasourceParameterValue(parameterValues, ds);
        return this.fill(parameterValues);
    }

    protected void setDatasourceParameterValue(Map<String, Object> parameterValues, JRDataSource ds) {
        this.mainDataset.setDatasourceParameterValue(parameterValues, ds);
    }

    protected void setParameters(Map<String, Object> parameterValues) throws JRException {
        this.initVirtualizationContext(parameterValues);
        this.setFormatFactory(parameterValues);
        this.setIgnorePagination(parameterValues);
        if (this.parent == null) {
            ReportContext reportContext = (ReportContext)parameterValues.get("REPORT_CONTEXT");
            this.fillContext.setReportContext(reportContext);
        }
        this.mainDataset.setParameterValues(parameterValues);
        this.mainDataset.evaluateFieldProperties();
        this.mainDataset.initDatasource();
        this.scriptlet = this.mainDataset.delegateScriptlet;
        if (!this.isSubreport()) {
            this.fillContext.setMasterFormatFactory(this.getFormatFactory());
            this.fillContext.setMasterLocale(this.getLocale());
            this.fillContext.setMasterTimeZone(this.getTimeZone());
        }
    }

    protected void setBookmarkHelper() {
        boolean isCreateBookmarks = this.propertiesUtil.getBooleanProperty(this.mainDataset, "net.sf.jasperreports.print.create.bookmarks", false);
        if (isCreateBookmarks) {
            boolean collapseMissingLevels = this.propertiesUtil.getBooleanProperty(this.mainDataset, "net.sf.jasperreports.print.collapse.missing.bookmark.levels", false);
            this.bookmarkHelper = new BookmarkHelper(collapseMissingLevels);
        }
    }

    protected void setIgnorePagination(Map<String, Object> parameterValues) {
        Boolean ownIgnorePagination;
        boolean ignore = this.parent == null ? this.getOwnIgnorePagination(parameterValues, false) : (this.parent.isParentPagination() ? this.parent.getFiller().ignorePagination : ((ownIgnorePagination = this.getOwnIgnorePagination(parameterValues, true)) != null ? ownIgnorePagination : this.parent.getFiller().ignorePagination));
        this.ignorePagination = ignore;
        parameterValues.put("IS_IGNORE_PAGINATION", this.ignorePagination);
        this.ignorePaginationSet(parameterValues);
    }

    protected Boolean getOwnIgnorePagination(Map<String, Object> parameterValues, boolean onlySetAttribute) {
        Boolean isIgnorePaginationParam = (Boolean)parameterValues.get("IS_IGNORE_PAGINATION");
        if (isIgnorePaginationParam != null) {
            return isIgnorePaginationParam;
        }
        boolean ignorePaginationAttribute = this.jasperReport.isIgnorePagination();
        if (ignorePaginationAttribute) {
            return ignorePaginationAttribute;
        }
        return onlySetAttribute ? null : Boolean.valueOf(false);
    }

    protected abstract void ignorePaginationSet(Map<String, Object> var1);

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted || this.threadInterrupted || this.parent != null && this.parent.getFiller().isInterrupted();
    }

    protected boolean isDeliberatelyInterrupted() {
        return this.isInterrupted || this.parent != null && this.parent.getFiller().isDeliberatelyInterrupted();
    }

    protected void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    protected void checkInterrupted() {
        if (Thread.interrupted()) {
            this.threadInterrupted = true;
        }
        if (this.isInterrupted()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": interrupting");
            }
            throw new JRFillInterruptedException();
        }
    }

    @Override
    public JRFillContext getFillContext() {
        return this.fillContext;
    }

    public JRVirtualizationContext getVirtualizationContext() {
        return this.virtualizationContext;
    }

    public JRFillDataset getMainDataset() {
        return this.mainDataset;
    }

    public Map<String, Object> getParameterValuesMap() {
        return this.mainDataset.getParameterValuesMap();
    }

    protected Map<String, JRFillParameter> getParametersMap() {
        return this.mainDataset.parametersMap;
    }

    public Object getParameterValue(String parameterName) {
        return this.mainDataset.getParameterValue(parameterName);
    }

    protected Locale getLocale() {
        return this.mainDataset.getLocale();
    }

    protected TimeZone getTimeZone() {
        return this.mainDataset.timeZone;
    }

    protected void addVariableCalculationReq(String variableName, CalculationEnum calculation) {
        this.mainDataset.addVariableCalculationReq(variableName, calculation);
    }

    public JRFillVariable getVariable(String variableName) {
        return this.mainDataset.getVariable(variableName);
    }

    public Object getVariableValue(String variableName) {
        return this.mainDataset.getVariableValue(variableName);
    }

    protected JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.calculator;
    }

    protected boolean isSubreport() {
        return this.parent != null;
    }

    protected boolean isMasterReport() {
        return this.parent == null;
    }

    public Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.mainDataset.evaluateExpression(expression, evaluation);
    }

    protected final void setFormatFactory(Map<String, Object> parameterValues) {
        this.formatFactory = (FormatFactory)parameterValues.get("REPORT_FORMAT_FACTORY");
        if (this.formatFactory == null) {
            this.formatFactory = DefaultFormatFactory.createFormatFactory(this.jasperReport.getFormatFactoryClass());
            parameterValues.put("REPORT_FORMAT_FACTORY", this.formatFactory);
        }
    }

    protected FormatFactory getFormatFactory() {
        return this.formatFactory;
    }

    protected void addLastPageBookmarks() {
        if (this.bookmarkHelper != null) {
            int pageIndex;
            int n = pageIndex = this.jasperPrint.getPages() == null ? -1 : this.jasperPrint.getPages().size() - 1;
            if (pageIndex >= 0) {
                JRPrintPage page = this.jasperPrint.getPages().get(pageIndex);
                this.bookmarkHelper.addBookmarks(page, pageIndex);
            }
        }
    }

    public void updateBookmark(JRPrintElement element) {
        if (this.isMasterReport()) {
            if (this.bookmarkHelper != null) {
                this.bookmarkHelper.updateBookmark(element);
            }
        } else {
            this.parent.updateBookmark(element);
        }
    }

    @Override
    public void cancelFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": cancelling");
        }
        this.fillContext.markCanceled();
        if (this.fillContext.cancelRunningQuery()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": query cancelled");
            }
        } else {
            Thread t = this.fillingThread;
            if (t != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Interrupting thread " + t);
                }
                t.interrupt();
            }
        }
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, JREvaluationTime evaluationTime, FillPageKey pageKey) {
        if (log.isDebugEnabled()) {
            log.debug("Adding evaluation of " + printElement + " by " + element + " for evaluation " + evaluationTime);
        }
        this.delayedActions.addDelayedAction(element, printElement, evaluationTime, pageKey);
    }

    protected void resolveBoundElements(JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        this.delayedActions.runActions(evaluationTime, evaluation);
    }

    protected void resolveMasterBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_MASTER, (byte)3);
    }

    public void recordUsedPageWidth(int width) {
        if (width > this.usedPageWidth) {
            this.usedPageWidth = width;
        }
    }

    public int getUsedPageWidth() {
        return this.usedPageWidth;
    }
}

