/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.pdf.PdfWriter;
import net.sf.jasperreports.engine.export.XmpWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfXmpCreator {
    private static final Logger log = LoggerFactory.getLogger(PdfXmpCreator.class);
    private static final boolean XMP_LIBRARY = PdfXmpCreator.determineXmpLibrary();

    private static boolean determineXmpLibrary() {
        try {
            Class.forName("com.adobe.xmp.XMPMetaFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            log.info("Adobe XMP library not found");
            return false;
        }
    }

    public static boolean supported() {
        return XMP_LIBRARY;
    }

    public static byte[] createXmpMetadata(PdfWriter pdfWriter) {
        XmpWriter writer = new XmpWriter(pdfWriter);
        return writer.createXmpMetadata();
    }
}

