/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.type.PdfFieldBorderStyleEnum;
import net.sf.jasperreports.engine.export.type.PdfFieldCheckTypeEnum;
import net.sf.jasperreports.engine.export.type.PdfFieldTypeEnum;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRPdfaIccProfileNotFoundException;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PdfExporterConfiguration;
import net.sf.jasperreports.export.PdfReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.export.pdf.FontRecipient;
import net.sf.jasperreports.export.pdf.LineCapStyle;
import net.sf.jasperreports.export.pdf.PdfChunk;
import net.sf.jasperreports.export.pdf.PdfContent;
import net.sf.jasperreports.export.pdf.PdfDocument;
import net.sf.jasperreports.export.pdf.PdfDocumentWriter;
import net.sf.jasperreports.export.pdf.PdfFontStyle;
import net.sf.jasperreports.export.pdf.PdfImage;
import net.sf.jasperreports.export.pdf.PdfOutlineEntry;
import net.sf.jasperreports.export.pdf.PdfPhrase;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfProducerContext;
import net.sf.jasperreports.export.pdf.PdfProducerFactory;
import net.sf.jasperreports.export.pdf.PdfRadioCheck;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;
import net.sf.jasperreports.export.pdf.PdfTextChunk;
import net.sf.jasperreports.export.pdf.PdfTextField;
import net.sf.jasperreports.export.pdf.TextDirection;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.type.PdfPermissionsEnum;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import net.sf.jasperreports.export.type.PdfaConformanceEnum;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.WrappingImageDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRPdfExporter
extends JRAbstractExporter<PdfReportConfiguration, PdfExporterConfiguration, OutputStreamExporterOutput, JRPdfExporterContext> {
    private static final Logger log = LoggerFactory.getLogger(JRPdfExporter.class);
    public static final String PDF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pdf.";
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR = "export.pdf.document.error";
    public static final String EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR = "export.pdf.font.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.pdf.report.generation.error";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String PDF_FIELD_TYPE = "net.sf.jasperreports.export.pdf.field.type";
    public static final String PDF_FIELD_TEXT_MULTILINE = "net.sf.jasperreports.export.pdf.field.text.multiline";
    public static final String PDF_FIELD_VALUE = "net.sf.jasperreports.export.pdf.field.value";
    public static final String PDF_FIELD_CHECK_TYPE = "net.sf.jasperreports.export.pdf.field.check.type";
    public static final String PDF_FIELD_NAME = "net.sf.jasperreports.export.pdf.field.name";
    public static final String PDF_FIELD_CHECKED = "net.sf.jasperreports.export.pdf.field.checked";
    public static final String PDF_FIELD_READ_ONLY = "net.sf.jasperreports.export.pdf.field.read.only";
    public static final String PDF_FIELD_BORDER_STYLE = "net.sf.jasperreports.export.pdf.field.border.style";
    public static final String PDF_FIELD_CHOICE_SEPARATORS = "net.sf.jasperreports.export.pdf.field.choice.separators";
    public static final String PDF_FIELD_CHOICES = "net.sf.jasperreports.export.pdf.field.choices";
    public static final String PDF_FIELD_COMBO_EDIT = "net.sf.jasperreports.export.pdf.field.combo.edit";
    public static final String PDF_EXPORTER_KEY = "net.sf.jasperreports.pdf";
    public static final String PDF_PRODUCER_FACTORY_PROPERTY = "net.sf.jasperreports.export.pdf.producer.factory";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered;
    private static final JRSingletonCache<PdfProducerFactory> pdfProducerCache;
    protected PdfProducer pdfProducer;
    protected PdfContent pdfContent;
    protected JRPdfExporterTagHelper tagHelper = new JRPdfExporterTagHelper(this);
    protected int reportIndex;
    protected PrintPageFormat pageFormat;
    protected int crtDocumentPageNumber;
    protected int permissions;
    protected RenderersCache renderersCache;
    protected Map<String, Pair<PdfImage, ExifOrientationEnum>> loadedImagesMap;
    protected PdfImage pxImage;
    private BookmarkStack bookmarkStack;
    private int crtOddPageOffsetX;
    private int crtOddPageOffsetY;
    private int crtEvenPageOffsetX;
    private int crtEvenPageOffsetY;
    private boolean awtIgnoreMissingFont;
    private boolean defaultIndentFirstLine;
    private boolean defaultJustifyLastLine;
    private PdfVersionEnum minimalVersion;

    public JRPdfExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPdfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<PdfExporterConfiguration> getConfigurationInterface() {
        return PdfExporterConfiguration.class;
    }

    @Override
    protected Class<PdfReportConfiguration> getItemConfigurationInterface() {
        return PdfReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    protected PdfImage getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = this.pdfProducer.createImage(JRLoader.loadBytesFromResource("net/sf/jasperreports/engine/images/pixel.GIF"), false);
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.pxImage;
    }

    @Override
    public void exportReport() throws JRException {
        JRPdfExporter.registerFonts();
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        Boolean isTagged = configuration.isTagged();
        if (isTagged != null) {
            this.tagHelper.setTagged(isTagged);
        }
        this.tagHelper.setLanguage(configuration.getTagLanguage());
        this.permissions = JRPdfExporter.getIntegerPermissions(configuration.getAllowedPermissions()) & ~JRPdfExporter.getIntegerPermissions(configuration.getDeniedPermissions());
        this.crtDocumentPageNumber = 0;
        this.awtIgnoreMissingFont = this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font");
        this.pdfProducer = this.createPdfProducer();
    }

    @Override
    protected void initReport() {
        super.initReport();
        PdfReportConfiguration configuration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
        this.pdfProducer.setForceLineBreakPolicy(configuration.isForceLineBreakPolicy());
        this.defaultIndentFirstLine = this.propertiesUtil.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.awt.indent.first.line", true);
        this.defaultJustifyLastLine = this.propertiesUtil.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.awt.justify.last.line", false);
        this.crtOddPageOffsetX = configuration.getOddPageOffsetX();
        this.crtOddPageOffsetY = configuration.getOddPageOffsetY();
        this.crtEvenPageOffsetX = configuration.getEvenPageOffsetX();
        this.crtEvenPageOffsetY = configuration.getEvenPageOffsetY();
        this.pdfProducer.initReport();
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        this.loadedImagesMap = new HashMap<String, Pair<PdfImage, ExifOrientationEnum>>();
    }

    protected PdfProducerFactory getPdfProducerFactory() {
        String producerFactory = this.propertiesUtil.getProperty(PDF_PRODUCER_FACTORY_PROPERTY);
        try {
            return pdfProducerCache.getCachedInstance(producerFactory);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected PdfProducerContext createPdfProducerContext() {
        return new PdfProducerContext(){

            @Override
            public JasperReportsContext getJasperReportsContext() {
                return JRPdfExporter.this.jasperReportsContext;
            }

            @Override
            public JRPropertiesUtil getProperties() {
                return JRPdfExporter.this.propertiesUtil;
            }

            @Override
            public FontUtil getFontUtil() {
                return JRPdfExporter.this.fontUtil;
            }

            @Override
            public JRStyledTextUtil getStyledTextUtil() {
                return JRPdfExporter.this.styledTextUtil;
            }

            @Override
            public boolean isTagged() {
                return JRPdfExporter.this.tagHelper.isTagged;
            }

            @Override
            public void setMinimalVersion(PdfVersionEnum version) {
                JRPdfExporter.this.minimalVersion = version;
            }

            @Override
            public JasperPrint getCurrentJasperPrint() {
                return JRPdfExporter.this.getCurrentJasperPrint();
            }

            @Override
            public void setFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines, FontRecipient recipient) {
                JRPdfExporter.this.setFont(attributes, locale, setFontLines, recipient);
            }

            @Override
            public JRException handleDocumentException(Exception e) {
                return new JRException(JRPdfExporter.EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR, new Object[]{JRPdfExporter.this.jasperPrint.getName()}, e);
            }
        };
    }

    protected PdfProducer createPdfProducer() {
        PdfProducerFactory producerFactory = this.getPdfProducerFactory();
        PdfProducerContext producerContext = this.createPdfProducerContext();
        return producerFactory.createProducer(producerContext);
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        this.pageFormat = this.jasperPrint.getPageFormat(0);
        PdfDocument document = this.pdfProducer.createDocument(this.pageFormat);
        boolean closeDocuments = true;
        try {
            String pdfJavaScript;
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            PdfDocumentWriter pdfWriter = this.pdfProducer.createWriter(os);
            this.tagHelper.setPdfProducer(this.pdfProducer);
            PdfVersionEnum pdfVersion = configuration.getPdfVersion();
            if (pdfVersion != null) {
                pdfWriter.setPdfVersion(pdfVersion);
            }
            if (this.minimalVersion != null) {
                pdfWriter.setMinimalPdfVersion(this.minimalVersion);
            }
            if (configuration.isCompressed().booleanValue()) {
                pdfWriter.setFullCompression();
            }
            if (configuration.isEncrypted().booleanValue()) {
                int perms = configuration.isOverrideHints() == null || configuration.isOverrideHints().booleanValue() ? (configuration.getPermissions() != null ? configuration.getPermissions() : this.permissions) : (this.permissions != 0 ? this.permissions : (configuration.getPermissions() != null ? configuration.getPermissions() : 0));
                pdfWriter.setEncryption(configuration.getUserPassword(), configuration.getOwnerPassword(), perms, configuration.is128BitKey());
            }
            PdfPrintScalingEnum printScaling = configuration.getPrintScaling();
            pdfWriter.setPrintScaling(printScaling);
            boolean justifiedLetterSpacing = this.propertiesUtil.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.pdf.justified.letter.spacing", false);
            if (!justifiedLetterSpacing) {
                pdfWriter.setNoSpaceCharRatio();
            }
            if ((title = configuration.getMetadataTitle()) != null) {
                document.addTitle(title);
                if (configuration.isDisplayMetadataTitle().booleanValue()) {
                    pdfWriter.setDisplayMetadataTitle();
                }
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                document.addAuthor(author);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                document.addSubject(subject);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                document.addKeywords(keywords);
            }
            if ((creator = configuration.getMetadataCreator()) == null) {
                creator = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
            }
            document.addCreator(creator);
            pdfWriter.setTabOrderStructure();
            String language = configuration.getTagLanguage();
            if (language != null) {
                pdfWriter.setLanguage(language);
            }
            PdfaConformanceEnum pdfaConformance = configuration.getPdfaConformance();
            boolean gotPdfa = false;
            if (pdfaConformance != null && pdfaConformance != PdfaConformanceEnum.NONE) {
                pdfWriter.setPdfaConformance(pdfaConformance);
                gotPdfa = true;
            }
            if (gotPdfa) {
                pdfWriter.createXmpMetadata(title, subject, keywords);
            } else {
                pdfWriter.setRgbTransparencyBlending(true);
            }
            document.open();
            if (gotPdfa) {
                String iccProfilePath = configuration.getIccProfilePath();
                if (iccProfilePath != null) {
                    InputStream iccIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(iccProfilePath);
                    pdfWriter.setIccProfilePath(iccProfilePath, iccIs);
                } else {
                    throw new JRPdfaIccProfileNotFoundException();
                }
            }
            if ((pdfJavaScript = configuration.getPdfJavaScript()) != null) {
                pdfWriter.addJavaScript(pdfJavaScript);
            }
            this.pdfContent = this.pdfProducer.createPdfContent();
            this.tagHelper.init();
            List<ExporterInputItem> items = this.exporterInput.getItems();
            this.initBookmarks(items);
            boolean isCreatingBatchModeBookmarks = configuration.isCreatingBatchModeBookmarks();
            this.reportIndex = 0;
            while (this.reportIndex < items.size()) {
                ExporterInputItem item = items.get(this.reportIndex);
                this.setCurrentExporterInputItem(item);
                this.pageFormat = this.jasperPrint.getPageFormat(0);
                this.setPageSize(null);
                List<JRPrintPage> pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (items.size() > 1) {
                        this.pdfProducer.newPage();
                        if (isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                    }
                    PdfReportConfiguration lcItemConfiguration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
                    boolean sizePageToContent = lcItemConfiguration.isSizePageToContent();
                    PrintPageFormat oldPageFormat = null;
                    JRAbstractExporter.PageRange pageRange = this.getPageRange();
                    int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                    int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                    for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(pageIndex);
                        if (sizePageToContent || oldPageFormat != this.pageFormat) {
                            this.setPageSize(sizePageToContent ? page : null);
                        }
                        this.pdfProducer.newPage();
                        this.pdfProducer.getPdfContent().setLineCap(LineCapStyle.PROJECTING_SQUARE);
                        this.writePageAnchor(pageIndex);
                        ++this.crtDocumentPageNumber;
                        this.exportPage(page);
                        oldPageFormat = this.pageFormat;
                    }
                } else {
                    this.pdfProducer.newPage();
                    this.pdfContent.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.pdfProducer.close();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR, new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.pdfProducer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) {
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(attributes, new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
        PdfTextChunk chunk = this.pdfProducer.createChunk(" ", attributes, this.getLocale());
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        this.tagHelper.startPageAnchor();
        PdfPhrase phrase = this.pdfProducer.createPhrase(chunk);
        phrase.go(0.0f, this.pageFormat.getPageHeight().intValue(), 1.0f, 1.0f, 0.0f, 0.0f, PdfTextAlignment.LEFT, TextDirection.DEFAULT);
        this.tagHelper.endPageAnchor();
    }

    protected void setPageSize(JRPrintPage page) throws JRException, IOException {
        int pageWidth = 0;
        int pageHeight = 0;
        if (page != null) {
            List<JRPrintElement> elements = page.getElements();
            for (JRPrintElement element : elements) {
                int elementRight = element.getX() + element.getWidth();
                int elementBottom = element.getY() + element.getHeight();
                pageWidth = pageWidth < elementRight ? elementRight : pageWidth;
                pageHeight = pageHeight < elementBottom ? elementBottom : pageHeight;
            }
            pageWidth += this.pageFormat.getRightMargin().intValue();
            pageHeight += this.pageFormat.getBottomMargin().intValue();
        }
        pageWidth = pageWidth < this.pageFormat.getPageWidth() ? this.pageFormat.getPageWidth() : pageWidth;
        pageHeight = pageHeight < this.pageFormat.getPageHeight() ? this.pageFormat.getPageHeight() : pageHeight;
        this.pdfProducer.setPageSize(this.pageFormat, pageWidth, pageHeight);
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.tagHelper.startPage();
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        this.pdfProducer.endPage();
        this.tagHelper.endPage();
        JRExportProgressMonitor progressMonitor = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.tagHelper.startElement(element);
                String strFieldType = element.getPropertiesMap().getProperty(PDF_FIELD_TYPE);
                PdfFieldTypeEnum fieldType = PdfFieldTypeEnum.getByName(strFieldType);
                if (fieldType == PdfFieldTypeEnum.CHECK) {
                    this.exportFieldCheck(element);
                } else if (fieldType == PdfFieldTypeEnum.RADIO) {
                    this.exportFieldRadio(element);
                } else if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                } else if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                } else if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                } else if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                } else if (element instanceof JRPrintText) {
                    if (fieldType == PdfFieldTypeEnum.TEXT || fieldType == PdfFieldTypeEnum.COMBO || fieldType == PdfFieldTypeEnum.LIST) {
                        this.exportFieldText((JRPrintText)element, fieldType);
                    } else {
                        this.exportText((JRPrintText)element);
                    }
                } else if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                } else if (element instanceof JRGenericPrintElement) {
                    this.exportGenericElement((JRGenericPrintElement)element);
                }
                this.tagHelper.endElement(element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            this.preparePen(line.getLinePen(), LineCapStyle.BUTT);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    } else {
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                }
            } else if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                    this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                }
            } else if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
            } else {
                this.pdfContent.strokeLine(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight(), line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
            }
            this.resetPen();
            this.pdfContent.setLineDash(0.0f);
            this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContent.setFillColor(rectangle.getBackcolor());
        this.preparePen(rectangle.getLinePen(), LineCapStyle.PROJECTING_SQUARE);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (rectangle.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContent.fillRoundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContent.strokeRoundRectangle((float)(rectangle.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContent.strokeRoundRectangle((float)(rectangle.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, rectangle.getRadius());
            } else {
                this.pdfContent.strokeRoundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
            }
        }
        this.resetPen();
        this.pdfContent.resetFillColor();
        this.pdfContent.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContent.setFillColor(ellipse.getBackcolor());
        this.preparePen(ellipse.getLinePen(), LineCapStyle.PROJECTING_SQUARE);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (ellipse.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContent.fillEllipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContent.strokeEllipse((float)(ellipse.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) + lineWidth / 3.0f);
                this.pdfContent.strokeEllipse((float)(ellipse.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) - lineWidth / 3.0f);
            } else {
                this.pdfContent.strokeEllipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
            }
        }
        this.resetPen();
        this.pdfContent.resetFillColor();
        this.pdfContent.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage printImage) throws IOException, JRException {
        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContent.setFillColor(printImage.getBackcolor());
            this.pdfContent.fillRectangle(printImage.getX() + this.getOffsetX(), this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY(), printImage.getWidth(), -printImage.getHeight());
            this.pdfContent.resetFillColor();
        }
        InternalImageProcessor imageProcessor = new InternalImageProcessor(printImage);
        Renderable renderer = printImage.getRenderer();
        if (renderer != null && imageProcessor.availableImageWidth > 0 && imageProcessor.availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block8: {
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, printImage.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block8;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                this.setAnchor(imageProcessorResult.chunk, printImage, printImage);
                this.setHyperlinkInfo(imageProcessorResult.chunk, printImage);
                this.tagHelper.startImage(printImage);
                PdfPhrase phrase = this.pdfProducer.createPhrase(imageProcessorResult.chunk);
                int upperY = this.pageFormat.getPageHeight() - printImage.getY() - imageProcessor.topPadding - this.getOffsetY() - imageProcessorResult.yoffset;
                int lowerX = printImage.getX() + imageProcessor.leftPadding + this.getOffsetX() + imageProcessorResult.xoffset;
                phrase.go(lowerX, upperY, (float)lowerX + imageProcessorResult.scaledWidth, (float)upperY - imageProcessorResult.scaledHeight, 0.0f, 0.0f, PdfTextAlignment.LEFT, TextDirection.DEFAULT);
                this.tagHelper.endImage();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), printImage);
        }
    }

    protected void setHyperlinkInfo(PdfChunk chunk, JRPrintHyperlink link) {
        if (link != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.pdf.ignore.hyperlink", link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        JRHyperlinkProducer hyperlinkProducer = this.getHyperlinkProducer(link);
                        String referenceURL = hyperlinkProducer == null ? link.getHyperlinkReference() : hyperlinkProducer.getHyperlink(link);
                        this.setReferenceHyperlink(chunk, link, referenceURL);
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() == null) break;
                        chunk.setLocalGoto(link.getHyperlinkAnchor());
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() == null) break;
                        chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                        break;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage());
                        break;
                    }
                    case CUSTOM: {
                        JRHyperlinkProducerFactory hyperlinkProducerFactory = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getHyperlinkProducerFactory();
                        if (hyperlinkProducerFactory == null) break;
                        String hyperlink = hyperlinkProducerFactory.produceHyperlink(link);
                        this.setReferenceHyperlink(chunk, link, hyperlink);
                        break;
                    }
                }
            }
        }
    }

    protected void setReferenceHyperlink(PdfChunk chunk, JRPrintHyperlink link, String referenceURL) {
        if (referenceURL != null) {
            switch (link.getHyperlinkTargetValue()) {
                case BLANK: {
                    chunk.setJavaScriptAction("if (app.viewerVersion < 7){this.getURL(\"" + referenceURL + "\");}else {app.launchURL(\"" + referenceURL + "\", true);};");
                    break;
                }
                default: {
                    chunk.setAnchor(referenceURL);
                }
            }
        }
    }

    @Override
    protected Locale getTextLocale(JRPrintText text) {
        return super.getTextLocale(text);
    }

    protected void getPhrase(AttributedString as, String text, JRPrintText textElement, PdfPhrase phrase) {
        int runLimit = 0;
        AttributedCharacterIterator iterator = as.getIterator();
        Locale locale = this.getTextLocale(textElement);
        boolean firstChunk = true;
        while (runLimit < text.length() && (runLimit = iterator.getRunLimit()) <= text.length()) {
            JRPrintHyperlink hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            PdfTextChunk chunk = this.getChunk(attributes, text.substring(iterator.getIndex(), runLimit), locale);
            if (firstChunk) {
                this.setAnchor(chunk, textElement, textElement);
            }
            if ((hyperlink = textElement).getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE) {
                hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
            }
            this.setHyperlinkInfo(chunk, hyperlink);
            phrase.add(chunk);
            iterator.setIndex(runLimit);
            firstChunk = false;
        }
    }

    protected PdfTextChunk getChunk(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        Object script;
        Color backcolor;
        PdfTextChunk chunk = this.pdfProducer.createChunk(text, attributes, locale);
        if (this.hasUnderline(attributes)) {
            chunk.setUnderline();
        }
        if (this.hasStrikethrough(attributes)) {
            chunk.setStrikethrough();
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setSuperscript();
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setSubscript();
            }
        }
        return chunk;
    }

    protected boolean hasUnderline(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Integer underline = (Integer)textAttributes.get(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(underline);
    }

    protected boolean hasStrikethrough(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Boolean strike = (Boolean)textAttributes.get(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(strike);
    }

    protected void setFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines, FontRecipient recipient) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        float fontSizeScale = 1.0f;
        Integer scriptStyle = (Integer)attributes.get(TextAttribute.SUPERSCRIPT);
        if (scriptStyle != null && (TextAttribute.SUPERSCRIPT_SUB.equals(scriptStyle) || TextAttribute.SUPERSCRIPT_SUPER.equals(scriptStyle))) {
            fontSizeScale = 0.6666667f;
        }
        String pdfFontName = null;
        String pdfEncoding = null;
        boolean isPdfEmbedded = false;
        boolean isPdfSimulatedBold = false;
        boolean isPdfSimulatedItalic = false;
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        if (fontInfo == null) {
            fontInfo = this.fontUtil.getFontInfo(jrFont.getFontName(), locale);
        }
        if (fontInfo == null) {
            pdfFontName = jrFont.getPdfFontName();
            pdfEncoding = jrFont.getPdfEncoding();
            isPdfEmbedded = jrFont.isPdfEmbedded();
        } else {
            FontFamily family = fontInfo.getFontFamily();
            int pdfFontStyle = 0;
            FontFace fontFace = fontInfo.getFontFace();
            if (fontFace != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = fontInfo.getStyle();
            }
            if (pdfFontName == null && jrFont.isBold() && jrFont.isItalic() && (fontFace = family.getBoldItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 3;
            }
            if (pdfFontName == null && jrFont.isBold() && (fontFace = family.getBoldFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 1;
            }
            if (pdfFontName == null && jrFont.isItalic() && (fontFace = family.getItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 2;
            }
            if (pdfFontName == null && (fontFace = family.getNormalFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 0;
            }
            if (pdfFontName == null) {
                pdfFontName = jrFont.getPdfFontName();
            }
            pdfEncoding = family.getPdfEncoding() == null ? jrFont.getPdfEncoding() : family.getPdfEncoding();
            isPdfEmbedded = family.isPdfEmbedded() == null ? jrFont.isPdfEmbedded() : family.isPdfEmbedded().booleanValue();
            isPdfSimulatedBold = jrFont.isBold() && (pdfFontStyle & 1) == 0;
            isPdfSimulatedItalic = jrFont.isItalic() && (pdfFontStyle & 2) == 0;
        }
        PdfFontStyle pdfFontStyle = new PdfFontStyle(isPdfSimulatedBold, isPdfSimulatedItalic, setFontLines && jrFont.isUnderline(), setFontLines && jrFont.isStrikeThrough());
        try {
            recipient.setFont(pdfFontName, pdfEncoding, isPdfEmbedded, jrFont.getFontsize() * fontSizeScale, pdfFontStyle, forecolor);
        }
        catch (Exception e) {
            initialException = e;
        }
        if (!recipient.hasFont()) {
            byte[] bytes = null;
            try {
                bytes = this.getRepository().getBytesFromLocation(pdfFontName);
            }
            catch (JRException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR, new Object[]{pdfFontName, pdfEncoding, isPdfEmbedded}, initialException);
            }
            recipient.setFont(pdfFontName, pdfEncoding, isPdfEmbedded, jrFont.getFontsize() * fontSizeScale, pdfFontStyle, forecolor, bytes);
        }
    }

    public void exportText(JRPrintText text) {
        JRStyledText styledText = this.styledTextUtil.getProcessedStyledText(text, this.noBackcolorSelector, null);
        if (styledText == null) {
            return;
        }
        AbstractPdfTextRenderer textRenderer = this.getTextRenderer(text, styledText);
        textRenderer.initialize(this, this.pdfProducer, this.tagHelper, text, styledText, this.getOffsetX(), this.getOffsetY());
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                angle = 1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = -1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContent.transform(atrans);
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            Color backcolor = text.getBackcolor();
            this.pdfContent.setFillColor(backcolor);
            this.pdfContent.fillRectangle(textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY(), textRenderer.getWidth(), -textRenderer.getHeight());
            this.pdfContent.resetFillColor();
        }
        int forecolorAlpha = this.getSingleForecolorAlpha(styledText);
        this.pdfContent.setFillColorAlpha(forecolorAlpha);
        if (styledText.length() > 0) {
            textRenderer.render();
        }
        this.pdfContent.resetFillColor();
        atrans = new AffineTransform();
        atrans.rotate(-angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContent.transform(atrans);
        this.exportBox(text.getLineBox(), text);
    }

    protected int getSingleForecolorAlpha(JRStyledText styledText) {
        Color forecolor = (Color)styledText.getGlobalAttributes().get(TextAttribute.FOREGROUND);
        if (forecolor == null || forecolor.getAlpha() == 255) {
            return 255;
        }
        List<JRStyledText.Run> runs = styledText.getRuns();
        if (runs.size() > 1) {
            for (JRStyledText.Run run : runs) {
                Color runForecolor = (Color)run.attributes.get(TextAttribute.FOREGROUND);
                if (runForecolor == null || runForecolor.getAlpha() == forecolor.getAlpha()) continue;
                return 255;
            }
        }
        return forecolor.getAlpha();
    }

    public void exportFieldText(JRPrintText text, PdfFieldTypeEnum fieldType) {
        String readOnly;
        float borderWidth;
        PdfTextField pdfTextField;
        String fieldName = text.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + text.getUUID() : fieldName;
        String value = null;
        value = text.getPropertiesMap().containsProperty(PDF_FIELD_VALUE) ? text.getPropertiesMap().getProperty(PDF_FIELD_VALUE) : text.getFullText();
        int llx = text.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX();
        int lly = this.jasperPrint.getPageHeight() - text.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY();
        int urx = llx + text.getWidth();
        int ury = this.jasperPrint.getPageHeight() - text.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - text.getHeight();
        switch (fieldType) {
            case TEXT: {
                pdfTextField = this.pdfProducer.createTextField(llx, lly, urx, ury, fieldName);
                if (value == null) break;
                pdfTextField.setText(value);
                break;
            }
            case COMBO: {
                String[] comboChoices = this.getPdfFieldChoices(text);
                pdfTextField = this.pdfProducer.createComboField(llx, lly, urx, ury, fieldName, value, comboChoices);
                if (!this.propertiesUtil.getBooleanProperty(PDF_FIELD_COMBO_EDIT, false, text, this.jasperPrint)) break;
                pdfTextField.setEdit();
                break;
            }
            case LIST: {
                String[] listChoices = this.getPdfFieldChoices(text);
                pdfTextField = this.pdfProducer.createListField(llx, lly, urx, ury, fieldName, value, listChoices);
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown field type " + fieldType);
            }
        }
        if (ModeEnum.OPAQUE == text.getModeValue()) {
            pdfTextField.setBackgroundColor(text.getBackcolor());
        }
        pdfTextField.setTextColor(text.getForecolor());
        switch (text.getHorizontalTextAlign()) {
            case RIGHT: {
                pdfTextField.setAlignment(PdfTextAlignment.RIGHT);
                break;
            }
            case CENTER: {
                pdfTextField.setAlignment(PdfTextAlignment.CENTER);
                break;
            }
            case JUSTIFIED: {
                pdfTextField.setAlignment(PdfTextAlignment.JUSTIFIED);
                break;
            }
            default: {
                pdfTextField.setAlignment(PdfTextAlignment.LEFT);
            }
        }
        JRPen pen = this.getFieldPen(text);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            pdfTextField.setBorderColor(pen.getLineColor());
            pdfTextField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, text, this.jasperPrint);
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyleValue() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            pdfTextField.setBorderStyle(borderStyle);
        }
        if ((readOnly = text.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY)) != null && Boolean.valueOf(readOnly).booleanValue()) {
            pdfTextField.setReadOnly();
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(attributes, text);
        pdfTextField.setFont(attributes, this.getLocale());
        pdfTextField.setFontSize(text.getFontsize());
        boolean isMultiLine = JRPropertiesUtil.asBoolean(text.getPropertiesMap().getProperty(PDF_FIELD_TEXT_MULTILINE), false);
        if (isMultiLine) {
            pdfTextField.setMultiline();
        }
        if (this.pageFormat.getOrientation() == OrientationEnum.LANDSCAPE) {
            pdfTextField.setRotation(90);
        }
        pdfTextField.setVisible();
        pdfTextField.add();
    }

    protected String[] getPdfFieldChoices(JRPrintText text) {
        String[] choices = null;
        String strChoices = text.getPropertiesMap().getProperty(PDF_FIELD_CHOICES);
        if (strChoices != null && strChoices.trim().length() > 0) {
            String choiceSeparators = this.propertiesUtil.getProperty(PDF_FIELD_CHOICE_SEPARATORS, text, this.jasperPrint);
            StringTokenizer tkzer = new StringTokenizer(strChoices, choiceSeparators);
            ArrayList<String> choicesList = new ArrayList<String>();
            while (tkzer.hasMoreTokens()) {
                choicesList.add(tkzer.nextToken());
            }
            choices = choicesList.toArray(new String[choicesList.size()]);
        }
        return choices;
    }

    public void exportFieldCheck(JRPrintElement element) {
        String readOnly;
        String checked;
        float borderWidth;
        String fieldName = element.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + element.getUUID() : fieldName;
        PdfRadioCheck checkField = this.pdfProducer.createCheckField(element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY(), element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX() + element.getWidth(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - element.getHeight(), fieldName, "checked");
        PdfFieldCheckTypeEnum checkType = PdfFieldCheckTypeEnum.getByName(element.getPropertiesMap().getProperty(PDF_FIELD_CHECK_TYPE));
        if (checkType != null) {
            checkField.setCheckType(checkType);
        }
        if (ModeEnum.OPAQUE == element.getModeValue()) {
            checkField.setBackgroundColor(element.getBackcolor());
        }
        checkField.setTextColor(element.getForecolor());
        JRPen pen = this.getFieldPen(element);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            checkField.setBorderColor(pen.getLineColor());
            checkField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, element, this.jasperPrint);
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyleValue() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            checkField.setBorderStyle(borderStyle);
        }
        if ((checked = element.getPropertiesMap().getProperty(PDF_FIELD_CHECKED)) != null) {
            checkField.setChecked(Boolean.valueOf(checked));
        }
        if ((readOnly = element.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY)) != null && Boolean.valueOf(readOnly).booleanValue()) {
            checkField.setReadOnly();
        }
        checkField.add();
    }

    public void exportFieldRadio(JRPrintElement element) throws IOException {
        float borderWidth;
        String fieldName = element.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + element.getUUID() : fieldName;
        PdfRadioCheck radioField = this.pdfProducer.getRadioField(element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY(), element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX() + element.getWidth(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - element.getHeight(), fieldName, "FIELD_" + element.getUUID());
        PdfFieldCheckTypeEnum checkType = PdfFieldCheckTypeEnum.getByName(element.getPropertiesMap().getProperty(PDF_FIELD_CHECK_TYPE));
        if (checkType != null) {
            radioField.setCheckType(checkType);
        }
        if (ModeEnum.OPAQUE == element.getModeValue()) {
            radioField.setBackgroundColor(element.getBackcolor());
        }
        radioField.setTextColor(element.getForecolor());
        JRPen pen = this.getFieldPen(element);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            radioField.setBorderColor(pen.getLineColor());
            radioField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, element, this.jasperPrint);
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyleValue() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            radioField.setBorderStyle(borderStyle);
        }
        radioField.setOnValue("FIELD_" + element.getUUID());
        String checked = element.getPropertiesMap().getProperty(PDF_FIELD_CHECKED);
        radioField.setChecked(Boolean.valueOf(checked));
        String readOnly = element.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY);
        if (readOnly != null && Boolean.valueOf(readOnly).booleanValue()) {
            radioField.setReadOnly();
        }
        radioField.addToGroup();
    }

    protected JRPen getFieldPen(JRPrintElement element) {
        JRLineBox box;
        JRPen pen = null;
        JRLineBox jRLineBox = box = element instanceof JRBoxContainer ? ((JRBoxContainer)((Object)element)).getLineBox() : null;
        if (box == null) {
            pen = element instanceof JRCommonGraphicElement ? ((JRCommonGraphicElement)((Object)element)).getLinePen() : null;
        } else {
            Float lineWidth = box.getPen().getLineWidth();
            if (lineWidth.floatValue() == 0.0f) {
                if (((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getLeftPen()) && ((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getBottomPen()) && ((JRBasePen)((Object)box.getTopPen())).isIdentical(box.getRightPen()) && box.getTopPen().getLineWidth().floatValue() > 0.0f) {
                    pen = new JRBasePen(box);
                    pen.setLineWidth(box.getTopPen().getLineWidth());
                    pen.setLineColor(box.getTopPen().getLineColor());
                    pen.setLineStyle(box.getTopPen().getLineStyleValue());
                }
            } else {
                pen = new JRBasePen(box);
                pen.setLineWidth(lineWidth);
                pen.setLineColor(box.getPen().getLineColor());
                pen.setLineStyle(box.getPen().getLineStyleValue());
            }
        }
        return pen;
    }

    protected AbstractPdfTextRenderer getTextRenderer(JRPrintText text, JRStyledText styledText) {
        Locale textLocale = this.getTextLocale(text);
        AbstractPdfTextRenderer textRenderer = this.pdfProducer.getTextRenderer(text, styledText, textLocale, this.awtIgnoreMissingFont, this.defaultIndentFirstLine, this.defaultJustifyLastLine);
        return textRenderer;
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), element);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), element);
        this.pdfContent.setLineDash(0.0f);
        this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContent.setLineDash(0.0f);
        this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(topPen, LineCapStyle.BUTT);
            if (topPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY);
            }
            this.resetPen();
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(leftPen, LineCapStyle.BUTT);
            if (leftPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, (float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine(element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
            }
            this.resetPen();
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(bottomPen, LineCapStyle.BUTT);
            if (bottomPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight(), (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight());
            }
            this.resetPen();
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(rightPen, LineCapStyle.BUTT);
            if (rightPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine(element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
            }
            this.resetPen();
        }
    }

    private void preparePen(JRPen pen, LineCapStyle lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        PdfContent pdfContent = this.pdfProducer.getPdfContent();
        pdfContent.setLineWidth(lineWidth);
        pdfContent.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContent.setStrokeColor(color);
        block0 : switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                pdfContent.setLineWidth(lineWidth / 3.0f);
                pdfContent.setLineDash(0.0f);
                break;
            }
            case DOTTED: {
                switch (lineCap) {
                    case BUTT: {
                        pdfContent.setLineDash(lineWidth, lineWidth, 0.0f);
                        break block0;
                    }
                    case PROJECTING_SQUARE: {
                        pdfContent.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                        break block0;
                    }
                }
                break;
            }
            case DASHED: {
                switch (lineCap) {
                    case BUTT: {
                        pdfContent.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break block0;
                    }
                    case PROJECTING_SQUARE: {
                        pdfContent.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                        break block0;
                    }
                }
                break;
            }
            default: {
                pdfContent.setLineDash(0.0f);
            }
        }
    }

    private void resetPen() {
        this.pdfContent.resetStrokeColor();
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List<JRPropertiesUtil.PropertySuffix> fontDirs;
            List<JRPropertiesUtil.PropertySuffix> fontFiles = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_FILES_PREFIX);
            if (!fontFiles.isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix font : fontFiles) {
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register((String)file, (String)alias);
                }
            }
            if (!(fontDirs = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_DIRS_PREFIX)).isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix dir : fontDirs) {
                    FontFactory.registerDirectory((String)dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks(List<ExporterInputItem> items) {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = items.size() > 1 && ((PdfExporterConfiguration)this.getCurrentConfiguration()).isCreatingBatchModeBookmarks() != false ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfProducer.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level >= level) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        if (!((PdfReportConfiguration)this.getCurrentItemConfiguration()).isCollapseMissingBookmarkLevels().booleanValue()) {
            for (int i = parent.level + 1; i < level; ++i) {
                Bookmark emptyBookmark = new Bookmark(parent, EMPTY_BOOKMARK_TITLE);
                this.bookmarkStack.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        int height = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.pageFormat.getPageHeight() - y : y;
        Bookmark bookmark = new Bookmark(parent, x, height, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(PdfChunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                int x = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetX() + element.getX() : this.getOffsetY() + element.getY();
                int y = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetY() + element.getY() : this.getOffsetX() + element.getX();
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            PdfContent pdfContent = this.pdfProducer.getPdfContent();
            pdfContent.setFillColor(backcolor);
            pdfContent.fillRectangle(x, this.pageFormat.getPageHeight() - y, frame.getWidth(), -frame.getHeight());
            pdfContent.resetFillColor();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), frame);
    }

    protected PrintPageFormat getCurrentPageFormat() {
        return this.pageFormat;
    }

    @Override
    protected int getOffsetX() {
        return super.getOffsetX() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetX : this.crtOddPageOffsetX));
    }

    @Override
    protected int getOffsetY() {
        return super.getOffsetY() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetY : this.crtOddPageOffsetY));
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPdfHandler handler = (GenericElementPdfHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PDF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRPdfExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug("No PDF generic element handler for " + element.getGenericType());
        }
    }

    @Override
    public String getExporterKey() {
        return PDF_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return PDF_EXPORTER_PROPERTIES_PREFIX;
    }

    public static int getIntegerPermissions(String permissions) {
        int permission = 0;
        if (permissions != null && permissions.length() > 0) {
            String[] perms;
            for (String perm : perms = permissions.split("\\|")) {
                if (PdfPermissionsEnum.ALL.equals(PdfPermissionsEnum.getByName(perm))) {
                    permission = PdfExporterConfiguration.ALL_PERMISSIONS;
                    break;
                }
                if (perm == null || perm.length() <= 0) continue;
                permission |= PdfPermissionsEnum.getByName(perm).getPdfPermission().intValue();
            }
        }
        return permission;
    }

    static {
        pdfProducerCache = new JRSingletonCache<PdfProducerFactory>(PdfProducerFactory.class);
    }

    protected static class BookmarkStack {
        LinkedList<Bookmark> stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return this.stack.removeLast();
        }

        Bookmark peek() {
            return this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutlineEntry pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this.pdfOutline = parent.pdfOutline.createChild(title, x, top);
            this.level = parent.level + 1;
        }

        Bookmark(Bookmark parent, String title) {
            this.pdfOutline = parent.pdfOutline.createChild(title);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutlineEntry pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }

    private class InternalImageProcessorResult {
        private final PdfChunk chunk;
        private final float scaledWidth;
        private final float scaledHeight;
        private final int xoffset;
        private final int yoffset;

        private InternalImageProcessorResult(PdfChunk chunk, float scaledWidth, float scaledHeight, int xoffset, int yoffset) {
            this.chunk = chunk;
            this.scaledWidth = scaledWidth;
            this.scaledHeight = scaledHeight;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage printImage;
        private final RenderersCache imageRenderersCache;
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;
        private final int availableImageWidth;
        private final int availableImageHeight;

        private InternalImageProcessor(JRPrintImage printImage) {
            this.printImage = printImage;
            this.imageRenderersCache = printImage.isUsingCache() ? JRPdfExporter.this.renderersCache : new RenderersCache(JRPdfExporter.this.getJasperReportsContext());
            this.topPadding = printImage.getLineBox().getTopPadding();
            this.leftPadding = printImage.getLineBox().getLeftPadding();
            this.bottomPadding = printImage.getLineBox().getBottomPadding();
            this.rightPadding = printImage.getLineBox().getRightPadding();
            int tmpAvailableImageWidth = printImage.getWidth() - this.leftPadding - this.rightPadding;
            this.availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = printImage.getHeight() - this.topPadding - this.bottomPadding;
            this.availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException, IOException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            if (renderer instanceof Graphics2DRenderable) {
                imageProcessorResult = this.processGraphics2D((Graphics2DRenderable)((Object)renderer));
            } else if (renderer instanceof DataRenderable) {
                boolean isSvgData = JRPdfExporter.this.getRendererUtil().isSvgData((DataRenderable)((Object)renderer));
                if (isSvgData) {
                    imageProcessorResult = this.processGraphics2D(new WrappingSvgDataToGraphics2DRenderer((DataRenderable)((Object)renderer)));
                } else {
                    switch (this.printImage.getScaleImageValue()) {
                        case CLIP: {
                            imageProcessorResult = this.processImageClip(new WrappingImageDataToGraphics2DRenderer((DataRenderable)((Object)renderer)));
                            break;
                        }
                        case FILL_FRAME: {
                            imageProcessorResult = this.processImageFillFrame(renderer.getId(), (DataRenderable)((Object)renderer));
                            break;
                        }
                        default: {
                            imageProcessorResult = this.processImageRetainShape(renderer.getId(), (DataRenderable)((Object)renderer));
                        }
                    }
                }
            } else {
                throw new JRException("engine.renderable.must.implement.interface", renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName());
            }
            return imageProcessorResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processImageClip(Graphics2DRenderable renderer) throws JRException, IOException {
            DataRenderable dataRenderable;
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            ExifOrientationEnum exifOrientation = ExifOrientationEnum.NORMAL;
            DataRenderable dataRenderable2 = dataRenderable = renderer instanceof DataRenderable ? (DataRenderable)((Object)renderer) : null;
            if (dataRenderable != null) {
                exifOrientation = ImageUtil.getExifOrientation(dataRenderable.getData(JRPdfExporter.this.getJasperReportsContext()));
            }
            if (ExifOrientationEnum.LEFT == exifOrientation || ExifOrientationEnum.RIGHT == exifOrientation) {
                int t = normalWidth;
                normalWidth = normalHeight;
                normalHeight = t;
            }
            int minWidth = Math.min(normalWidth, this.availableImageWidth);
            int minHeight = Math.min(normalHeight, this.availableImageHeight);
            int xoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageWidth - normalWidth));
            int yoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageHeight - normalHeight));
            int translateX = xoffset;
            int translateY = yoffset;
            int angle = 0;
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    xoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageWidth - normalHeight));
                    yoffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.printImage)) * (float)(this.availableImageHeight - normalWidth));
                    translateX = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageHeight - normalWidth));
                    translateY = xoffset;
                    angle = 90;
                    break;
                }
                case RIGHT: {
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    xoffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.printImage)) * (float)(this.availableImageWidth - normalHeight));
                    translateX = yoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageHeight - normalWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageWidth - normalHeight));
                    angle = -90;
                    break;
                }
                case UPSIDE_DOWN: {
                    minWidth = Math.min(normalWidth, this.availableImageWidth);
                    minHeight = Math.min(normalHeight, this.availableImageHeight);
                    xoffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.printImage)) * (float)(this.availableImageWidth - normalWidth));
                    yoffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.printImage)) * (float)(this.availableImageHeight - normalHeight));
                    translateX = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageWidth - normalWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageHeight - normalHeight));
                    angle = 180;
                    break;
                }
            }
            BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
            Graphics2D g = bi.createGraphics();
            try {
                if (this.printImage.getModeValue() == ModeEnum.OPAQUE) {
                    g.setColor(this.printImage.getBackcolor());
                    g.fillRect(0, 0, minWidth, minHeight);
                }
                renderer.render(JRPdfExporter.this.jasperReportsContext, g, new Rectangle(translateX > 0 ? 0 : translateX, translateY > 0 ? 0 : translateY, normalWidth, normalHeight));
            }
            finally {
                g.dispose();
            }
            PdfImage image = JRPdfExporter.this.pdfProducer.createImage(bi, angle);
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), xoffset < 0 ? 0 : xoffset, yoffset < 0 ? 0 : yoffset);
        }

        private InternalImageProcessorResult processImageFillFrame(String rendererId, DataRenderable renderer) throws JRException {
            Pair<PdfImage, ExifOrientationEnum> imagePair = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                imagePair = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                byte[] data = renderer.getData(JRPdfExporter.this.jasperReportsContext);
                try {
                    imagePair = new Pair<PdfImage, ExifOrientationEnum>(JRPdfExporter.this.pdfProducer.createImage(data, true), ImageUtil.getExifOrientation(data));
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, imagePair);
                }
            }
            PdfImage image = imagePair.first();
            switch (ImageUtil.getRotation(this.printImage.getRotation(), imagePair.second())) {
                case LEFT: {
                    image.scaleAbsolute(this.availableImageHeight, this.availableImageWidth);
                    image.setRotationDegrees(90);
                    break;
                }
                case RIGHT: {
                    image.scaleAbsolute(this.availableImageHeight, this.availableImageWidth);
                    image.setRotationDegrees(-90);
                    break;
                }
                case UPSIDE_DOWN: {
                    image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
                    image.setRotationDegrees(180);
                    break;
                }
                default: {
                    image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
                    image.setRotationDegrees(0);
                }
            }
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), 0, 0);
        }

        private InternalImageProcessorResult processImageRetainShape(String rendererId, DataRenderable renderer) throws JRException {
            Pair<PdfImage, ExifOrientationEnum> imagePair = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                imagePair = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                byte[] data = renderer.getData(JRPdfExporter.this.jasperReportsContext);
                try {
                    imagePair = new Pair<PdfImage, ExifOrientationEnum>(JRPdfExporter.this.pdfProducer.createImage(data, true), ImageUtil.getExifOrientation(data));
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, imagePair);
                }
            }
            float plainWidth = 0.0f;
            float plainHeight = 0.0f;
            int xoffset = 0;
            int yoffset = 0;
            PdfImage image = imagePair.first();
            image.setRotationDegrees(0);
            switch (ImageUtil.getRotation(this.printImage.getRotation(), imagePair.second())) {
                case LEFT: {
                    image.scaleToFit(this.availableImageHeight, this.availableImageWidth);
                    plainWidth = image.getPlainHeight();
                    plainHeight = image.getPlainWidth();
                    image.setRotationDegrees(90);
                    break;
                }
                case RIGHT: {
                    image.scaleToFit(this.availableImageHeight, this.availableImageWidth);
                    plainWidth = image.getPlainHeight();
                    plainHeight = image.getPlainWidth();
                    image.setRotationDegrees(-90);
                    break;
                }
                case UPSIDE_DOWN: {
                    image.scaleToFit(this.availableImageWidth, this.availableImageHeight);
                    plainWidth = image.getPlainWidth();
                    plainHeight = image.getPlainHeight();
                    image.setRotationDegrees(180);
                    break;
                }
                default: {
                    image.scaleToFit(this.availableImageWidth, this.availableImageHeight);
                    plainWidth = image.getPlainWidth();
                    plainHeight = image.getPlainHeight();
                    image.setRotationDegrees(0);
                }
            }
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    xoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.printImage)) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                case RIGHT: {
                    xoffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.printImage)) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                case UPSIDE_DOWN: {
                    xoffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.printImage)) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.printImage)) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                default: {
                    xoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageHeight - plainHeight));
                }
            }
            xoffset = xoffset < 0 ? 0 : xoffset;
            yoffset = yoffset < 0 ? 0 : yoffset;
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), xoffset, yoffset);
        }

        private InternalImageProcessorResult processGraphics2D(Graphics2DRenderable renderer) throws JRException, IOException {
            int xoffset = 0;
            int yoffset = 0;
            int translateX = 0;
            int translateY = 0;
            double templateWidth = 0.0;
            double templateHeight = 0.0;
            double renderWidth = 0.0;
            double renderHeight = 0.0;
            double ratioX = 1.0;
            double ratioY = 1.0;
            double angle = 0.0;
            block0 : switch (this.printImage.getScaleImageValue()) {
                case CLIP: {
                    Dimension2D dimension;
                    Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
                    if (dimension != null) {
                        renderWidth = dimension.getWidth();
                        renderHeight = dimension.getHeight();
                    }
                    templateWidth = this.availableImageWidth;
                    templateHeight = this.availableImageHeight;
                    switch (this.printImage.getRotation()) {
                        case LEFT: {
                            if (dimension == null) {
                                renderWidth = this.availableImageHeight;
                                renderHeight = this.availableImageWidth;
                            }
                            translateX = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderHeight));
                            translateY = this.availableImageHeight - (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderWidth));
                            angle = -1.5707963267948966;
                            break block0;
                        }
                        case RIGHT: {
                            if (dimension == null) {
                                renderWidth = this.availableImageHeight;
                                renderHeight = this.availableImageWidth;
                            }
                            translateX = this.availableImageWidth - (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderHeight));
                            translateY = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderWidth));
                            angle = 1.5707963267948966;
                            break block0;
                        }
                        case UPSIDE_DOWN: {
                            if (dimension == null) {
                                renderWidth = this.availableImageWidth;
                                renderHeight = this.availableImageHeight;
                            }
                            translateX = this.availableImageWidth - (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderWidth));
                            translateY = this.availableImageHeight - (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderHeight));
                            angle = Math.PI;
                            break block0;
                        }
                    }
                    if (dimension == null) {
                        renderWidth = this.availableImageWidth;
                        renderHeight = this.availableImageHeight;
                    }
                    translateX = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderWidth));
                    translateY = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderHeight));
                    angle = 0.0;
                    break;
                }
                case FILL_FRAME: {
                    templateWidth = this.availableImageWidth;
                    templateHeight = this.availableImageHeight;
                    switch (this.printImage.getRotation()) {
                        case LEFT: {
                            renderWidth = this.availableImageHeight;
                            renderHeight = this.availableImageWidth;
                            translateX = 0;
                            translateY = this.availableImageHeight;
                            angle = -1.5707963267948966;
                            break block0;
                        }
                        case RIGHT: {
                            renderWidth = this.availableImageHeight;
                            renderHeight = this.availableImageWidth;
                            translateX = this.availableImageWidth;
                            translateY = 0;
                            angle = 1.5707963267948966;
                            break block0;
                        }
                        case UPSIDE_DOWN: {
                            renderWidth = this.availableImageWidth;
                            renderHeight = this.availableImageHeight;
                            translateX = this.availableImageWidth;
                            translateY = this.availableImageHeight;
                            angle = Math.PI;
                            break block0;
                        }
                    }
                    renderWidth = this.availableImageWidth;
                    renderHeight = this.availableImageHeight;
                    translateX = 0;
                    translateY = 0;
                    angle = 0.0;
                    break;
                }
                default: {
                    Dimension2D dimension;
                    Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
                    if (dimension != null) {
                        renderWidth = dimension.getWidth();
                        renderHeight = dimension.getHeight();
                    }
                    switch (this.printImage.getRotation()) {
                        case LEFT: {
                            if (dimension == null) {
                                renderWidth = this.availableImageHeight;
                                renderHeight = this.availableImageWidth;
                            }
                            ratioY = ratioX = (ratioX = (double)this.availableImageWidth / renderHeight) < (ratioY = (double)this.availableImageHeight / renderWidth) ? ratioX : ratioY;
                            templateWidth = renderHeight;
                            templateHeight = renderWidth;
                            translateX = 0;
                            translateY = (int)renderWidth;
                            xoffset = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderHeight * ratioX));
                            yoffset = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderWidth * ratioY));
                            angle = -1.5707963267948966;
                            break block0;
                        }
                        case RIGHT: {
                            if (dimension == null) {
                                renderWidth = this.availableImageHeight;
                                renderHeight = this.availableImageWidth;
                            }
                            ratioY = ratioX = (ratioX = (double)this.availableImageWidth / renderHeight) < (ratioY = (double)this.availableImageHeight / renderWidth) ? ratioX : ratioY;
                            templateWidth = renderHeight;
                            templateHeight = renderWidth;
                            translateX = (int)renderHeight;
                            translateY = 0;
                            xoffset = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.printImage)) * ((double)this.availableImageWidth - renderHeight * ratioX));
                            yoffset = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.printImage)) * ((double)this.availableImageHeight - renderWidth * ratioY));
                            angle = 1.5707963267948966;
                            break block0;
                        }
                        case UPSIDE_DOWN: {
                            if (dimension == null) {
                                renderWidth = this.availableImageWidth;
                                renderHeight = this.availableImageHeight;
                            }
                            ratioY = ratioX = (ratioX = (double)this.availableImageWidth / renderWidth) < (ratioY = (double)this.availableImageHeight / renderHeight) ? ratioX : ratioY;
                            templateWidth = renderWidth;
                            templateHeight = renderHeight;
                            translateX = (int)renderWidth;
                            translateY = (int)renderHeight;
                            xoffset = (int)((double)(1.0f - ImageUtil.getXAlignFactor(this.printImage)) * ((double)this.availableImageWidth - renderWidth * ratioX));
                            yoffset = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageHeight - renderHeight * ratioY));
                            angle = Math.PI;
                            break block0;
                        }
                    }
                    if (dimension == null) {
                        renderWidth = this.availableImageWidth;
                        renderHeight = this.availableImageHeight;
                    }
                    ratioY = ratioX = (ratioX = (double)this.availableImageWidth / renderWidth) < (ratioY = (double)this.availableImageHeight / renderHeight) ? ratioX : ratioY;
                    templateWidth = renderWidth;
                    templateHeight = renderHeight;
                    translateX = 0;
                    translateY = 0;
                    xoffset = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageWidth - renderWidth * ratioX));
                    yoffset = (int)((double)(1.0f - ImageUtil.getYAlignFactor(this.printImage)) * ((double)this.availableImageHeight - renderHeight * ratioY));
                    angle = 0.0;
                    break;
                }
            }
            JRPdfExporter.this.pdfProducer.drawImage(this.printImage, renderer, ((PdfReportConfiguration)JRPdfExporter.this.getCurrentItemConfiguration()).isForceSvgShapes(), templateWidth, templateHeight, translateX, translateY, angle, renderWidth, renderHeight, (float)ratioX, (float)ratioY, this.printImage.getX() + this.leftPadding + JRPdfExporter.this.getOffsetX() + xoffset, JRPdfExporter.this.pageFormat.getPageHeight() - this.printImage.getY() - this.topPadding - JRPdfExporter.this.getOffsetY() - this.availableImageHeight + yoffset);
            PdfImage image = JRPdfExporter.this.getPxImage();
            image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            InternalImageProcessorResult result = new InternalImageProcessorResult(chunk, this.availableImageWidth, this.availableImageHeight, 0, 0);
            return result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPdfExporterContext {
        protected ExporterContext() {
            super(JRPdfExporter.this);
        }

        @Override
        public PdfWriter getPdfWriter() {
            if (JRPdfExporter.this.pdfProducer instanceof ClassicPdfProducer) {
                return ((ClassicPdfProducer)JRPdfExporter.this.pdfProducer).getPdfWriter();
            }
            throw new JRRuntimeException("Not using the classic PDF producer");
        }

        @Override
        public PdfProducer getPdfProducer() {
            return JRPdfExporter.this.pdfProducer;
        }
    }
}

