/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentsEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ComponentsEnvironment.class);
    public static final String EXCEPTION_MESSAGE_KEY_BUNDLE_NOT_REGISTERED = "components.bundle.not.registered";
    private final ReferenceMap<Object, Map<String, ComponentsBundle>> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    private JasperReportsContext jasperReportsContext;

    private ComponentsEnvironment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static ComponentsEnvironment getInstance(JasperReportsContext jasperReportsContext) {
        return new ComponentsEnvironment(jasperReportsContext);
    }

    public Collection<ComponentsBundle> getBundles() {
        Map<String, ComponentsBundle> components = this.getCachedBundles();
        return components.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ComponentsBundle> getCachedBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap<Object, Map<String, ComponentsBundle>> referenceMap = this.cache;
        synchronized (referenceMap) {
            Map<String, ComponentsBundle> components = (Map<String, ComponentsBundle>)this.cache.get(cacheKey);
            if (components == null) {
                components = this.findBundles();
                this.cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected Map<String, ComponentsBundle> findBundles() {
        HashMap<String, ComponentsBundle> components = new HashMap<String, ComponentsBundle>();
        List<ComponentsBundle> bundles = this.jasperReportsContext.getExtensions(ComponentsBundle.class);
        for (ComponentsBundle bundle : bundles) {
            String namespace = bundle.getXmlParser().getNamespace();
            if (components.containsKey(namespace)) {
                log.warn("Found two components for namespace " + namespace);
                continue;
            }
            components.put(namespace, bundle);
        }
        return components;
    }

    public ComponentsBundle getBundle(String namespace) {
        Map<String, ComponentsBundle> components = this.getCachedBundles();
        ComponentsBundle componentsBundle = components.get(namespace);
        if (componentsBundle == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_BUNDLE_NOT_REGISTERED, namespace);
        }
        return componentsBundle;
    }

    public ComponentManager getManager(ComponentKey componentKey) {
        String namespace = componentKey.getNamespace();
        ComponentsBundle componentsBundle = this.getBundle(namespace);
        String name = componentKey.getName();
        return componentsBundle.getComponentManager(name);
    }
}

