/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JasperFillManager {
    private static final Logger log = LoggerFactory.getLogger(JasperFillManager.class);
    @Deprecated
    public static final String PROPERTY_LEGACY_RELATIVE_PATH_ENABLED = "net.sf.jasperreports.legacy.relative.path.enabled";
    private final JasperReportsContext jasperReportsContext;

    private JasperFillManager(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JasperFillManager getDefaultInstance() {
        return new JasperFillManager(DefaultJasperReportsContext.getInstance());
    }

    public static JasperFillManager getInstance(JasperReportsContext jasperReportsContext) {
        return new JasperFillManager(jasperReportsContext);
    }

    public String fillToFile(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile, jasperReport), params, connection);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
        return destFileName;
    }

    public String fillToFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile, jasperReport), params);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
        return destFileName;
    }

    public void fillToFile(String sourceFileName, String destFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params, connection);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public void fillToFile(String sourceFileName, String destFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public void fillToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters, connection);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public void fillToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public JasperPrint fill(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        File sourceFile = new File(sourceFileName);
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params, connection);
    }

    public JasperPrint fillFromRepo(String reportLocation, Map<String, Object> params, Connection connection) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(reportLocation), params, connection);
    }

    public JasperPrint fill(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params);
    }

    public JasperPrint fillFromRepo(String reportLocation, Map<String, Object> params) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(reportLocation), params);
    }

    public void fillToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        this.fillToStream(jasperReport, outputStream, parameters, connection);
    }

    public void fillToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        this.fillToStream(jasperReport, outputStream, parameters);
    }

    public void fillToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters, connection);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public void fillToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public JasperPrint fill(InputStream inputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return this.fill(jasperReport, parameters, connection);
    }

    public JasperPrint fill(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return this.fill(jasperReport, parameters);
    }

    public JasperPrint fill(JasperReport jasperReport, Map<String, Object> parameters, Connection connection) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, jasperReport, parameters, connection);
    }

    public JasperPrint fill(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, jasperReport, parameters);
    }

    public String fillToFile(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperReport.getName() + ".jrprint");
        String destFileName = destFile.toString();
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile, jasperReport), params, dataSource);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
        return destFileName;
    }

    public void fillToFile(String sourceFileName, String destFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params, dataSource);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public void fillToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters, dataSource);
        JRSaver.saveObject((Object)jasperPrint, destFileName);
    }

    public JasperPrint fill(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(sourceFile), params, dataSource);
    }

    public JasperPrint fillFromRepo(String reportLocation, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, this.getReportSource(reportLocation), params, dataSource);
    }

    public void fillToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        this.fillToStream(jasperReport, outputStream, parameters, dataSource);
    }

    public void fillToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperPrint jasperPrint = this.fill(jasperReport, parameters, dataSource);
        JRSaver.saveObject((Object)jasperPrint, outputStream);
    }

    public JasperPrint fill(InputStream inputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        return this.fill(jasperReport, parameters, dataSource);
    }

    public JasperPrint fill(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JRFiller.fill(this.jasperReportsContext, jasperReport, parameters, dataSource);
    }

    public static String fillReportToFile(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        return JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, params, connection);
    }

    public static String fillReportToFile(String sourceFileName, Map<String, Object> params) throws JRException {
        return JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, params);
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params, Connection connection) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, destFileName, params, connection);
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, destFileName, params);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(jasperReport, destFileName, parameters, connection);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(jasperReport, destFileName, parameters);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params, Connection connection) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(sourceFileName, params, connection);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(sourceFileName, params);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(inputStream, outputStream, parameters, connection);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(inputStream, outputStream, parameters);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(jasperReport, outputStream, parameters, connection);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(jasperReport, outputStream, parameters);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters, Connection connection) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(inputStream, parameters, connection);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(inputStream, parameters);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, Connection connection) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(jasperReport, parameters, connection);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(jasperReport, parameters);
    }

    public static String fillReportToFile(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        return JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, params, dataSource);
    }

    public static void fillReportToFile(String sourceFileName, String destFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(sourceFileName, destFileName, params, dataSource);
    }

    public static void fillReportToFile(JasperReport jasperReport, String destFileName, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperFillManager.getDefaultInstance().fillToFile(jasperReport, destFileName, parameters, dataSource);
    }

    public static JasperPrint fillReport(String sourceFileName, Map<String, Object> params, JRDataSource dataSource) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(sourceFileName, params, dataSource);
    }

    public static void fillReportToStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(inputStream, outputStream, parameters, dataSource);
    }

    public static void fillReportToStream(JasperReport jasperReport, OutputStream outputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        JasperFillManager.getDefaultInstance().fillToStream(jasperReport, outputStream, parameters, dataSource);
    }

    public static JasperPrint fillReport(InputStream inputStream, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(inputStream, parameters, dataSource);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JasperFillManager.getDefaultInstance().fill(jasperReport, parameters, dataSource);
    }

    @Deprecated
    protected JasperReportsContext getLocalJasperReportsContext(File file) {
        SimpleFileResolver fileResolver = new SimpleFileResolver(Arrays.asList(file.getParentFile(), new File(".")));
        fileResolver.setResolveAbsolutePath(true);
        LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext(this.jasperReportsContext);
        localJasperReportsContext.setFileResolver(fileResolver);
        return localJasperReportsContext;
    }

    protected static JasperReportSource getReportSource(JasperReportsContext jasperReportsContext, File reportFile) throws JRException {
        JasperFillManager manager = JasperFillManager.getInstance(jasperReportsContext);
        return manager.getReportSource(reportFile);
    }

    protected JasperReportSource getReportSource(File reportFile) throws JRException {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(reportFile);
        return this.getReportSource(reportFile, jasperReport);
    }

    protected JasperReportSource getReportSource(File reportFile, JasperReport jasperReport) {
        SimpleRepositoryResourceContext fallbackContext = SimpleRepositoryResourceContext.of(".");
        SimpleRepositoryResourceContext reportContext = SimpleRepositoryResourceContext.of(reportFile.getParent(), fallbackContext);
        boolean legacyRelativePath = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(jasperReport, PROPERTY_LEGACY_RELATIVE_PATH_ENABLED, false);
        if (legacyRelativePath) {
            reportContext.setSelfAsDerivedFallback(true);
        }
        return SimpleJasperReportSource.from(jasperReport, reportFile.getPath(), reportContext);
    }

    protected JasperReportSource getReportSource(String location) throws JRException {
        SimpleJasperReportSource source;
        RepositoryUtil repository = RepositoryUtil.getInstance(this.jasperReportsContext);
        ResourceInfo resourceInfo = repository.getResourceInfo(location);
        if (resourceInfo == null) {
            JasperReport report = repository.getReport(null, location);
            source = SimpleJasperReportSource.from(report, location, null);
        } else {
            String reportLocation = resourceInfo.getRepositoryResourceLocation();
            String contextLocation = resourceInfo.getRepositoryContextLocation();
            if (log.isDebugEnabled()) {
                log.debug("report location " + location + " resolved to " + reportLocation + ", context " + contextLocation);
            }
            JasperReport report = repository.getReport(null, reportLocation);
            source = SimpleJasperReportSource.from(report, reportLocation, SimpleRepositoryResourceContext.of(contextLocation));
        }
        return source;
    }
}

