/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.http;

import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.data.DataFileConnection;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDataConnection
implements DataFileConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpDataConnection.class);
    public static final String EXCEPTION_MESSAGE_KEY_NO_RESPONSE = "data.http.no.response";
    public static final String EXCEPTION_MESSAGE_KEY_STATUS_CODE_ERROR = "data.http.status.code.error";
    private final CloseableHttpClient httpClient;
    private final HttpRequestBase request;
    private CloseableHttpResponse response;

    public HttpDataConnection(CloseableHttpClient httpClient, HttpRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
    }

    @Override
    public InputStream getInputStream() {
        try {
            HttpEntity entity;
            this.response = this.httpClient.execute((HttpUriRequest)this.request);
            StatusLine status = this.response.getStatusLine();
            if (log.isDebugEnabled()) {
                log.debug("HTTP response status " + status);
            }
            if ((entity = this.response.getEntity()) == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_RESPONSE, (Object[])null);
            }
            if (status.getStatusCode() >= 300) {
                EntityUtils.consumeQuietly((HttpEntity)entity);
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_STATUS_CODE_ERROR, status);
            }
            return entity.getContent();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void dispose() {
        block6: {
            block5: {
                if (this.response != null) {
                    try {
                        this.response.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn("Error closing HTTP response", (Throwable)e);
                    }
                }
            }
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn("Error closing HTTP client", (Throwable)e);
            }
        }
    }
}

