/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ArrayStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ConstantColumnValue;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.ObjectArrayValues;
import net.sf.jasperreports.data.cache.RunLengthColumnValues;
import net.sf.jasperreports.data.cache.RunLengthStore;
import net.sf.jasperreports.data.cache.SingleObjectValue;
import net.sf.jasperreports.data.cache.ValueLength;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectArrayStore<T>
implements BufferColumnStore,
ArrayStore {
    private static final Logger log = LoggerFactory.getLogger(ObjectArrayStore.class);
    private final Class<T> valuesType;
    private final Object[] values;
    private int count;
    private RunLengthStore runLengthStore;

    public ObjectArrayStore(Class<T> valuesType, int size) {
        this.valuesType = valuesType;
        this.values = new Object[size];
        this.runLengthStore = new RunLengthStore(this);
        this.reset();
    }

    private void reset() {
        this.count = 0;
        this.runLengthStore.reset();
    }

    protected int size() {
        return this.values.length;
    }

    protected Object[] valuesBuffer() {
        return this.values;
    }

    @Override
    public Class<?> getBaseValuesType() {
        return this.valuesType;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public boolean valuesEqual(int idx1, int idx2) {
        return this.values[idx1].equals(this.values[idx2]);
    }

    @Override
    public void copyValue(int destIdx, int sourceIdx) {
        this.values[destIdx] = this.values[sourceIdx];
    }

    @Override
    public void updateCount(int count) {
        this.count = count;
    }

    @Override
    public void addValue(Object object) {
        this.values[this.count] = object;
        ++this.count;
        this.runLengthStore.valueAdded();
    }

    @Override
    public boolean full() {
        return this.count >= this.values.length;
    }

    @Override
    public void resetValues() {
        this.reset();
    }

    @Override
    public ColumnValues createValues() {
        if (this.count == 0) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": no values");
            }
            return EmptyColumnValues.instance();
        }
        if (this.count == 1) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": single value");
            }
            return new SingleObjectValue(this.values[0]);
        }
        if (this.runLengthStore.getRunCount() == 1) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": constant value of size " + this.count);
            }
            return new ConstantColumnValue(this.count, this.values[0]);
        }
        int originalCount = this.count;
        ColumnValues runLengthValues = this.runLengthStore.applyRunLengths(ValueLength.REFERENCE);
        if (log.isDebugEnabled()) {
            log.debug(this + ": creating values of size " + this.count);
        }
        Object[] objectValues = new Object[this.count];
        System.arraycopy(this.values, 0, objectValues, 0, this.count);
        ObjectArrayValues colValues = new ObjectArrayValues(objectValues);
        ColumnValues finalValues = runLengthValues == null ? colValues : new RunLengthColumnValues(originalCount, colValues, runLengthValues);
        return finalValues;
    }

    public String toString() {
        return "ObjectArrayStore@" + this.hashCode();
    }
}

