/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.util.Date;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.LongArrayStore;
import net.sf.jasperreports.data.cache.TransformedColumnValues;
import net.sf.jasperreports.data.cache.ValueTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateStore
implements BufferColumnStore {
    private static final Logger log = LoggerFactory.getLogger(DateStore.class);
    private final ValueTransformer valueTransformer;
    private final LongArrayStore timeStore;

    public DateStore(int size, ValueTransformer valueTransformer) {
        this.valueTransformer = valueTransformer;
        this.timeStore = new LongArrayStore(size, true);
        if (log.isDebugEnabled()) {
            log.debug(this + ": created time store " + this.timeStore);
        }
    }

    @Override
    public Class<?> getBaseValuesType() {
        return this.valueTransformer.getResultType();
    }

    @Override
    public void addValue(Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException();
        }
        Date value = (Date)object;
        long time = value.getTime();
        this.timeStore.add(time);
    }

    @Override
    public boolean full() {
        return this.timeStore.full();
    }

    @Override
    public void resetValues() {
        this.timeStore.resetValues();
    }

    @Override
    public ColumnValues createValues() {
        ColumnValues timeValues = this.timeStore.createValues();
        return new TransformedColumnValues(timeValues, this.valueTransformer);
    }

    public String toString() {
        return "DateStore@" + this.hashCode();
    }
}

