/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.BooleanValues;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ConstantColumnValue;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.LongArrayStore;
import net.sf.jasperreports.data.cache.SingleObjectValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanStore
implements BufferColumnStore {
    private static final Logger log = LoggerFactory.getLogger(BooleanStore.class);
    private final int size;
    private final LongArrayStore longArrayStore;
    private long currentLong;
    private int count;
    private boolean min;
    private boolean max;

    public BooleanStore(int size) {
        this.size = size;
        int longSize = 1 + (size - 1 >>> 6);
        this.longArrayStore = new LongArrayStore(longSize);
        this.reset();
        if (log.isDebugEnabled()) {
            log.debug(this + ": created long store " + this.longArrayStore);
        }
    }

    private void reset() {
        this.count = 0;
        this.min = true;
        this.max = false;
        this.currentLong = 0L;
    }

    @Override
    public Class<?> getBaseValuesType() {
        return Boolean.class;
    }

    @Override
    public void addValue(Object object) {
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        boolean value = (Boolean)object;
        if (value) {
            this.currentLong |= 1L << this.count;
        }
        if ((this.count & 0x3F) == 63) {
            this.longArrayStore.add(this.currentLong);
            this.currentLong = 0L;
        }
        ++this.count;
        this.min &= value;
        this.max |= value;
    }

    @Override
    public boolean full() {
        return this.count >= this.size;
    }

    @Override
    public void resetValues() {
        this.reset();
        this.longArrayStore.resetValues();
    }

    @Override
    public ColumnValues createValues() {
        if (this.count == 0) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": empty values");
            }
            return EmptyColumnValues.instance();
        }
        if (this.count == 1) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": single value");
            }
            return new SingleObjectValue(this.min);
        }
        if (this.min == this.max) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": constant value of size " + this.count);
            }
            return new ConstantColumnValue(this.count, this.min);
        }
        if ((this.count & 0x3F) != 0) {
            this.longArrayStore.add(this.currentLong);
        }
        if (log.isDebugEnabled()) {
            log.debug(this + ": creating long store of boolean size " + this.count);
        }
        ColumnValues longValues = this.longArrayStore.createValues();
        return new BooleanValues(this.count, longValues);
    }

    public String toString() {
        return "BooleanStore@" + this.hashCode();
    }
}

