/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.util.LinkedList;
import net.sf.jasperreports.data.cache.BlockColumnValues;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockColumnStore
implements ColumnStore {
    private static final Logger log = LoggerFactory.getLogger(BlockColumnStore.class);
    private final BufferColumnStore bufferStore;
    private LinkedList<ColumnValues> previousBlocks;

    public BlockColumnStore(BufferColumnStore bufferStore) {
        this.bufferStore = bufferStore;
    }

    @Override
    public Class<?> getBaseValuesType() {
        return this.bufferStore.getBaseValuesType();
    }

    protected void preAdd() {
        if (this.bufferStore.full()) {
            if (this.previousBlocks == null) {
                this.previousBlocks = new LinkedList();
            }
            ColumnValues currentValues = this.bufferStore.createValues();
            this.previousBlocks.add(currentValues);
            this.bufferStore.resetValues();
        }
    }

    @Override
    public void addValue(Object value) {
        this.preAdd();
        this.bufferStore.addValue(value);
    }

    @Override
    public ColumnValues createValues() {
        ColumnValues currentValues = this.bufferStore.createValues();
        if (this.previousBlocks == null) {
            return currentValues;
        }
        this.previousBlocks.add(currentValues);
        BlockColumnValues blockColumnValues = new BlockColumnValues(this.previousBlocks);
        if (log.isDebugEnabled()) {
            log.debug(this + ": created block values of size " + blockColumnValues.size() + " by " + this.bufferStore);
        }
        return blockColumnValues;
    }

    public String toString() {
        return "BlockColumnStore@" + this.hashCode();
    }
}

