/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static Object read(InputStream is, String mappingFile) {
        Object object = null;
        InputStream mis = null;
        try {
            mis = JRLoader.getLocationInputStream(mappingFile);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource(mis));
            object = XmlUtil.read(is, mapping);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static Object read(Node node, String mappingFile) {
        Object object = null;
        InputStream mis = null;
        try {
            mis = JRLoader.getLocationInputStream(mappingFile);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource(mis));
            object = XmlUtil.read(node, mapping);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static Object read(InputStream is, Mapping mapping) {
        Object object = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setWhitespacePreserve(true);
            object = unmarshaller.unmarshal(new InputSource(is));
        }
        catch (MappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException(e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException(e);
        }
        return object;
    }

    public static Object read(InputStream is, XMLContext context) {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setWhitespacePreserve(true);
            Object object = unmarshaller.unmarshal(new InputSource(is));
            return object;
        }
        catch (MarshalException e) {
            throw new JRRuntimeException(e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static Object read(Node node, Mapping mapping) {
        Object object = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            unmarshaller.setWhitespacePreserve(true);
            object = unmarshaller.unmarshal(node);
        }
        catch (MappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException(e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException(e);
        }
        return object;
    }

    public static Object read(InputStream is, Class<?> clazz) {
        return XmlUtil.read(is, XmlUtil.getMappingFile(clazz));
    }

    public static Object read(Node node, Class<?> clazz) {
        return XmlUtil.read(node, XmlUtil.getMappingFile(clazz));
    }

    public static void write(Object object, String mappingFile, Writer writer) {
        InputStream mis = null;
        try {
            mis = JRLoader.getLocationInputStream(mappingFile);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource(mis));
            XmlUtil.write(object, mapping, writer);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void write(Object object, Mapping mapping, Writer writer) {
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setMapping(mapping);
            marshaller.setMarshalAsDocument(false);
            marshaller.marshal(object);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        catch (MappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (MarshalException e) {
            throw new JRRuntimeException(e);
        }
        catch (ValidationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static void write(Object object, String mappingFile, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XmlUtil.write(object, mappingFile, (Writer)writer);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void write(Object object, Mapping mapping, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            XmlUtil.write(object, mapping, (Writer)writer);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String write(Object object, String mappingFile) {
        StringWriter writer = new StringWriter();
        try {
            XmlUtil.write(object, mappingFile, (Writer)writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String write(Object object, Mapping mapping) {
        StringWriter writer = new StringWriter();
        try {
            XmlUtil.write(object, mapping, (Writer)writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }

    public static String write(Object object) {
        StringWriter writer = new StringWriter();
        try {
            XmlUtil.write(object, XmlUtil.getMappingFile(object.getClass()), (Writer)writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return writer.toString();
    }

    private static String getMappingFile(Class<?> clazz) {
        return clazz.getName().replace(".", "/") + ".xml";
    }

    private XmlUtil() {
    }
}

