/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import java.util.UUID;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.interactive.SortByColumnCommand;
import net.sf.jasperreports.crosstabs.interactive.SortByColumnData;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortByColumnAction
extends AbstractAction {
    private static final long serialVersionUID = 10200L;
    private static final Logger log = LoggerFactory.getLogger(SortByColumnAction.class);
    private SortByColumnData sortData;

    @Override
    public void performAction() throws ActionException {
        CommandTarget target = this.getCommandTarget(UUID.fromString(this.sortData.getCrosstabId()), JRDesignCrosstab.class);
        if (target != null) {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)target.getIdentifiable();
            String targetUri = target.getUri();
            try {
                SortByColumnCommand sortCommand = new SortByColumnCommand(this.getJasperReportsContext(), crosstab, this.getSortData());
                ResetInCacheCommand command = new ResetInCacheCommand(sortCommand, this.getJasperReportsContext(), this.getReportContext(), targetUri);
                this.getCommandStack().execute(command);
            }
            catch (CommandException e) {
                if (log.isDebugEnabled()) {
                    log.debug("error sorting crosstab", (Throwable)e);
                }
                throw new ActionException(e);
            }
        }
    }

    public SortByColumnData getSortData() {
        return this.sortData;
    }

    public void setSortData(SortByColumnData sortData) {
        this.sortData = sortData;
    }
}

