/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.crosstabs.fill.BucketOrderer;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingData;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.ColumnValueInfo;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.OrderByColumnInfo;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderByColumnOrderer
implements BucketOrderer {
    private static final Logger log = LoggerFactory.getLogger(OrderByColumnOrderer.class);
    private final OrderByColumnInfo orderInfo;
    private BucketingData bucketingData;
    private List<BucketDefinition.Bucket> bucketValues;

    public OrderByColumnOrderer(OrderByColumnInfo orderInfo) {
        this.orderInfo = orderInfo;
    }

    @Override
    public void init(BucketingData bucketingData) {
        this.bucketingData = bucketingData;
        this.initBucketValues();
    }

    private void initBucketValues() {
        List<ColumnValueInfo> columnValues = this.orderInfo.getColumnValues();
        this.bucketValues = new ArrayList<BucketDefinition.Bucket>(columnValues.size());
        ListIterator<ColumnValueInfo> it = columnValues.listIterator();
        while (it.hasNext()) {
            BucketDefinition.Bucket bucketValue;
            ColumnValueInfo columnValue = it.next();
            if (columnValue.isTotal()) {
                bucketValue = this.bucketingData.getColumnTotalBucket(it.previousIndex());
            } else {
                Object value = columnValue.getValue() == null ? null : JRValueStringUtils.deserialize(columnValue.getValueType(), columnValue.getValue());
                bucketValue = this.bucketingData.getColumnBucket(it.previousIndex(), value);
            }
            this.bucketValues.add(bucketValue);
        }
    }

    @Override
    public Object getOrderValue(BucketingService.BucketMap bucketMap, BucketDefinition.Bucket bucketValue) throws JRException {
        MeasureDefinition.MeasureValue[] measureValues = this.bucketingData.getMeasureValues(bucketMap, bucketValue, this.bucketValues);
        return measureValues[this.orderInfo.getMeasureIndex()].getValue();
    }

    @Override
    public int compareOrderValues(Object orderValue, Object orderValue2) {
        int order = orderValue == null ? (orderValue2 == null ? 0 : -1) : (orderValue2 == null ? 1 : ((Comparable)orderValue).compareTo(orderValue2));
        return this.orderInfo.getOrder() == SortOrderEnum.DESCENDING ? -order : order;
    }

    public List<BucketDefinition.Bucket> getBucketValues() {
        return this.bucketValues;
    }
}

