/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.BarcodeDesignEvaluator;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.renderers.Renderable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeDesignConverter
implements ComponentDesignConverter {
    private static final Logger log = LoggerFactory.getLogger(BarcodeDesignConverter.class);

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        reportConverter.copyBaseAttributes(element, printImage);
        printImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        Renderable barcodeImage = this.evaluateBarcode(reportConverter, element);
        printImage.setRenderer(barcodeImage);
        return printImage;
    }

    protected Renderable evaluateBarcode(ReportConverter reportConverter, JRComponentElement element) {
        try {
            BarcodeDesignEvaluator evaluator = new BarcodeDesignEvaluator(reportConverter.getJasperReportsContext(), element, reportConverter.getDefaultStyleProvider());
            return evaluator.evaluateImage();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Failed to create barcode preview", (Throwable)e);
            }
            return null;
        }
    }
}

