/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCallableThisDecorator;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.functions.FunctionSupport;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptFunctionsObject
implements Scriptable {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptFunctionsObject.class);
    private final Context context;
    private final FunctionsUtil functionsUtil;
    private final JREvaluator evaluator;
    private final Map<String, Object> functions;
    private Scriptable prototype;
    private Scriptable parentScope;

    public JavaScriptFunctionsObject(Context context, FunctionsUtil functionsUtil, JREvaluator evaluator) {
        this.context = context;
        this.functionsUtil = functionsUtil;
        this.evaluator = evaluator;
        this.functions = new HashMap<String, Object>();
    }

    public String getClassName() {
        return "JRFunctions";
    }

    public Object get(String name, Scriptable start) {
        Object function = this.resolveFunction(name, start);
        return function;
    }

    protected Object resolveFunction(String name, Scriptable start) {
        Object function = this.functions.get(name);
        if (function != null) {
            return function;
        }
        function = NOT_FOUND;
        Method method = this.functionsUtil.getMethod4Function(name);
        if (method != null) {
            Class<?> functionClass = method.getDeclaringClass();
            if (FunctionSupport.class.isAssignableFrom(functionClass)) {
                Object functionSupport = this.evaluator.getFunctionSupport(functionClass);
                Scriptable functionScriptable = this.context.getWrapFactory().wrapAsJavaObject(this.context, start, functionSupport, functionClass);
                Object functionCall = functionScriptable.get(name, start);
                if (functionCall instanceof Callable) {
                    Callable functionCallable = (Callable)functionCall;
                    function = new JavaScriptCallableThisDecorator(functionCallable, functionScriptable);
                }
            } else {
                Scriptable functionScriptable = this.context.getWrapFactory().wrapJavaClass(this.context, start, functionClass);
                Object functionCall = functionScriptable.get(name, start);
                if (functionCall instanceof Callable) {
                    function = functionCall;
                }
            }
            if (function == NOT_FOUND && log.isDebugEnabled()) {
                log.debug("did not find JavaScript function " + name + " in class " + functionClass.getName());
            }
        }
        this.functions.put(name, function);
        return function;
    }

    public Object get(int index, Scriptable start) {
        return NOT_FOUND;
    }

    public boolean has(String name, Scriptable start) {
        Object function = this.resolveFunction(name, start);
        return function != NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String name, Scriptable start, Object value) {
        throw new UnsupportedOperationException();
    }

    public void put(int index, Scriptable start, Object value) {
        throw new UnsupportedOperationException();
    }

    public void delete(String name) {
        throw new UnsupportedOperationException();
    }

    public void delete(int index) {
        throw new UnsupportedOperationException();
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        return new Object[0];
    }

    public Object getDefaultValue(Class<?> hint) {
        return "[object JRFunctions]";
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }
}

