/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.launch.ChromeLauncher;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.chrome.BrowserService;
import net.sf.jasperreports.chrome.ChromeServiceHandle;
import net.sf.jasperreports.chrome.LaunchConfiguration;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chrome {
    private static final Logger log = LoggerFactory.getLogger(Chrome.class);
    protected static final String PROPERTY_PREFIX = "net.sf.jasperreports.chrome.";
    public static final String PROPERTY_ENABLED = "net.sf.jasperreports.chrome.enabled";
    public static final String PROPERTY_EXECUTABLE_PATH = "net.sf.jasperreports.chrome.executable.path";
    public static final String PROPERTY_HEADLESS = "net.sf.jasperreports.chrome.headless";
    public static final String PROPERTY_ARGUMENT_PREFIX = "net.sf.jasperreports.chrome.argument.";
    public static final String PROPERTY_IDLE_TIMEOUT = "net.sf.jasperreports.chrome.idle.timeout";
    public static final String PROPERTY_LIVE_TIMEOUT = "net.sf.jasperreports.chrome.live.timeout";
    private static Path DETECTED_CHROME_PATH;
    private final boolean enabled;
    private final BrowserService service;

    public static Chrome instance(JasperReportsContext jasperReportsContext) {
        JRPropertiesUtil properties = JRPropertiesUtil.getInstance(jasperReportsContext);
        boolean enabled = properties.getBooleanProperty(PROPERTY_ENABLED, false);
        if (enabled) {
            enabled = CDTClassCheck.FOUND_CDT_CLASS;
        }
        BrowserService service = null;
        if (enabled) {
            String executable = properties.getProperty(PROPERTY_EXECUTABLE_PATH);
            Path executablePath = executable == null || executable.trim().isEmpty() ? Chrome.detectedChromeExecutable() : Paths.get(executable.trim(), new String[0]);
            if (executablePath == null) {
                enabled = false;
            } else {
                boolean headless = properties.getBooleanProperty(PROPERTY_HEADLESS, true);
                List<JRPropertiesUtil.PropertySuffix> argProperties = properties.getAllProperties((JRPropertiesMap)null, PROPERTY_ARGUMENT_PREFIX);
                LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
                for (JRPropertiesUtil.PropertySuffix propertySuffix : argProperties) {
                    String value = propertySuffix.getValue();
                    if (value == null || value.isEmpty()) continue;
                    args.put(propertySuffix.getSuffix(), value);
                }
                long idleTimeout = properties.getLongProperty(PROPERTY_IDLE_TIMEOUT, 0L);
                long liveTimeout = properties.getLongProperty(PROPERTY_LIVE_TIMEOUT, 0L);
                LaunchConfiguration configuration = new LaunchConfiguration(executablePath, headless, args, idleTimeout, liveTimeout);
                ChromeServiceHandle chromeServiceHandle = new ChromeServiceHandle(configuration);
                service = new BrowserService(jasperReportsContext, chromeServiceHandle);
            }
        }
        return new Chrome(enabled, service);
    }

    private static Path detectedChromeExecutable() {
        Path path = DETECTED_CHROME_PATH;
        if (path == null) {
            DETECTED_CHROME_PATH = path = ChromeEnvironment.findChromeExecutable();
        }
        return path;
    }

    protected Chrome(boolean enabled, BrowserService service) {
        this.enabled = enabled;
        this.service = service;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BrowserService getService() {
        return this.service;
    }

    private static class ChromeEnvironment {
        private ChromeEnvironment() {
        }

        public static final Path findChromeExecutable() {
            try {
                ChromeLauncher launcher = new ChromeLauncher();
                Path chromeBinaryPath = launcher.getChromeBinaryPath();
                if (log.isDebugEnabled()) {
                    log.debug("chrome binary found at " + chromeBinaryPath);
                }
                return chromeBinaryPath;
            }
            catch (RuntimeException e) {
                log.warn("Chrome binary not autodetected: " + e.getMessage());
                return null;
            }
        }
    }

    private static class CDTClassCheck {
        private static final boolean FOUND_CDT_CLASS = CDTClassCheck.foundCDTClass();

        private CDTClassCheck() {
        }

        private static boolean foundCDTClass() {
            try {
                Class.forName("com.github.kklisura.cdt.launch.ChromeLauncher");
                return true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.warn("Failed to load CDT class: " + e);
                if (log.isDebugEnabled()) {
                    log.debug("error loading CDT class", e);
                }
                return false;
            }
        }

        static {
            if (log.isDebugEnabled()) {
                log.debug("found CDT class " + FOUND_CDT_CLASS);
            }
        }
    }
}

