/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.util;

import com.jasperassistant.designer.viewer.util.Messages;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BrowserUtils {
    private static String browser;

    private BrowserUtils() {
    }

    private static Process launchBrowser(String url) throws IOException {
        Process process = null;
        if (browser == null) {
            try {
                browser = "netscape";
                process = Runtime.getRuntime().exec(browser + " " + url);
            }
            catch (IOException e) {
                browser = "mozilla";
            }
        }
        if (process == null) {
            process = Runtime.getRuntime().exec(browser + " " + url);
        }
        return process;
    }

    private static void reportError(Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("BrowserUtils.error.title"), (String)Messages.getString("BrowserUtils.error.message"));
            }
        });
    }

    public static void openLink(String url) {
        String platform;
        if (url.startsWith("file:")) {
            url = url.substring(5);
            while (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = "file:///" + url;
        }
        if ("win32".equals(platform = SWT.getPlatform())) {
            Program.launch((String)url);
        } else if ("carbon".equals(platform)) {
            try {
                Runtime.getRuntime().exec("/usr/bin/open " + url);
            }
            catch (IOException e) {
                BrowserUtils.reportError(Display.getCurrent());
            }
        } else {
            new Thread((Runnable)new Launcher(Display.getCurrent(), url), "BrowserUtils").start();
        }
    }

    private static class Launcher
    implements Runnable {
        private String url;
        private Display display;

        Launcher(Display display, String url) {
            this.url = url;
            this.display = display;
        }

        @Override
        public void run() {
            try {
                Process p = BrowserUtils.launchBrowser(this.url);
                try {
                    if (p != null) {
                        p.waitFor();
                    }
                }
                catch (InterruptedException e) {
                    BrowserUtils.reportError(this.display);
                }
            }
            catch (IOException e) {
                BrowserUtils.reportError(this.display);
            }
        }
    }
}

