/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class StatusContributionItem
extends ContributionItem
implements IReportViewerListener {
    private IReportViewer viewer;
    private Label label;
    private ToolItem toolitem;

    public StatusContributionItem(IReportViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        this.viewer.addReportViewerListener(this);
        this.refresh();
    }

    void refresh() {
        block5: {
            if (this.label == null || this.label.isDisposed()) {
                return;
            }
            try {
                if (!this.viewer.hasDocument()) {
                    this.label.setEnabled(false);
                    this.label.setText("");
                } else {
                    this.label.setText(this.getText());
                    this.label.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block5;
                throw exception;
            }
        }
    }

    private Control createControl(Composite parent) {
        this.label = new Label(parent, 0x1000000);
        this.label.setText("88888 of 88888");
        this.label.pack();
        this.refresh();
        return this.label;
    }

    public void dispose() {
        this.viewer.removeReportViewerListener(this);
        this.label = null;
        this.viewer = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)Messages.getString("StatusContributionItem.cannotAddToMenu"));
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setWidth(this.label.getSize().x);
        this.toolitem.setControl(control);
    }

    @Override
    public void viewerStateChanged(ReportViewerEvent evt) {
        this.refresh();
    }

    private String getText() {
        if (this.viewer == null || !this.viewer.hasDocument()) {
            return "";
        }
        return MessageFormat.format(Messages.getString("StatusContributionItem.pageMofN"), new Integer(this.viewer.getPageIndex() + 1), new Integer(this.viewer.getDocument().getPages().size()));
    }
}

