/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractReportViewerAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintAction
extends AbstractReportViewerAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(PrintAction.class, (String)"images/print.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(PrintAction.class, (String)"images/printd.gif");
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final String PDF_EXTENSION = ".pdf";

    public PrintAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("PrintAction.label"));
        this.setToolTipText(Messages.getString("PrintAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getReportViewer().hasDocument();
    }

    @Override
    public void run() {
        final Display display = Display.getCurrent();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if ("carbon".equals(SWT.getPlatform())) {
                        Random random = new Random();
                        int integer = random.nextInt();
                        String reportName = PrintAction.this.getReportViewer().getDocument().getName();
                        String fileName = reportName + integer + PrintAction.PDF_EXTENSION;
                        File file = new File(TEMP_DIR, fileName);
                        file.deleteOnExit();
                        PrintAction.this.exportAsPDF(file);
                        PrintAction.this.openPDF(file);
                    } else {
                        JasperPrintManager.printReport(PrintAction.this.getReportViewer().getDocument(), true);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.getString("PrintAction.printingError.title"), (String)MessageFormat.format(Messages.getString("PrintAction.printingError.message"), e.getMessage()));
                }
            }
        });
    }

    private void exportAsPDF(File file) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.getReportViewer().getDocument());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.exportReport();
    }

    private void openPDF(File file) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        runtime.exec("open " + file);
    }
}

