/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractReportViewerAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NativePrintAction
extends AbstractReportViewerAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(NativePrintAction.class, (String)"images/print.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(NativePrintAction.class, (String)"images/printd.gif");

    public NativePrintAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("PrintAction.label"));
        this.setToolTipText(Messages.getString("PrintAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getReportViewer().hasDocument();
    }

    @Override
    public void run() {
        Display display = Display.getCurrent();
        PrintDialog dialog = new PrintDialog(display.getActiveShell());
        dialog.setStartPage(1);
        dialog.setEndPage(this.getReportViewer().getDocument().getPages().size());
        PrinterData printData = dialog.open();
        if (printData != null) {
            try {
                this.printDocument(display, printData);
            }
            catch (PrinterException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.getString("PrintAction.printingError.title"), (String)MessageFormat.format(Messages.getString("PrintAction.printingError.message"), e.getMessage()));
            }
        }
    }

    private void printDocument(Display display, PrinterData printData) throws PrinterException {
        int endPage;
        int startPage;
        JasperPrint document = this.getReportViewer().getDocument();
        if (printData.scope == 0) {
            startPage = 0;
            endPage = document.getPages().size() - 1;
        } else if (printData.scope == 1) {
            startPage = printData.startPage - 1;
            endPage = printData.endPage - 1;
        } else {
            startPage = endPage = this.getReportViewer().getPageIndex();
        }
        int pageCount = endPage - startPage + 1;
        PrintService service = this.lookupPrintService(printData);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printJob.setJobName("JasperReports - " + document.getName());
        switch (document.getOrientationValue()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(document.getPageHeight(), document.getPageWidth());
                paper.setImageableArea(0.0, 0.0, document.getPageHeight(), document.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(document.getPageWidth(), document.getPageHeight());
                paper.setImageableArea(0.0, 0.0, document.getPageWidth(), document.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append(new PrintableDocument(document, startPage), pageFormat, pageCount);
        printJob.setPageable(book);
        printJob.setCopies(printData.copyCount);
        printJob.setPrintService(service);
        printJob.print();
    }

    private PrintService lookupPrintService(PrinterData data) throws PrinterException {
        String printerName = data.name;
        HashAttributeSet attrSet = new HashAttributeSet();
        attrSet.add(new PrinterName(printerName, null));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (services == null || services.length == 0) {
            throw new PrinterException("Failed to lookup service by printer name: " + printerName);
        }
        return services[0];
    }

    private static class PrintableDocument
    implements Printable {
        private final JasperPrint document;
        private final int startPage;

        public PrintableDocument(JasperPrint document, int startPage) {
            this.document = document;
            this.startPage = startPage;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (Thread.currentThread().isInterrupted()) {
                throw new PrinterException("Current thread interrupted.");
            }
            if ((pageIndex += this.startPage) < 0 || pageIndex >= this.document.getPages().size()) {
                return 1;
            }
            try {
                JRGraphics2DExporter exporter = new JRGraphics2DExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.document);
                exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(pageIndex));
                exporter.exportReport();
            }
            catch (JRException e) {
                throw new PrinterException(e.getMessage());
            }
            return 0;
        }
    }
}

