/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsXmlWithImagesAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsXmlWithImagesAction.class, (String)"images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsXmlWithImagesAction.class, (String)"images/saved.gif");

    public ExportAsXmlWithImagesAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsXmlWithImagesAction.label"));
        this.setToolTipText(Messages.getString("ExportAsXmlWithImagesAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.xml", "*.jrpxml"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsXmlWithImagesAction.xmlFilterName"), Messages.getString("ExportAsXmlWithImagesAction.jrpxmlFilterName")});
        this.setDefaultFileExtension("xml");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        JRXmlExporter exporter = new JRXmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.getReportViewer().getDocument());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, monitor);
        exporter.setParameter(JRXmlExporterParameter.IS_EMBEDDING_IMAGES, Boolean.TRUE);
        exporter.exportReport();
    }
}

