/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import com.jasperassistant.designer.viewer.util.Compatibility;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsSingleXlsAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsSingleXlsAction.class, (String)"images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsSingleXlsAction.class, (String)"images/saved.gif");

    public ExportAsSingleXlsAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsSingleXlsAction.label"));
        this.setToolTipText(Messages.getString("ExportAsSingleXlsAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.xls"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsSingleXlsAction.filterName")});
        this.setDefaultFileExtension("xls");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.getReportViewer().getDocument());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, monitor);
        Compatibility.setOnePagePerSheetParameter(exporter, Boolean.FALSE);
        exporter.exportReport();
    }
}

