/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsPdfAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, (String)"images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsPdfAction.class, (String)"images/saved.gif");

    public ExportAsPdfAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsPdfAction.label"));
        this.setToolTipText(Messages.getString("ExportAsPdfAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.pdf"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsPdfAction.filterName")});
        this.setDefaultFileExtension("pdf");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.getReportViewer().getDocument());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, monitor);
        exporter.exportReport();
    }
}

