/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExportAsHtmlAction
extends AbstractExportAction {
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(ExportAsHtmlAction.class, (String)"images/save.gif");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(ExportAsHtmlAction.class, (String)"images/saved.gif");

    public ExportAsHtmlAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("ExportAsHtmlAction.label"));
        this.setToolTipText(Messages.getString("ExportAsHtmlAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.html", "*.htm"});
        this.setFilterNames(new String[]{Messages.getString("ExportAsHtmlAction.htmlFilterName"), Messages.getString("ExportAsHtmlAction.htmFilterName")});
        this.setDefaultFileExtension("html");
    }

    @Override
    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.getReportViewer().getDocument());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, monitor);
        exporter.exportReport();
    }
}

