/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer.actions;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractReportViewerAction;
import com.jasperassistant.designer.viewer.actions.Messages;
import com.jasperassistant.designer.viewer.actions.ProgressMonitorAdapter;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public abstract class AbstractExportAction
extends AbstractReportViewerAction {
    private String[] filterNames;
    private String[] fileExtensions;
    private String defaultFileExtension;
    private String fileName;
    private String filterPath;

    public AbstractExportAction(IReportViewer viewer) {
        super(viewer);
    }

    public AbstractExportAction(IReportViewer viewer, int style) {
        super(viewer, style);
    }

    @Override
    public void run() {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8196);
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if (this.fileExtensions != null) {
            dialog.setFilterExtensions(this.fileExtensions);
        }
        if (this.filterPath != null) {
            dialog.setFilterPath(this.filterPath);
        }
        if (this.fileName != null) {
            dialog.setFileName(this.fileName);
        } else {
            dialog.setFileName(this.getReportViewer().getDocument().getName());
        }
        String filePath = dialog.open();
        if (filePath != null) {
            if (this.defaultFileExtension != null && this.fileExtensions != null) {
                String extension = AbstractExportAction.getFileExtension(filePath);
                boolean fix = true;
                if (extension != null) {
                    int i = 0;
                    for (i = 0; i < this.fileExtensions.length; ++i) {
                        if (!this.fileExtensions[i].endsWith(extension)) continue;
                        fix = false;
                        break;
                    }
                }
                if (fix) {
                    filePath = filePath + '.' + this.defaultFileExtension;
                }
            }
            File file = new File(filePath);
            try {
                this.export(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export(final File file) throws Throwable {
        ProgressMonitorDialog pm = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            pm.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        int totalPages = AbstractExportAction.this.getReportViewer().getDocument().getPages().size();
                        monitor.beginTask(Messages.getString("AbstractExportAction.taskLabel"), totalPages);
                        AbstractExportAction.this.exportWithProgress(file, new ProgressMonitorAdapter(monitor, totalPages));
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (pm.getReturnCode() != 1) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            if (pm.getReturnCode() != 1) {
                throw e;
            }
        }
        finally {
            if (pm.getReturnCode() == 1) {
                file.delete();
            }
        }
    }

    public void setDefaultFileExtension(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    private static String getFileExtension(String fileName) {
        int dotIndex;
        if (fileName != null && (dotIndex = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(dotIndex + 1);
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getReportViewer().hasDocument();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws Throwable {
    }
}

