/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.IReportViewerListener;
import com.jasperassistant.designer.viewer.ReportViewerEvent;
import com.jasperassistant.designer.viewer.util.Compatibility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ViewerCanvas
extends Canvas {
    public static final int MARGIN = 5;
    private static final Cursor CURSOR_SIZEALL = new Cursor(null, 5);
    private static final Cursor CURSOR_HAND = new Cursor(null, 21);
    private static final PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
    private JRPrintPage page;
    private List hyperlinkElements = new ArrayList();
    private Image reportImage;
    private String errorMessage;
    private boolean dragging;
    private JRPrintHyperlink currentLink;
    private int dragSelectionX;
    private int dragSelectionH;
    private int dragSelectionY;
    private int dragSelectionV;
    private IReportViewer viewer;
    private Listener eventListener = new Listener(){

        public void handleEvent(Event event) {
            ViewerCanvas.this.handleEvent(event);
        }
    };
    private IReportViewerListener listener = new IReportViewerListener(){

        @Override
        public void viewerStateChanged(ReportViewerEvent evt) {
            ViewerCanvas.this.refresh();
        }
    };
    boolean updatingScrollbars;

    ViewerCanvas(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        this.addListener(9, this.eventListener);
        this.addListener(5, this.eventListener);
        this.addListener(3, this.eventListener);
        this.addListener(4, this.eventListener);
        this.addListener(1, this.eventListener);
        this.addListener(31, this.eventListener);
        this.addListener(11, this.eventListener);
        this.addListener(12, this.eventListener);
        ScrollBar sb = this.getHorizontalBar();
        sb.setIncrement(20);
        sb.addListener(13, this.eventListener);
        sb = this.getVerticalBar();
        sb.setIncrement(20);
        sb.addListener(13, this.eventListener);
    }

    protected void handleEvent(Event event) {
        if (this.isDisposed()) {
            return;
        }
        switch (event.type) {
            case 9: {
                this.paint(event.gc);
                break;
            }
            case 5: {
                this.onMouseMove(event);
                break;
            }
            case 3: {
                this.onMouseDown(event);
                break;
            }
            case 4: {
                this.onMouseUp(event);
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 31: {
                event.doit = true;
                break;
            }
            case 11: {
                this.resize();
                break;
            }
            case 13: {
                this.repaint();
                break;
            }
            case 12: {
                this.onDispose();
            }
        }
    }

    private void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000001: {
                ScrollBar sb = this.getVerticalBar();
                int selection = sb.getSelection();
                this.setVerticalSelection(selection - sb.getIncrement());
                if (sb.getSelection() == selection) {
                    if (!this.viewer.canGotoPreviousPage()) break;
                    this.viewer.gotoPreviousPage();
                    this.setVerticalSelection(sb.getMaximum());
                    this.repaint();
                    break;
                }
                this.repaint();
                break;
            }
            case 0x1000002: {
                ScrollBar sb = this.getVerticalBar();
                int selection = sb.getSelection();
                this.setVerticalSelection(selection + sb.getIncrement());
                if (sb.getSelection() == selection) {
                    if (!this.viewer.canGotoNextPage()) break;
                    this.viewer.gotoNextPage();
                    this.setVerticalSelection(sb.getMinimum());
                    this.repaint();
                    break;
                }
                this.repaint();
                break;
            }
            case 0x1000003: {
                this.setHorizontalSelection(this.getHorizontalBar().getSelection() - this.getHorizontalBar().getIncrement());
                this.repaint();
                break;
            }
            case 0x1000004: {
                this.setHorizontalSelection(this.getHorizontalBar().getSelection() + this.getHorizontalBar().getIncrement());
                this.repaint();
                break;
            }
            case 0x1000005: {
                ScrollBar sb = this.getVerticalBar();
                int selection = sb.getSelection();
                this.setVerticalSelection(selection - sb.getPageIncrement());
                if (sb.getSelection() == selection) {
                    if (!this.viewer.canGotoPreviousPage()) break;
                    this.viewer.gotoPreviousPage();
                    this.setVerticalSelection(sb.getMaximum());
                    this.repaint();
                    break;
                }
                this.repaint();
                break;
            }
            case 0x1000006: {
                ScrollBar sb = this.getVerticalBar();
                int selection = sb.getSelection();
                this.setVerticalSelection(selection + sb.getPageIncrement());
                if (sb.getSelection() == selection) {
                    if (!this.viewer.canGotoNextPage()) break;
                    this.viewer.gotoNextPage();
                    this.setVerticalSelection(sb.getMinimum());
                    this.repaint();
                    break;
                }
                this.repaint();
                break;
            }
            case 0x1000007: {
                if (this.viewer.canGotoFirstPage()) {
                    this.viewer.gotoFirstPage();
                }
                this.setVerticalSelection(this.getVerticalBar().getMinimum());
                this.repaint();
                break;
            }
            case 0x1000008: {
                if (!this.viewer.canGotoLastPage()) break;
                this.viewer.gotoLastPage();
            }
        }
    }

    protected void resize() {
        if (this.currentLink != null) {
            this.currentLink = null;
            this.setCursor(null);
            this.setToolTipText(null);
        }
        this.updateScrollbars();
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gc = new GC((Drawable)this);
            this.paint(gc);
            gc.dispose();
        }
    }

    public Image getReportImage() {
        return this.reportImage;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        org.eclipse.swt.graphics.Rectangle contentBounds = this.getContentBounds();
        size.x = wHint != -1 ? wHint : (contentBounds.width > 0 ? contentBounds.width : 74);
        size.y = hHint != -1 ? hHint : (contentBounds.height > 0 ? contentBounds.height : 74);
        org.eclipse.swt.graphics.Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected void refresh() {
        if (this.reportImage != null) {
            this.reportImage.dispose();
            this.reportImage = null;
        }
        if (this.currentLink != null) {
            this.currentLink = null;
            this.setCursor(null);
            this.setToolTipText(null);
        }
        if (this.viewer == null) {
            this.refresh(null, null, null);
        } else if (this.viewer.hasDocument()) {
            try {
                Image image = this.renderPage();
                this.refresh(image, null, this.viewer.getDocument().getPages().get(this.viewer.getPageIndex()));
            }
            catch (JRException e) {
                this.refresh(null, e.getMessage(), null);
            }
        } else {
            this.refresh(null, this.viewer.getReason(), null);
        }
        this.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image renderPage() throws JRException {
        JasperPrint jasperPrint = this.viewer.getDocument();
        int imageWidth = (int)((double)jasperPrint.getPageWidth() * this.viewer.getZoom()) + 1;
        int imageHeight = (int)((double)jasperPrint.getPageHeight() * this.viewer.getZoom()) + 1;
        BufferedImage awtImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = (Graphics2D)awtImage.getGraphics();
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, g2d);
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(this.viewer.getPageIndex()));
            exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(this.viewer.getZoom()));
            exporter.exportReport();
        }
        finally {
            g2d.dispose();
        }
        g2d = (Graphics2D)awtImage.getGraphics();
        try {
            g2d.setColor(Color.black);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawRect(0, 0, imageWidth - 1, imageHeight - 1);
        }
        finally {
            g2d.dispose();
        }
        int[] data = ((DataBufferInt)awtImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(awtImage.getWidth(), awtImage.getHeight(), 32, palette);
        imageData.setPixels(0, 0, data.length, data, 0);
        return new Image((Device)this.getDisplay(), imageData);
    }

    public void setReportViewer(IReportViewer viewer) {
        Assert.isTrue((this.viewer == null ? 1 : 0) != 0);
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        if (viewer != null) {
            viewer.addReportViewerListener(this.listener);
        }
        this.refresh();
    }

    private void paint(GC gc) {
        if (this.isDisposed()) {
            return;
        }
        if (this.reportImage != null) {
            int y;
            int x;
            org.eclipse.swt.graphics.Rectangle bounds = this.reportImage.getBounds();
            org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
            if (bounds.width <= clientArea.width) {
                x = (clientArea.width - bounds.width) / 2;
            } else {
                x = -this.getHorizontalBar().getSelection() + 5;
                if (x > 0) {
                    gc.fillRectangle(0, 0, x, clientArea.height);
                }
                if (x + bounds.width < clientArea.width) {
                    gc.fillRectangle(x + bounds.width, 0, clientArea.width - x - bounds.width, bounds.height);
                }
            }
            if (bounds.height <= clientArea.height) {
                y = (clientArea.height - bounds.height) / 2;
            } else {
                y = -this.getVerticalBar().getSelection() + 5;
                if (y > 0) {
                    gc.fillRectangle(0, 0, clientArea.width, y);
                }
                if (y + bounds.height < clientArea.height) {
                    gc.fillRectangle(0, y + bounds.height, clientArea.width, clientArea.height - y - bounds.height);
                }
            }
            gc.drawImage(this.reportImage, x, y);
        } else if (this.errorMessage != null) {
            org.eclipse.swt.graphics.Rectangle bounds = this.getContentBounds();
            org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
            int x = 0;
            if (bounds.width > clientArea.width) {
                x = -this.getHorizontalBar().getSelection();
            }
            int y = 0;
            if (bounds.height > clientArea.height) {
                y = -this.getVerticalBar().getSelection();
            }
            gc.fillRectangle(clientArea);
            gc.setForeground(this.getDisplay().getSystemColor(3));
            gc.drawText(this.errorMessage, x + 5, y + 5);
        }
    }

    private void refresh(Image reportImage, String errorMessage, JRPrintPage page) {
        if (this.isDisposed()) {
            return;
        }
        this.reportImage = reportImage;
        this.errorMessage = errorMessage;
        this.page = page;
        if (this.currentLink != null) {
            this.currentLink = null;
            this.setCursor(null);
            this.setToolTipText(null);
        }
        this.initializeHypelinks();
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
        this.updateScrollbars();
        this.redraw();
    }

    private void updateScrollbars() {
        if (!this.updatingScrollbars) {
            this.updatingScrollbars = true;
            try {
                this.updateScrollbarsSafe();
            }
            finally {
                this.updatingScrollbars = false;
            }
        }
    }

    private void updateScrollbarsSafe() {
        int max;
        org.eclipse.swt.graphics.Rectangle bounds = this.getContentBounds();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        boolean hVisible = this.needHScroll(bounds.width, false);
        boolean vVisible = this.needVScroll(bounds.height, hVisible);
        if (!hVisible && vVisible) {
            hVisible = this.needHScroll(bounds.width, vVisible);
        }
        if (hBar != null) {
            hBar.setVisible(hVisible);
            if (!hVisible) {
                hBar.setSelection(0);
            }
        }
        if (vBar != null) {
            vBar.setVisible(vVisible);
            if (!vVisible) {
                vBar.setSelection(0);
            }
        }
        Point size = this.getSize();
        org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
        if (hVisible) {
            hBar.setPageIncrement(clientArea.width - hBar.getIncrement());
            max = bounds.width + (size.x - clientArea.width);
            hBar.setMaximum(max);
            hBar.setThumb(size.x > max ? max : size.x);
        }
        if (vVisible) {
            vBar.setPageIncrement(clientArea.height - vBar.getIncrement());
            max = bounds.height + (size.y - clientArea.height);
            vBar.setMaximum(max);
            vBar.setThumb(size.y > max ? max : size.y);
        }
    }

    private void onDispose() {
        if (this.reportImage != null) {
            this.reportImage.dispose();
        }
    }

    public Point getFitSize() {
        org.eclipse.swt.graphics.Rectangle bounds = this.getBounds();
        int borderWidth = this.getBorderWidth();
        return new Point(bounds.width - 2 * borderWidth - 10, bounds.height - 2 * borderWidth - 10);
    }

    public Point getFitSize(int contentWidth, int contentHeight) {
        org.eclipse.swt.graphics.Rectangle bounds = this.getBounds();
        int borderWidth = this.getBorderWidth();
        Point size = new Point(bounds.width - 2 * borderWidth - 10, bounds.height - 2 * borderWidth - 10);
        boolean vBarVisible = false;
        boolean hBarVisible = false;
        if (contentWidth > size.x) {
            size.y -= this.getHorizontalBar().getSize().y;
            hBarVisible = true;
        }
        if (contentHeight > size.y) {
            size.x -= this.getVerticalBar().getSize().x;
            vBarVisible = true;
        }
        if (vBarVisible && !hBarVisible && contentWidth > size.x) {
            size.y -= this.getHorizontalBar().getSize().y;
        }
        return size;
    }

    private void onMouseDown(Event event) {
        if (this.reportImage != null && event.button == 1 && this.currentLink == null) {
            this.dragging = true;
            this.dragSelectionX = event.x;
            this.dragSelectionH = this.getHorizontalBar().getSelection();
            this.dragSelectionY = event.y;
            this.dragSelectionV = this.getVerticalBar().getSelection();
            this.setCursor(CURSOR_SIZEALL);
        }
    }

    private void onMouseMove(Event event) {
        if (this.reportImage != null) {
            if (this.dragging) {
                this.setHorizontalSelection(this.dragSelectionH - event.x + this.dragSelectionX);
                this.setVerticalSelection(this.dragSelectionV - event.y + this.dragSelectionY);
                this.repaint();
            } else {
                this.updateHyperlink(event.x, event.y);
            }
        }
    }

    private void updateHyperlink(int x, int y) {
        JRPrintHyperlink link = this.getHyperlinkAt(x, y);
        if (link != null) {
            if (this.currentLink == null || this.currentLink != link) {
                this.currentLink = link;
                this.setCursor(CURSOR_HAND);
                this.setToolTipText(this.getLinkToolTip(link));
            }
        } else if (this.currentLink != null) {
            this.currentLink = null;
            this.setCursor(null);
            this.setToolTipText(null);
        }
    }

    private void onMouseUp(Event event) {
        if (this.reportImage != null) {
            if (this.dragging) {
                this.dragging = false;
                this.setCursor(null);
            }
            if (event.button == 1 && this.currentLink != null && this.currentLink == this.getHyperlinkAt(event.x, event.y)) {
                this.setCursor(null);
                try {
                    BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ViewerCanvas.this.handleHyperlinkClick();
                        }
                    });
                }
                finally {
                    this.setCursor(CURSOR_HAND);
                }
            }
            if (this.reportImage != null) {
                this.updateHyperlink(event.x, event.y);
            } else {
                this.currentLink = null;
                this.setCursor(null);
            }
        }
    }

    private void handleHyperlinkClick() {
        JRPrintHyperlink link = this.currentLink;
        if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REFERENCE) {
            this.notifyHyperlinkListeners(link);
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.LOCAL_ANCHOR) {
            System.out.println("change in swtjasperview: notifyHyperlinkListeners() for HIPERLINK_TYPE_LOCAL_ANCHOR");
            this.notifyHyperlinkListeners(link);
            Map<String, JRPrintAnchorIndex> anchorIndexes = this.viewer.getDocument().getAnchorIndexes();
            JRPrintAnchorIndex anchorIndex = anchorIndexes.get(this.currentLink.getHyperlinkAnchor());
            if (anchorIndex != null) {
                if (anchorIndex.getPageIndex() != this.viewer.getPageIndex()) {
                    this.viewer.setPageIndex(anchorIndex.getPageIndex());
                }
                if (this.reportImage != null) {
                    this.setHorizontalSelection((int)((double)anchorIndex.getElement().getX() * this.viewer.getZoom()));
                    this.setVerticalSelection((int)((double)anchorIndex.getElement().getY() * this.viewer.getZoom()));
                    this.repaint();
                }
            }
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.LOCAL_PAGE) {
            if (link.getHyperlinkPage() != null) {
                int page = link.getHyperlinkPage();
                this.viewer.setPageIndex(page - 1);
            }
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REMOTE_ANCHOR) {
            this.notifyHyperlinkListeners(link);
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REMOTE_PAGE) {
            this.notifyHyperlinkListeners(link);
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.CUSTOM) {
            this.notifyHyperlinkListeners(link);
        }
    }

    public void setHorizontalSelection(int selection) {
        ScrollBar sb = this.getHorizontalBar();
        sb.setSelection(Math.max(sb.getMinimum(), Math.min(selection, sb.getMaximum())));
    }

    public void setVerticalSelection(int selection) {
        ScrollBar sb = this.getVerticalBar();
        sb.setSelection(Math.max(sb.getMinimum(), Math.min(selection, sb.getMaximum())));
    }

    private boolean needHScroll(int contentWidth, boolean vVisible) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return false;
        }
        org.eclipse.swt.graphics.Rectangle hostRect = this.getBounds();
        int border = this.getBorderWidth();
        hostRect.width -= 2 * border;
        ScrollBar vBar = this.getVerticalBar();
        if (vVisible && vBar != null) {
            hostRect.width -= vBar.getSize().x;
        }
        return contentWidth > hostRect.width;
    }

    private boolean needVScroll(int contentHeight, boolean hVisible) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return false;
        }
        org.eclipse.swt.graphics.Rectangle hostRect = this.getBounds();
        int border = this.getBorderWidth();
        hostRect.height -= 2 * border;
        ScrollBar hBar = this.getHorizontalBar();
        if (hVisible && hBar != null) {
            hostRect.height -= hBar.getSize().y;
        }
        return contentHeight > hostRect.height;
    }

    private org.eclipse.swt.graphics.Rectangle getContentBounds() {
        if (this.reportImage != null) {
            org.eclipse.swt.graphics.Rectangle bounds = this.reportImage.getBounds();
            bounds.width += 10;
            bounds.height += 10;
            return bounds;
        }
        if (this.errorMessage != null) {
            GC gc = new GC((Drawable)this);
            Point extent = gc.textExtent(this.errorMessage);
            gc.dispose();
            return new org.eclipse.swt.graphics.Rectangle(0, 0, extent.x + 10, extent.y + 10);
        }
        return new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    }

    private Point translateRelativeToPage(int x, int y) {
        org.eclipse.swt.graphics.Rectangle bounds = this.reportImage.getBounds();
        org.eclipse.swt.graphics.Rectangle clientArea = this.getClientArea();
        int originX = bounds.width <= clientArea.width ? (clientArea.width - bounds.width) / 2 : -this.getHorizontalBar().getSelection() + 5;
        int originY = bounds.height <= clientArea.height ? (clientArea.height - bounds.height) / 2 : -this.getVerticalBar().getSelection() + 5;
        return new Point((int)((double)(x - originX - clientArea.x) / this.viewer.getZoom()), (int)((double)(y - originY - clientArea.y) / this.viewer.getZoom()));
    }

    private JRPrintHyperlink getHyperlinkAt(int x, int y) {
        Point point = this.translateRelativeToPage(x, y);
        JRPrintHyperlink hyperlink = null;
        for (int i = this.hyperlinkElements.size() - 1; i >= 0 && hyperlink == null; --i) {
            IHyperlinkContainer hlink = (IHyperlinkContainer)this.hyperlinkElements.get(i);
            hyperlink = hlink.getHyperlink(point);
        }
        return hyperlink;
    }

    private void initializeHypelinks() {
        this.hyperlinkElements.clear();
        if (this.page != null) {
            List<JRPrintElement> elements = this.page.getElements();
            try {
                this.initializeHyperlinks(0, 0, elements);
            }
            catch (JRException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initializeHyperlinks(int originX, int originY, List elements) throws JRException {
        if (elements != null) {
            for (JRPrintElement element : elements) {
                if (ViewerCanvas.getImageMapRenderer(element) != null) {
                    List<JRPrintImageAreaHyperlink> hyperlinks = ViewerCanvas.getImageMapRenderer(element).getImageAreaHyperlinks(new Rectangle(0, 0, element.getWidth(), element.getHeight()));
                    if (hyperlinks == null) continue;
                    this.hyperlinkElements.add(new ImageAreaHyperlink(originX + element.getX(), originY + element.getY(), hyperlinks));
                    continue;
                }
                if (element instanceof JRPrintHyperlink && ((JRPrintHyperlink)((Object)element)).getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
                    this.hyperlinkElements.add(new PrintHyperlink(originX, originY, element));
                    continue;
                }
                this.initializeHyperlinks(originX + element.getX(), originY + element.getY(), Compatibility.getChildren(element));
            }
        }
    }

    private static JRImageMapRenderer getImageMapRenderer(JRPrintElement element) {
        Renderable renderer;
        if (element instanceof JRPrintImage && (renderer = ((JRPrintImage)element).getRenderer()) instanceof JRImageMapRenderer) {
            return (JRImageMapRenderer)((Object)renderer);
        }
        return null;
    }

    private String getLinkToolTip(JRPrintHyperlink link) {
        String toolTip = null;
        toolTip = link.getHyperlinkTooltip();
        if (toolTip != null) {
            return toolTip;
        }
        switch (link.getHyperlinkTypeValue()) {
            case REFERENCE: {
                toolTip = link.getHyperlinkReference();
                break;
            }
            case LOCAL_ANCHOR: {
                if (link.getHyperlinkAnchor() == null) break;
                toolTip = "#" + link.getHyperlinkAnchor();
                break;
            }
            case LOCAL_PAGE: {
                if (link.getHyperlinkPage() == null) break;
                toolTip = "#page " + link.getHyperlinkPage();
                break;
            }
            case REMOTE_ANCHOR: {
                if (link.getHyperlinkReference() == null && link.getHyperlinkAnchor() == null) break;
                toolTip = "";
                if (link.getHyperlinkReference() != null) {
                    toolTip = toolTip + link.getHyperlinkReference();
                }
                if (this.currentLink.getHyperlinkAnchor() == null) break;
                toolTip = toolTip + "#" + this.currentLink.getHyperlinkAnchor();
                break;
            }
            case REMOTE_PAGE: {
                if (link.getHyperlinkReference() == null && link.getHyperlinkPage() == null) break;
                toolTip = "";
                if (link.getHyperlinkReference() != null) {
                    toolTip = toolTip + link.getHyperlinkReference();
                }
                if (link.getHyperlinkPage() == null) break;
                toolTip = toolTip + "#page " + link.getHyperlinkPage();
            }
        }
        return toolTip;
    }

    private void notifyHyperlinkListeners(JRPrintHyperlink link) {
        JRHyperlinkListener[] listeners = this.viewer.getHyperlinkListeners();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].gotoHyperlink(link);
                continue;
            }
            catch (JRException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ImageAreaHyperlink
    implements IHyperlinkContainer {
        private final int originX;
        private final int originY;
        private final List imageAreaHyperlinks;

        public ImageAreaHyperlink(int originX, int originY, List imageAreaHyperlinks) {
            this.originX = originX;
            this.originY = originY;
            this.imageAreaHyperlinks = imageAreaHyperlinks;
        }

        @Override
        public JRPrintHyperlink getHyperlink(Point point) {
            int x = point.x - this.originX;
            int y = point.y - this.originY;
            for (JRPrintImageAreaHyperlink areaHyperlink : this.imageAreaHyperlinks) {
                if (!areaHyperlink.getArea().containsPoint(x, y)) continue;
                return areaHyperlink.getHyperlink();
            }
            return null;
        }
    }

    private static class PrintHyperlink
    implements IHyperlinkContainer {
        private final int x;
        private final int y;
        private final JRPrintElement element;

        public PrintHyperlink(int originX, int originY, JRPrintElement element) {
            this.x = originX + element.getX();
            this.y = originY + element.getY();
            this.element = element;
        }

        private boolean inside(Point point) {
            return point.x >= this.x && point.x < this.x + this.element.getWidth() && point.y >= this.y && point.y < this.y + this.element.getHeight();
        }

        @Override
        public JRPrintHyperlink getHyperlink(Point point) {
            if (this.inside(point)) {
                return (JRPrintHyperlink)((Object)this.element);
            }
            return null;
        }
    }

    private static interface IHyperlinkContainer {
        public JRPrintHyperlink getHyperlink(Point var1);
    }
}

