/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.DefaultHyperlinkHandler;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.Messages;
import com.jasperassistant.designer.viewer.ReportViewer;
import com.jasperassistant.designer.viewer.StatusBar;
import com.jasperassistant.designer.viewer.actions.ExportAsCsvAction;
import com.jasperassistant.designer.viewer.actions.ExportAsHtmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsJasperReportsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsMultiXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsRtfAction;
import com.jasperassistant.designer.viewer.actions.ExportAsSingleXlsAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlAction;
import com.jasperassistant.designer.viewer.actions.ExportAsXmlWithImagesAction;
import com.jasperassistant.designer.viewer.actions.ExportMenuAction;
import com.jasperassistant.designer.viewer.actions.FirstPageAction;
import com.jasperassistant.designer.viewer.actions.LastPageAction;
import com.jasperassistant.designer.viewer.actions.NextPageAction;
import com.jasperassistant.designer.viewer.actions.PageNumberContributionItem;
import com.jasperassistant.designer.viewer.actions.PreviousPageAction;
import com.jasperassistant.designer.viewer.actions.PrintAction;
import com.jasperassistant.designer.viewer.actions.ReloadAction;
import com.jasperassistant.designer.viewer.actions.ZoomActualSizeAction;
import com.jasperassistant.designer.viewer.actions.ZoomComboContributionItem;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageWidthAction;
import com.jasperassistant.designer.viewer.actions.ZoomInAction;
import com.jasperassistant.designer.viewer.actions.ZoomOutAction;
import net.sf.jasperreports.view.JasperViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewerApp
extends ApplicationWindow {
    private ReportViewer reportViewer = new ReportViewer(2048);

    public ViewerApp() {
        super(null);
        this.addToolBar(0x800040);
        this.addMenuBar();
        this.setBlockOnOpen(true);
        this.initMenu();
        this.initToolBar();
    }

    private void initMenu() {
        MenuManager mm = this.getMenuBarManager();
        MenuManager export = new MenuManager(Messages.getString("ViewerApp.exportMenuLabel"));
        export.add((IAction)new ExportAsPdfAction(this.reportViewer));
        export.add((IAction)new ExportAsRtfAction(this.reportViewer));
        export.add((IAction)new ExportAsJasperReportsAction(this.reportViewer));
        export.add((IAction)new ExportAsHtmlAction(this.reportViewer));
        export.add((IAction)new ExportAsSingleXlsAction(this.reportViewer));
        export.add((IAction)new ExportAsMultiXlsAction(this.reportViewer));
        export.add((IAction)new ExportAsCsvAction(this.reportViewer));
        export.add((IAction)new ExportAsXmlAction(this.reportViewer));
        export.add((IAction)new ExportAsXmlWithImagesAction(this.reportViewer));
        MenuManager file = new MenuManager(Messages.getString("ViewerApp.fileMenuLabel"));
        file.add((IAction)new ReloadAction(this.reportViewer));
        file.add((IContributionItem)new Separator());
        file.add((IContributionItem)export);
        file.add((IContributionItem)new Separator());
        file.add((IAction)new PrintAction(this.reportViewer));
        mm.add((IContributionItem)file);
        MenuManager view = new MenuManager(Messages.getString("ViewerApp.viewMenuLabel"));
        view.add((IAction)new ZoomOutAction(this.reportViewer));
        view.add((IAction)new ZoomInAction(this.reportViewer));
        view.add((IContributionItem)new Separator());
        view.add((IAction)new ZoomActualSizeAction(this.reportViewer));
        view.add((IAction)new ZoomFitPageAction(this.reportViewer));
        view.add((IAction)new ZoomFitPageWidthAction(this.reportViewer));
        mm.add((IContributionItem)view);
        MenuManager nav = new MenuManager(Messages.getString("ViewerApp.navigateMenuLabel"));
        nav.add((IAction)new FirstPageAction(this.reportViewer));
        nav.add((IAction)new PreviousPageAction(this.reportViewer));
        nav.add((IAction)new NextPageAction(this.reportViewer));
        nav.add((IAction)new LastPageAction(this.reportViewer));
        mm.add((IContributionItem)nav);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ViewerApp.title"));
        shell.setImage(new Image(null, JasperViewer.class.getResourceAsStream("images/jricon.GIF")));
    }

    private void initToolBar() {
        ToolBarManager tbManager = this.getToolBarManager();
        ExportMenuAction exportMenu = new ExportMenuAction(this.reportViewer);
        ExportAsPdfAction pdfAction = null;
        pdfAction = new ExportAsPdfAction(this.reportViewer);
        exportMenu.getMenuManager().add((IAction)pdfAction);
        exportMenu.getMenuManager().add((IAction)new ExportAsRtfAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsJasperReportsAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsHtmlAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsSingleXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsMultiXlsAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsCsvAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsXmlAction(this.reportViewer));
        exportMenu.getMenuManager().add((IAction)new ExportAsXmlWithImagesAction(this.reportViewer));
        exportMenu.setDefaultAction((IAction)pdfAction);
        tbManager.add((IAction)exportMenu);
        tbManager.add((IAction)new PrintAction(this.reportViewer));
        tbManager.add((IAction)new ReloadAction(this.reportViewer));
        tbManager.add((IContributionItem)new Separator());
        tbManager.add((IAction)new FirstPageAction(this.reportViewer));
        tbManager.add((IAction)new PreviousPageAction(this.reportViewer));
        if (SWT.getPlatform().equals("win32")) {
            tbManager.add((IContributionItem)new PageNumberContributionItem(this.reportViewer));
        }
        tbManager.add((IAction)new NextPageAction(this.reportViewer));
        tbManager.add((IAction)new LastPageAction(this.reportViewer));
        tbManager.add((IContributionItem)new Separator());
        tbManager.add((IAction)new ZoomActualSizeAction(this.reportViewer));
        tbManager.add((IAction)new ZoomFitPageAction(this.reportViewer));
        tbManager.add((IAction)new ZoomFitPageWidthAction(this.reportViewer));
        tbManager.add((IContributionItem)new Separator());
        tbManager.add((IAction)new ZoomOutAction(this.reportViewer));
        tbManager.add((IContributionItem)new ZoomComboContributionItem(this.reportViewer));
        tbManager.add((IAction)new ZoomInAction(this.reportViewer));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Control reportViewerControl = this.reportViewer.createControl(container);
        reportViewerControl.setLayoutData((Object)new GridData(1808));
        StatusBar statusBar = new StatusBar();
        statusBar.setReportViewer(this.reportViewer);
        Control statusBarControl = statusBar.createControl(container);
        statusBarControl.setLayoutData((Object)new GridData(768));
        this.reportViewer.addHyperlinkListener(new DefaultHyperlinkHandler());
        return container;
    }

    public IReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            ViewerApp.usage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-F")) {
                fileName = args[i].substring(2);
            }
            if (!args[i].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        if (fileName == null) {
            ViewerApp.usage();
            return;
        }
        ViewerApp.openViewer(fileName, isXMLFile);
        System.exit(0);
    }

    private static void openViewer(String fileName, boolean isXMLFile) {
        ViewerApp app = new ViewerApp();
        app.getReportViewer().loadDocument(fileName, isXMLFile);
        app.open();
    }

    private static void usage() {
        System.out.println(Messages.getString("ViewerApp.usageLabel"));
        System.out.println(Messages.getString("ViewerApp.usage"));
    }
}

