/*
 * Decompiled with CFR 0.152.
 */
package com.jasperassistant.designer.viewer;

import com.jasperassistant.designer.viewer.util.BrowserUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.swt.custom.BusyIndicator;

public class DefaultHyperlinkHandler
implements JRHyperlinkListener {
    @Override
    public void gotoHyperlink(final JRPrintHyperlink link) throws JRException {
        if (link != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    DefaultHyperlinkHandler.this.gotoHyperlinkBusy(link);
                }
            });
        }
    }

    private void gotoHyperlinkBusy(JRPrintHyperlink link) {
        if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REFERENCE) {
            this.openLink(link.getHyperlinkReference());
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REMOTE_ANCHOR) {
            if (link.getHyperlinkReference() != null) {
                String href = link.getHyperlinkReference();
                if (link.getHyperlinkAnchor() != null) {
                    href = href + "#" + link.getHyperlinkAnchor();
                }
                this.openLink(href);
            }
        } else if (link.getHyperlinkTypeValue() == HyperlinkTypeEnum.REMOTE_PAGE && link.getHyperlinkReference() != null) {
            String href = link.getHyperlinkReference();
            if (link.getHyperlinkPage() != null) {
                href = href + "#JR_PAGE_ANCHOR_0_" + link.getHyperlinkPage();
            }
            this.openLink(href);
        }
    }

    private void openLink(String href) {
        BrowserUtils.openLink(href);
    }
}

