/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet361 {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Composite composite;
    static Canvas canvas;
    static Image image;
    static double translateX;
    static double translateY;
    static double rotate;

    static {
        image = null;
        translateX = 0.0;
        translateY = 0.0;
        rotate = 0.0;
    }

    public static void main(String[] args) {
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText("Translate and Rotate an AWT Image in an SWT GUI");
        shell.setLayout((Layout)new GridLayout(8, false));
        Button fileButton = new Button((Composite)shell, 8);
        fileButton.setText("&Open Image File");
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename = new FileDialog(shell).open();
                if (filename != null) {
                    image = Toolkit.getDefaultToolkit().getImage(filename);
                    canvas.repaint();
                }
            }
        });
        new Label((Composite)shell, 0).setText("Translate &X by:");
        final Combo translateXCombo = new Combo((Composite)shell, 0);
        translateXCombo.setItems(new String[]{"0", "image width", "image height", "100", "200"});
        translateXCombo.select(0);
        translateXCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                translateX = Snippet361.numericValue(translateXCombo);
                canvas.repaint();
            }
        });
        new Label((Composite)shell, 0).setText("Translate &Y by:");
        final Combo translateYCombo = new Combo((Composite)shell, 0);
        translateYCombo.setItems(new String[]{"0", "image width", "image height", "100", "200"});
        translateYCombo.select(0);
        translateYCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                translateY = Snippet361.numericValue(translateYCombo);
                canvas.repaint();
            }
        });
        new Label((Composite)shell, 0).setText("&Rotate by:");
        final Combo rotateCombo = new Combo((Composite)shell, 0);
        rotateCombo.setItems(new String[]{"0", "Pi", "Pi/2", "Pi/4", "Pi/8"});
        rotateCombo.select(0);
        rotateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                rotate = Snippet361.numericValue(rotateCombo);
                canvas.repaint();
            }
        });
        Button printButton = new Button((Composite)shell, 8);
        printButton.setText("&Print Image");
        printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle r = composite.getBounds();
                Point p = shell.toDisplay(r.x, r.y);
                org.eclipse.swt.graphics.Image snapshotImage = new org.eclipse.swt.graphics.Image((Device)display, r.width - 2, r.height - 2);
                GC snapshotGC = new GC((Drawable)display);
                snapshotGC.copyArea(snapshotImage, p.x + 1, p.y + 1);
                PrintDialog dialog = new PrintDialog(shell, 0);
                PrinterData data = new PrinterData();
                data.orientation = 2;
                dialog.setPrinterData(data);
                data = dialog.open();
                if (data != null) {
                    Printer printer = new Printer(data);
                    Point screenDPI = display.getDPI();
                    Point printerDPI = printer.getDPI();
                    int scaleFactor = printerDPI.x / screenDPI.x;
                    Rectangle trim = printer.computeTrim(0, 0, 0, 0);
                    if (printer.startJob("Print Image")) {
                        ImageData imageData = snapshotImage.getImageData();
                        org.eclipse.swt.graphics.Image printerImage = new org.eclipse.swt.graphics.Image((Device)printer, imageData);
                        GC printerGC = new GC((Drawable)printer);
                        if (printer.startPage()) {
                            printerGC.drawImage(printerImage, 0, 0, imageData.width, imageData.height, -trim.x, -trim.y, scaleFactor * imageData.width, scaleFactor * imageData.height);
                            printer.endPage();
                        }
                        printerGC.dispose();
                        printer.endJob();
                    }
                    printer.dispose();
                }
                snapshotImage.dispose();
                snapshotGC.dispose();
            }
        });
        composite = new Composite((Composite)shell, 0x1000800);
        GridData data = new GridData(4, 4, true, true, 8, 1);
        data.widthHint = 640;
        data.heightHint = 480;
        composite.setLayoutData((Object)data);
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        canvas = new Canvas(){

            @Override
            public void paint(Graphics g) {
                if (image != null) {
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform t = new AffineTransform();
                    t.translate(translateX, translateY);
                    t.rotate(rotate);
                    g2d.setTransform(t);
                    g.drawImage(image, 0, 0, this);
                }
            }
        };
        frame.add(canvas);
        composite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Image drawn in AWT Canvas";
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static double numericValue(Combo combo) {
        String string = combo.getText();
        if (string.equals("image width")) {
            return image.getWidth(canvas);
        }
        if (string.equals("image height")) {
            return image.getHeight(canvas);
        }
        if (string.equals("100")) {
            return 100.0;
        }
        if (string.equals("200")) {
            return 200.0;
        }
        if (string.equals("Pi")) {
            return Math.PI;
        }
        if (string.equals("Pi/2")) {
            return 1.5707963267948966;
        }
        if (string.equals("Pi/4")) {
            return 0.7853981633974483;
        }
        if (string.equals("Pi/8")) {
            return 0.39269908169872414;
        }
        Double d = 0.0;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return d;
    }
}

