/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import test.Graphics2DRenderer;

public class SWTTest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static String[] types = new String[]{"Arc2D.CHORD", "Arc2D.OPEN", "Arc2D.PIE"};

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(350, 350);
        shell.setLayout((Layout)new GridLayout());
        Canvas canvas = new Canvas((Composite)shell, 262144);
        GridData data = new GridData(1808);
        canvas.setLayoutData((Object)data);
        final Graphics2DRenderer renderer = new Graphics2DRenderer();
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point controlSize = ((Control)e.getSource()).getSize();
                GC gc = e.gc;
                renderer.prepareRendering(gc);
                Graphics2D g2d = renderer.getGraphics2D();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.yellow, controlSize.x, controlSize.y, Color.white));
                g2d.fillRect(0, 0, controlSize.x, controlSize.y);
                g2d.setFont(new Font("SansSerif", 1, 16));
                g2d.setColor(Color.blue);
                int w = controlSize.x;
                int h = controlSize.y;
                g2d.setStroke(new BasicStroke(5.0f));
                int i = 0;
                while (i < types.length) {
                    Arc2D.Float arc = new Arc2D.Float(i);
                    arc.setFrame((double)((i + 1) * w) * 0.2, (double)((i + 1) * h) * 0.2, (double)w * 0.17, (double)h * 0.17);
                    ((Arc2D)arc).setAngleStart(45.0);
                    ((Arc2D)arc).setAngleExtent(270.0);
                    g2d.setColor(Color.blue);
                    g2d.draw(arc);
                    g2d.setColor(Color.gray);
                    g2d.fill(arc);
                    g2d.setColor(Color.black);
                    g2d.drawString(types[i], (int)((double)((i + 1) * w) * 0.2), (int)((double)((i + 1) * h) * 0.2 - 3.0));
                    ++i;
                }
                g2d.translate(controlSize.x / 2, controlSize.y / 2);
                int nbOfSlices = 18;
                int i2 = 0;
                while (i2 < nbOfSlices) {
                    g2d.drawString("Angle = " + i2 * 360 / nbOfSlices + "\u00b0", 30, 0);
                    g2d.rotate(Math.PI * -2 / (double)nbOfSlices);
                    ++i2;
                }
                renderer.render(gc);
                gc.drawOval(0, 0, controlSize.x, controlSize.y);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        renderer.dispose();
        System.exit(0);
    }
}

