/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.views.ClosingListener;
import com.ez.analysisbrowser.views.CompositeItemImpl;
import com.ez.analysisbrowser.views.ScrollableItem;
import com.ez.analysisbrowser.views.Updater;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ScrollableToolbar {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Composite panel = null;
    private ArrayList<ScrollableItem> items = new ArrayList();
    private Composite center = null;
    private int[] visibleRange = new int[2];
    private int visibleWidth = 0;
    private ToolItem leftTi;
    private ToolItem leftEndTi;
    private ToolItem rightTi;
    private ToolItem rightEndTi;
    private ImageRegistry imageRegistry;
    private static int counter = 0;

    public ScrollableToolbar(Composite parent, ImageRegistry imageRegistry) {
        this.imageRegistry = imageRegistry;
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)new FormLayout());
        Composite left = new Composite(this.panel, 0x800000);
        FillLayout lfl = new FillLayout();
        lfl.marginHeight = 0;
        lfl.marginWidth = 0;
        lfl.spacing = 0;
        left.setLayout((Layout)lfl);
        this.center = new Composite(this.panel, 0);
        RowLayout cfl = new RowLayout();
        cfl.marginHeight = 0;
        cfl.marginWidth = 0;
        cfl.spacing = 0;
        cfl.fill = true;
        cfl.wrap = false;
        this.center.setLayout((Layout)cfl);
        this.center.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ScrollableToolbar.this.resize();
            }
        });
        this.center.addTraverseListener((TraverseListener)new ItemTraverseListener());
        Composite right = new Composite(this.panel, 0x800000);
        FillLayout rfl = new FillLayout();
        rfl.marginHeight = 0;
        rfl.marginWidth = 0;
        rfl.spacing = 0;
        right.setLayout((Layout)rfl);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        left.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        right.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)left, 10);
        fd.right = new FormAttachment((Control)right, -10);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.center.setLayoutData((Object)fd);
        ToolBar leftTb = new ToolBar(left, 0x800000);
        this.leftEndTi = new ToolItem(leftTb, 0x800000);
        this.setImageOrText(this.leftEndTi, "LEFT_END", "|<");
        this.leftEndTi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableToolbar.this.scrollLeft(true);
            }
        });
        this.leftTi = new ToolItem(leftTb, 0x800000);
        this.setImageOrText(this.leftTi, "LEFT", "<");
        this.leftTi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableToolbar.this.scrollLeft(false);
            }
        });
        ToolBar rightTb = new ToolBar(right, 0x800000);
        this.rightTi = new ToolItem(rightTb, 0x800000);
        this.setImageOrText(this.rightTi, "RIGHT", ">");
        this.rightTi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableToolbar.this.scrollRight(false);
            }
        });
        this.rightEndTi = new ToolItem(rightTb, 0x800000);
        this.setImageOrText(this.rightEndTi, "RIGHT_END", ">|");
        this.rightEndTi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollableToolbar.this.scrollRight(true);
            }
        });
        this.visibleWidth = this.center.getSize().x;
        this.panel.pack();
    }

    private void setImageOrText(ToolItem item, String imgKey, String text) {
        Image img = this.getImage(imgKey);
        if (img != null) {
            item.setImage(img);
        } else {
            item.setText(text);
        }
    }

    public Item addItem(String name, boolean forceShow) {
        int handle = counter++;
        final CompositeItemImpl pi = new CompositeItemImpl(this.imageRegistry, handle, this.center, name, new Updater(){

            @Override
            public void update() {
                ScrollableToolbar.this.update();
            }
        });
        this.items.add(pi);
        pi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!pi.isSelected()) {
                    int selectionIndex = ScrollableToolbar.this.getIndex(pi);
                    ScrollableToolbar.this.select(selectionIndex);
                }
            }
        });
        if (forceShow) {
            this.select(this.items.size() - 1);
            this.scrollRight(true);
        } else {
            if (this.computeRequiredWidth(this.visibleRange) + pi.getWidth() >= this.visibleWidth) {
                pi.hide();
            } else {
                this.visibleRange[1] = this.items.size();
            }
            this.update();
        }
        return pi;
    }

    private void resize() {
        this.visibleWidth = this.center.getSize().x;
        int startPos = this.getSelected();
        this.visibleRange = this.getVisible(true, startPos + 1);
        this.update();
    }

    private void scrollLeft(boolean allTheWay) {
        if (this.visibleRange[0] == 0) {
            return;
        }
        int startPos = 0;
        if (!allTheWay) {
            startPos = this.visibleRange[0] - 1;
        }
        this.visibleRange = this.getVisible(false, startPos);
        int selectionIndex = this.getSelected();
        if (selectionIndex >= this.visibleRange[1]) {
            selectionIndex = this.visibleRange[1] - 1;
            this.select(selectionIndex);
        }
        this.update();
    }

    private void scrollRight(boolean allTheWay) {
        if (this.visibleRange[1] == this.items.size()) {
            return;
        }
        int startPos = 0;
        startPos = allTheWay ? this.items.size() : this.visibleRange[1] + 1;
        this.visibleRange = this.getVisible(true, startPos);
        int selectionIndex = this.getSelected();
        if (selectionIndex < this.visibleRange[0]) {
            selectionIndex = this.visibleRange[0];
            this.select(selectionIndex);
        }
        this.update();
    }

    private int[] getVisible(boolean expandLeftFirst, int startPos) {
        int leftLimit = 0;
        int rightLimit = 0;
        if (expandLeftFirst) {
            leftLimit = startPos > 0 ? startPos - 1 : startPos;
            rightLimit = startPos > this.items.size() ? this.items.size() : startPos;
        } else {
            leftLimit = startPos < 0 ? 0 : startPos;
            rightLimit = startPos < this.items.size() ? startPos + 1 : startPos;
        }
        int[] range = new int[]{leftLimit, rightLimit};
        int requiredWidth = this.computeRequiredWidth(leftLimit, rightLimit);
        while (requiredWidth < this.visibleWidth) {
            range[0] = leftLimit;
            range[1] = rightLimit;
            if (expandLeftFirst) {
                if (leftLimit > 0) {
                    --leftLimit;
                } else {
                    if (rightLimit == this.items.size()) {
                        range[1] = rightLimit;
                        break;
                    }
                    ++rightLimit;
                }
            } else if (rightLimit < this.items.size()) {
                ++rightLimit;
            } else {
                if (leftLimit == 0) {
                    range[0] = leftLimit;
                    break;
                }
                --leftLimit;
            }
            requiredWidth = this.computeRequiredWidth(leftLimit, rightLimit);
        }
        return range;
    }

    private void makeVisible() {
        int i = 0;
        while (i < this.items.size()) {
            ScrollableItem it = this.items.get(i);
            if (i < this.visibleRange[0] || i >= this.visibleRange[1]) {
                it.hide();
            } else {
                it.hide();
                it.show();
            }
            ++i;
        }
    }

    private void update() {
        this.makeVisible();
        if (this.visibleRange[0] == 0) {
            this.leftTi.setEnabled(false);
            this.leftEndTi.setEnabled(false);
        } else {
            this.leftTi.setEnabled(true);
            this.leftEndTi.setEnabled(true);
        }
        if (this.visibleRange[1] == this.items.size()) {
            this.rightTi.setEnabled(false);
            this.rightEndTi.setEnabled(false);
        } else {
            this.rightTi.setEnabled(true);
            this.rightEndTi.setEnabled(true);
        }
        this.panel.getParent().layout(true, true);
    }

    public int getSelected() {
        int selected = -1;
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).isSelected()) {
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    public int getIndex(int handle) {
        int idx = -1;
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).getHandle() == handle) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    public int getIndex(Item item) {
        int idx = -1;
        if (item != null) {
            ScrollableItem it = (ScrollableItem)item;
            int i = 0;
            while (i < this.items.size()) {
                if (this.items.get(i).getHandle() == it.getHandle()) {
                    idx = i;
                    break;
                }
                ++i;
            }
        }
        return idx;
    }

    private int computeRequiredWidth(int[] range) {
        return this.computeRequiredWidth(range[0], range[1]);
    }

    private int computeRequiredWidth(int leftLimit, int rightLimit) {
        int visible = 0;
        if (leftLimit < 0) {
            leftLimit = 0;
        }
        if (rightLimit > this.items.size()) {
            rightLimit = this.items.size();
        }
        int i = leftLimit;
        while (i < rightLimit) {
            visible += this.items.get(i).getWidth();
            ++i;
        }
        return visible;
    }

    public boolean remove(Item item) {
        if (item != null) {
            int pos = this.getIndex(item);
            return this.remove(pos);
        }
        return false;
    }

    public boolean remove(int pos) {
        boolean ret = false;
        if (pos >= 0 && pos < this.items.size()) {
            int selectionIndex = this.getSelected();
            ScrollableItem pi = this.items.remove(pos);
            pi.hide();
            if (selectionIndex == pos) {
                if (selectionIndex >= this.items.size()) {
                    selectionIndex = this.items.size() - 1;
                }
                this.select(selectionIndex);
            }
            this.visibleRange = this.getVisible(true, selectionIndex + 1);
            this.update();
            ret = true;
        }
        return ret;
    }

    void select(int idx) {
        if (idx >= 0 && idx < this.items.size()) {
            for (ScrollableItem pi : this.items) {
                pi.setSelected(false);
            }
            ScrollableItem selectedItem = this.items.get(idx);
            selectedItem.setSelected(true);
            selectedItem.setFocus();
        }
    }

    public void addSelectionListener(int handle, SelectionListener listener) {
        for (ScrollableItem pi : this.items) {
            if (pi.getHandle() != handle) continue;
            pi.addSelectionListener(listener);
        }
    }

    public void setLayoutData(Object layoutData) {
        this.panel.setLayoutData(layoutData);
    }

    public void dispose() {
        this.panel.dispose();
    }

    private Image getImage(String imgKey) {
        if (this.imageRegistry != null) {
            return this.imageRegistry.get(imgKey);
        }
        return null;
    }

    public static interface Item {
        public void setText(String var1);

        public void setImageDescriptor(ImageDescriptor var1);

        public void addSelectionListener(SelectionListener var1);

        public String getText();

        public void setTooltip(String var1);

        public void setClosingListener(ClosingListener var1);
    }

    private class ItemTraverseListener
    implements TraverseListener {
        private ItemTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            int selectionIndex = ScrollableToolbar.this.getSelected();
            switch (e.keyCode) {
                case 0x1000004: {
                    if (selectionIndex >= ScrollableToolbar.this.items.size() - 1) break;
                    ScrollableToolbar.this.select(++selectionIndex);
                    if (selectionIndex >= ScrollableToolbar.this.visibleRange[1]) {
                        ScrollableToolbar.this.scrollRight(false);
                        break;
                    }
                    ScrollableToolbar.this.update();
                    break;
                }
                case 0x1000003: {
                    if (selectionIndex <= 0) break;
                    ScrollableToolbar.this.select(--selectionIndex);
                    if (selectionIndex < ScrollableToolbar.this.visibleRange[0]) {
                        ScrollableToolbar.this.scrollLeft(false);
                        break;
                    }
                    ScrollableToolbar.this.update();
                    break;
                }
            }
        }
    }
}

