/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.internal.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressPanel
extends Composite
implements IRunnableContext {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProgressPanel.class);
    protected ProgressIndicator progressIndicator;
    private ProgressMonitor progressMonitor = new ProgressMonitor();
    private String task = "";
    protected Label taskLabel;
    protected Label subTaskLabel;
    private List<IFinishedListener> finishedListeners = new ArrayList<IFinishedListener>();
    private TextRunnable tr = new TextRunnable();

    ProgressPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.taskLabel = new Label((Composite)this, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.taskLabel.setLayoutData((Object)gridData);
        this.taskLabel.setText("");
        this.progressIndicator = new ProgressIndicator((Composite)this);
        this.progressIndicator.setLayoutData((Object)new GridData(768));
        final Button cancel = new Button((Composite)this, 8);
        cancel.setText(Messages.getString(ProgressPanel.class, "cancel.button.text"));
        cancel.setLayoutData((Object)new GridData());
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cancel.setEnabled(false);
                ProgressPanel.this.progressMonitor.setCanceled(true);
            }
        });
        this.subTaskLabel = new Label((Composite)this, 0);
        this.subTaskLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.subTaskLabel.setText("");
    }

    public void run(boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.isDisposed()) {
            return;
        }
        Thread progressThread = new Thread(){

            @Override
            public void run() {
                Throwable exception = null;
                try {
                    try {
                        if (ProgressPanel.this.progressMonitor != null && !ProgressPanel.this.progressMonitor.isCanceled()) {
                            ProgressPanel.this.aboutToRun();
                            runnable.run((IProgressMonitor)ProgressPanel.this.progressMonitor);
                        }
                    }
                    catch (Throwable t) {
                        exception = t;
                        ProgressPanel.this.finished(exception);
                    }
                }
                finally {
                    ProgressPanel.this.finished(exception);
                }
            }
        };
        progressThread.start();
    }

    protected void aboutToRun() {
        L.debug("about to run");
    }

    protected void finished(Throwable t) {
        L.debug("about to run");
        for (IFinishedListener fl : this.finishedListeners) {
            if (this.progressMonitor == null) continue;
            fl.finished(this.progressMonitor.isCanceled(), t);
        }
    }

    public void addFinishedListener(IFinishedListener finishedListener) {
        if (finishedListener != null) {
            this.finishedListeners.add(finishedListener);
        }
    }

    public void removeFinishedListener(IFinishedListener finishedListener) {
        if (finishedListener != null) {
            this.finishedListeners.remove(finishedListener);
        }
    }

    public String shortenText(String textValue, Control control) {
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxExtent = gc.textExtent((String)textValue).x;
        int maxWidth = control.getBounds().width - 5;
        if (maxExtent < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int charsToClip = Math.round(0.95f * (float)length * (1.0f - (float)maxWidth / (float)maxExtent));
        int pivot = length / 2;
        int start = pivot - charsToClip / 2;
        int end = pivot + charsToClip / 2 + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            String s = String.valueOf(s1) + "..." + s2;
            int l = gc.textExtent((String)s).x;
            if (l < maxWidth) {
                gc.dispose();
                return s;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }

    public void cancelProgressMonitor() {
        this.progressMonitor.setCanceled(true);
    }

    private void setMessage(Label l, String message) {
        this.tr.l = l;
        this.tr.text = message;
        this.getDisplay().syncExec((Runnable)this.tr);
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private String fSubTask = "";
        private volatile boolean fIsCanceled;
        private final String DEFAULT_TASKNAME = Messages.getString(ProgressPanel.class, "default.task.name");

        private ProgressMonitor() {
        }

        public void beginTask(String name, final int totalWork) {
            if (ProgressPanel.this.isDisposed()) {
                return;
            }
            if (ProgressPanel.this.progressIndicator.isDisposed()) {
                return;
            }
            if (name == null) {
                ProgressPanel.this.task = "";
            } else {
                ProgressPanel.this.task = name;
            }
            String s = ProgressPanel.this.task;
            if (s.length() <= 0) {
                s = this.DEFAULT_TASKNAME;
            }
            ProgressPanel.this.setMessage(ProgressPanel.this.taskLabel, s);
            ProgressPanel.this.progressIndicator.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (totalWork == -1) {
                        ((ProgressMonitor)ProgressMonitor.this).ProgressPanel.this.progressIndicator.beginAnimatedTask();
                    } else {
                        ((ProgressMonitor)ProgressMonitor.this).ProgressPanel.this.progressIndicator.beginTask(totalWork);
                    }
                }
            });
        }

        public void done() {
            if (!ProgressPanel.this.progressIndicator.isDisposed()) {
                ProgressPanel.this.progressIndicator.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((ProgressMonitor)ProgressMonitor.this).ProgressPanel.this.progressIndicator.sendRemainingWork();
                        ((ProgressMonitor)ProgressMonitor.this).ProgressPanel.this.progressIndicator.done();
                    }
                });
            }
        }

        public void setTaskName(String name) {
            if (ProgressPanel.this.isDisposed()) {
                return;
            }
            if (name == null) {
                ProgressPanel.this.task = "";
            } else {
                ProgressPanel.this.task = name;
            }
            String s = ProgressPanel.this.task;
            if (s.length() <= 0) {
                s = this.DEFAULT_TASKNAME;
            }
            ProgressPanel.this.setMessage(ProgressPanel.this.taskLabel, s);
        }

        public boolean isCanceled() {
            return this.fIsCanceled;
        }

        public void setCanceled(boolean b) {
            this.fIsCanceled = b;
        }

        public void subTask(String name) {
            if (ProgressPanel.this.isDisposed()) {
                return;
            }
            if (ProgressPanel.this.subTaskLabel.isDisposed()) {
                return;
            }
            this.fSubTask = name == null ? "" : name;
            ProgressPanel.this.setMessage(ProgressPanel.this.subTaskLabel, this.fSubTask);
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void internalWorked(final double work) {
            if (ProgressPanel.this.isDisposed()) {
                return;
            }
            if (!ProgressPanel.this.progressIndicator.isDisposed()) {
                ProgressPanel.this.progressIndicator.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((ProgressMonitor)ProgressMonitor.this).ProgressPanel.this.progressIndicator.worked(work);
                    }
                });
            }
        }
    }

    class TextRunnable
    implements Runnable {
        String text;
        Label l;

        TextRunnable() {
        }

        @Override
        public void run() {
            if (ProgressPanel.this.isDisposed()) {
                return;
            }
            this.l.setText(this.text);
        }
    }
}

