/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.internal.Messages;
import com.ez.analysisbrowser.views.ClosingListener;
import com.ez.analysisbrowser.views.ScrollableItem;
import com.ez.analysisbrowser.views.Updater;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CompositeItemImpl
implements ScrollableItem {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DELETE_IMAGE_KEY = "DELETE";
    private static final String DELETE_DISABLED_IMAGE_KEY = "DELETE_DISABLED";
    private int handle = 0;
    private Composite item;
    private String text;
    private String tooltip;
    private ImageDescriptor imgDescriptor;
    private Image img;
    private int x = 0;
    private Composite parent;
    private boolean selected = false;
    private Updater updater;
    private Label l1;
    private Label l2;
    private Button l3;
    List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private ClosingListener closingListener;
    private ImageRegistry imageRegistry;

    public CompositeItemImpl(ImageRegistry imageRegistry, int handle, Composite parent, String text, Updater updater) {
        this.text = text;
        this.parent = parent;
        this.handle = handle;
        this.selected = false;
        this.updater = updater;
        this.imageRegistry = imageRegistry;
        this.materialize();
    }

    private void materialize() {
        if (this.item == null || this.item.isDisposed()) {
            this.item = new Composite(this.parent, 1);
            this.item.setBackground(this.parent.getDisplay().getSystemColor(26));
            Listener closeOthers = new Listener(){

                public void handleEvent(Event event) {
                    if (CompositeItemImpl.this.closingListener != null) {
                        CompositeItemImpl.this.closingListener.closeOthers();
                    }
                }
            };
            GridLayout gl = new GridLayout(3, false);
            gl.horizontalSpacing = 1;
            gl.verticalSpacing = 0;
            gl.marginBottom = 0;
            gl.marginTop = 0;
            gl.marginLeft = 0;
            gl.marginRight = 0;
            this.item.setLayout((Layout)gl);
            this.l1 = new Label(this.item, 0);
            this.l1.setToolTipText(this.tooltip);
            this.l1.setBackground(this.parent.getDisplay().getSystemColor(26));
            this.l2 = new Label(this.item, 0);
            this.l2.setText(this.text);
            this.l2.setToolTipText(this.tooltip);
            this.l2.setBackground(this.parent.getDisplay().getSystemColor(26));
            this.l2.setForeground(this.parent.getDisplay().getSystemColor(27));
            Menu popupMenu = new Menu((Control)this.l1);
            MenuItem closeOthersItem = new MenuItem(popupMenu, 0);
            closeOthersItem.setText(Messages.getString(CompositeItemImpl.class, "menu.item.text"));
            closeOthersItem.addListener(13, closeOthers);
            this.l1.setMenu(popupMenu);
            popupMenu = new Menu((Control)this.l2);
            closeOthersItem = new MenuItem(popupMenu, 0);
            closeOthersItem.setText(Messages.getString(CompositeItemImpl.class, "menu.item.text"));
            closeOthersItem.addListener(13, closeOthers);
            this.l2.setMenu(popupMenu);
            this.l3 = new Button(this.item, 0x800000);
            this.l3.setImage(this.imageRegistry.get(DELETE_DISABLED_IMAGE_KEY));
            this.l3.setBackground(this.parent.getDisplay().getSystemColor(26));
            this.l3.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    CompositeItemImpl.this.l3.setImage(CompositeItemImpl.this.imageRegistry.get(CompositeItemImpl.DELETE_DISABLED_IMAGE_KEY));
                }

                public void mouseEnter(MouseEvent e) {
                    CompositeItemImpl.this.l3.setImage(CompositeItemImpl.this.imageRegistry.get(CompositeItemImpl.DELETE_IMAGE_KEY));
                }
            });
            this.l3.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.button < 3) {
                        CompositeItemImpl.this.closeItem();
                    }
                }
            });
            popupMenu = new Menu((Control)this.l3);
            closeOthersItem = new MenuItem(popupMenu, 0);
            closeOthersItem.setText(Messages.getString(CompositeItemImpl.class, "menu.item.text"));
            closeOthersItem.addListener(13, closeOthers);
            this.l3.setMenu(popupMenu);
            this.l3.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == ' ') {
                        CompositeItemImpl.this.closeItem();
                    }
                    if (e.keyCode == 0x1000004 || e.keyCode == 0x1000003) {
                        CompositeItemImpl.this.l3.getParent().getParent().forceFocus();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.l3.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    CompositeItemImpl.this.l3.setImage(CompositeItemImpl.this.imageRegistry.get(CompositeItemImpl.DELETE_DISABLED_IMAGE_KEY));
                    CompositeItemImpl.this.updater.update();
                }

                public void focusGained(FocusEvent e) {
                    CompositeItemImpl.this.l3.setImage(CompositeItemImpl.this.imageRegistry.get(CompositeItemImpl.DELETE_IMAGE_KEY));
                }
            });
            this.item.setToolTipText(this.tooltip);
            if (this.imgDescriptor != null) {
                this.img = this.imgDescriptor.createImage();
                this.l1.setImage(this.img);
            }
            this.item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (CompositeItemImpl.this.img != null) {
                        CompositeItemImpl.this.img.dispose();
                    }
                }
            });
            Listener traverseListener = this.parent.getListeners(31)[0];
            if (traverseListener != null) {
                this.item.addListener(31, traverseListener);
            }
            this.setSelected(this.selected);
            if (this.selected) {
                Event ev = new Event();
                ev.widget = this.item;
                ev.data = this;
                SelectionEvent event = new SelectionEvent(ev);
                for (SelectionListener l : this.listeners) {
                    l.widgetSelected(event);
                }
            }
            MouseAdapter clickAdapter = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Event ev = new Event();
                    ev.widget = CompositeItemImpl.this.item;
                    SelectionEvent event = new SelectionEvent(ev);
                    for (SelectionListener l : CompositeItemImpl.this.listeners) {
                        l.widgetSelected(event);
                    }
                }
            };
            this.item.addMouseListener((MouseListener)clickAdapter);
            this.l1.addMouseListener((MouseListener)clickAdapter);
            this.l2.addMouseListener((MouseListener)clickAdapter);
        }
    }

    private void closeItem() {
        if (this.closingListener != null) {
            this.closingListener.closing();
        }
    }

    @Override
    public void show() {
        this.materialize();
    }

    @Override
    public void hide() {
        if (this.item != null && !this.item.isDisposed()) {
            this.item.dispose();
            this.item = null;
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setFocus() {
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setFocus();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.item != null && !this.item.isDisposed()) {
            if (selected) {
                this.item.setBackground(this.parent.getDisplay().getSystemColor(26));
                this.l1.setBackground(this.parent.getDisplay().getSystemColor(26));
                this.l2.setBackground(this.parent.getDisplay().getSystemColor(26));
                this.l3.setBackground(this.parent.getDisplay().getSystemColor(26));
                this.l2.setForeground(this.parent.getDisplay().getSystemColor(27));
                this.l3.setVisible(true);
            } else {
                this.item.setBackground(null);
                this.l1.setBackground(null);
                this.l2.setBackground(null);
                this.l2.setForeground(null);
                this.l3.setBackground(null);
                this.l3.setVisible(false);
            }
            this.x = this.item.computeSize((int)-1, (int)-1).x;
        }
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor id) {
        this.imgDescriptor = id;
        if (this.item != null && !this.item.isDisposed()) {
            if (this.img != null) {
                this.img.dispose();
                this.img = null;
            }
            if (this.imgDescriptor != null) {
                this.img = this.imgDescriptor.createImage();
            }
            this.l1.setImage(this.img);
            this.x = this.item.computeSize((int)-1, (int)-1).x;
            this.updater.update();
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (this.item != null && !this.item.isDisposed()) {
            this.l2.setText(text);
            this.x = this.item.computeSize((int)-1, (int)-1).x;
            this.updater.update();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setToolTipText(tooltip);
            this.l1.setToolTipText(tooltip);
            this.l2.setToolTipText(tooltip);
        }
    }

    @Override
    public int getWidth() {
        return this.x;
    }

    @Override
    public void setClosingListener(ClosingListener closingListener) {
        this.closingListener = closingListener;
    }
}

