/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.views.ClosingListener;
import com.ez.analysisbrowser.views.ScrollableItem;
import com.ez.analysisbrowser.views.Updater;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ButtonItemImpl
implements ScrollableItem {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private int handle = 0;
    private Button item;
    private String text;
    private String tooltip;
    private ImageDescriptor imgDescriptor;
    private Image img;
    private int x = 0;
    private Composite parent;
    private boolean selected = false;
    private Updater updater;
    List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public ButtonItemImpl(int handle, Composite parent, String text, Updater updater) {
        this.text = text;
        this.parent = parent;
        this.handle = handle;
        this.selected = false;
        this.updater = updater;
        this.listeners.add((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ButtonItemImpl.this.selected = ((Button)e.widget).getSelection();
            }
        });
        this.materialize();
    }

    private void materialize() {
        if (this.item == null || this.item.isDisposed()) {
            this.item = new Button(this.parent, 0x800002);
            this.item.setText(this.text);
            this.item.setToolTipText(this.tooltip);
            if (this.imgDescriptor != null) {
                this.img = this.imgDescriptor.createImage();
                this.item.setImage(this.img);
            }
            this.item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ButtonItemImpl.this.img != null) {
                        ButtonItemImpl.this.img.dispose();
                    }
                }
            });
            this.x = this.item.computeSize((int)-1, (int)-1).x;
            this.item.setSelection(this.selected);
            for (SelectionListener l : this.listeners) {
                this.item.addSelectionListener(l);
            }
        }
    }

    @Override
    public void show() {
        this.materialize();
    }

    @Override
    public void hide() {
        if (this.item != null && !this.item.isDisposed()) {
            for (SelectionListener l : this.listeners) {
                this.item.removeSelectionListener(l);
            }
            this.item.dispose();
            this.item = null;
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
        if (this.item != null && !this.item.isDisposed()) {
            this.item.addSelectionListener(listener);
        }
    }

    @Override
    public void setFocus() {
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setFocus();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.item != null && !this.item.isDisposed() && this.item.getSelection() != selected) {
            this.item.setSelection(selected);
        }
        this.selected = selected;
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor id) {
        this.imgDescriptor = id;
        if (this.item != null && !this.item.isDisposed()) {
            if (this.img != null) {
                this.img.dispose();
                this.img = null;
            }
            if (this.imgDescriptor != null) {
                this.img = this.imgDescriptor.createImage();
            }
            this.item.setImage(this.img);
            this.x = this.item.computeSize((int)-1, (int)-1).x;
            this.updater.update();
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setText(text);
            this.x = this.item.computeSize((int)-1, (int)-1).x;
            this.updater.update();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        if (this.item != null && !this.item.isDisposed()) {
            this.item.setToolTipText(tooltip);
        }
    }

    @Override
    public int getWidth() {
        return this.x;
    }

    @Override
    public void setClosingListener(ClosingListener closingListener) {
    }
}

