/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.Activator;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.AbstractActionDescriptor;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionDescriptor;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.actions.NullContext;
import com.ez.analysisbrowser.internal.Messages;
import com.ez.analysisbrowser.views.AbstractScrollableItemsView;
import com.ez.analysisbrowser.views.ActionsFilteredTree;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.analysisbrowser.views.ClosingListener;
import com.ez.analysisbrowser.views.ErrorPane;
import com.ez.analysisbrowser.views.ExceptionPane;
import com.ez.analysisbrowser.views.ProgressPanel;
import com.ez.analysisbrowser.views.ScrollableToolbar;
import com.ez.internal.utils.LogUtil;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.model.CategoryEntry;
import com.ez.workspace.model.CategoryManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.GuidePart;
import test.TestScrollableToolbar;

public class BrowserPanel
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BrowserPanel.class);
    private int sashX = -1;
    private int sashY = -1;
    private ScrollableToolbar stb = null;
    private ToolItem expandActions = null;
    private ToolItem expandMessages = null;
    private ExpandMessagesAdapter expandAdapter = null;
    private Composite content = null;
    private StackLayout contentLayout = null;
    private Composite messageArea = null;
    private StackLayout messageAreaLayout = null;
    private ImageRegistry imageRegistry = null;
    private Cursor busy = null;
    private Cursor saved = null;
    private BrowserManager bm = null;
    private ProgressPanel pp = null;
    private List<EntryInfo> entries = new ArrayList<EntryInfo>();
    private int current = 0;
    private int toSave = -1;
    private IActionContext startContext;
    private boolean hasScrollabletoolbar = true;
    String aId = "com.ez.analysis.base.explore.projects";

    public BrowserPanel(Composite parent, ImageRegistry imageRegistry, BrowserManager bm, boolean hasScrollabletoolbar, String aId) {
        super(parent, 0);
        if (bm == null) {
            throw new IllegalArgumentException("manager must exist");
        }
        this.hasScrollabletoolbar = hasScrollabletoolbar;
        this.aId = aId;
        this.imageRegistry = imageRegistry;
        this.bm = bm;
        this.bm.setPanel(this);
        this.startContext = bm.getStartContext();
        this.createContents();
        this.busy = new Cursor((Device)this.getDisplay(), 1);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BrowserPanel.this.stb != null) {
                    BrowserPanel.this.stb.dispose();
                }
                if (BrowserPanel.this.busy != null) {
                    BrowserPanel.this.busy.dispose();
                }
            }
        });
    }

    private Image getImage(String imgKey) {
        if (this.imageRegistry != null) {
            return this.imageRegistry.get(imgKey);
        }
        return null;
    }

    private void createContents() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        if (this.hasScrollabletoolbar) {
            this.stb = new ScrollableToolbar(this, this.imageRegistry);
            this.stb.setLayoutData(new GridData(768));
        }
        Composite bottom = this.createBottom(this);
        bottom.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private Composite createGuide(Composite parent) {
        Composite guide = new Composite(parent, 0);
        guide.setLayout((Layout)new FillLayout());
        ImageDescriptor id1 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"analysis.png");
        Image img1 = id1.createImage();
        ImageDescriptor id2 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"start.png");
        Image img2 = id2.createImage();
        ImageDescriptor id3 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"folder-explore.png");
        Image img3 = id3.createImage();
        ImageDescriptor id4 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"category.png");
        Image img4 = id4.createImage();
        ImageDescriptor gid1 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"guide1.png");
        Image gimg1 = gid1.createImage();
        ImageDescriptor gid2 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"guide2.png");
        Image gimg2 = gid2.createImage();
        ImageDescriptor gid3 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"guide3.png");
        Image gimg3 = gid3.createImage();
        ImageDescriptor gid4 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"guide4.png");
        Image gimg4 = gid4.createImage();
        ImageDescriptor gid5 = ImageDescriptor.createFromFile(TestScrollableToolbar.class, (String)"guide5.png");
        Image gimg5 = gid5.createImage();
        GuidePart part1 = new GuidePart(guide, 0);
        part1.setImage(img1);
        part1.setGuideImg(gimg1);
        GuidePart part2 = new GuidePart(guide, 0);
        part2.setImage(img2);
        part2.setGuideImg(gimg2);
        GuidePart part3 = new GuidePart(guide, 0);
        part3.setImage(img3);
        part3.setGuideImg(gimg3);
        GuidePart part4 = new GuidePart(guide, 0);
        part4.setImage(img4);
        part4.setGuideImg(gimg4);
        GuidePart part5 = new GuidePart(guide, 0);
        part5.setImage(img4);
        part5.setGuideImg(gimg5);
        return guide;
    }

    private Composite createBottom(Composite parent) {
        Composite bottom = new Composite(parent, 0);
        GridLayout tcl = new GridLayout(2, false);
        tcl.horizontalSpacing = 0;
        tcl.verticalSpacing = 0;
        tcl.marginHeight = 0;
        tcl.marginWidth = 0;
        bottom.setLayout((Layout)tcl);
        Composite main = new Composite(bottom, 0);
        main.setLayout((Layout)new FormLayout());
        main.setLayoutData((Object)new GridData(1808));
        Composite side = this.createSideToolbar(bottom);
        side.setLayoutData((Object)new GridData(2, 4, false, true));
        this.fillMainArea(main);
        return bottom;
    }

    private Composite createSideToolbar(Composite parent) {
        Composite side = new Composite(parent, 0);
        side.setLayout((Layout)new GridLayout());
        ToolBar topBar = new ToolBar(side, 0x800200);
        this.expandActions = new ToolItem(topBar, 32);
        Image expActionsImg = this.getImage("EXPAND");
        if (expActionsImg != null) {
            this.expandActions.setImage(expActionsImg);
        } else {
            this.expandActions.setText("<<");
        }
        this.expandActions.setToolTipText(Messages.getString(BrowserPanel.class, "expand.action.tootip.label"));
        topBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BrowserPanel.this.expandActions.getToolTipText();
            }
        });
        topBar.pack();
        topBar.setLayoutData((Object)new GridData(2, 1, false, true));
        ToolBar bottomBar = new ToolBar(side, 0x800200);
        this.expandMessages = new ToolItem(bottomBar, 32);
        Image expImg = this.getImage("EXPAND");
        if (expImg != null) {
            this.expandMessages.setImage(expImg);
        } else {
            this.expandMessages.setText("<<");
        }
        this.expandMessages.setToolTipText(Messages.getString(BrowserPanel.class, "expand.messages.tooltip.label"));
        bottomBar.pack();
        bottomBar.setLayoutData((Object)new GridData(2, 3, false, true));
        bottomBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BrowserPanel.this.expandMessages.getToolTipText();
            }
        });
        return side;
    }

    private void fillMainArea(final Composite composite) {
        final Sash vSash = new Sash(composite, 512);
        Composite left = this.createLeftComposite(composite);
        Composite right = this.createRightComposite(composite);
        final FormData vSashData = new FormData();
        vSashData.top = new FormAttachment(0, 0);
        vSashData.bottom = new FormAttachment(100, 0);
        vSashData.left = new FormAttachment(70, 0);
        this.expandActions.setSelection(true);
        vSash.setLayoutData((Object)vSashData);
        vSash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = vSash.getBounds();
                Rectangle shellRect = composite.getClientArea();
                int right = shellRect.width - sashRect.width - 100;
                e.x = Math.max(Math.min(e.x, right), 100);
                if (e.x != sashRect.x) {
                    BrowserPanel.this.sashX = e.x;
                    vSashData.left = new FormAttachment(0, BrowserPanel.this.sashX);
                    composite.layout();
                }
            }
        });
        this.expandActions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = ((ToolItem)e.widget).getSelection();
                vSashData.left = sel ? (BrowserPanel.this.sashX >= 0 ? new FormAttachment(0, BrowserPanel.this.sashX) : new FormAttachment(70, 0)) : new FormAttachment(100, 0);
                composite.layout();
            }
        });
        FormData leftData = new FormData();
        leftData.top = new FormAttachment(0, 0);
        leftData.right = new FormAttachment((Control)vSash, 0);
        leftData.left = new FormAttachment(0, 0);
        leftData.bottom = new FormAttachment(100, 0);
        left.setLayoutData((Object)leftData);
        FormData rightData = new FormData();
        rightData.top = new FormAttachment(0, 0);
        rightData.right = new FormAttachment(100, 0);
        rightData.left = new FormAttachment((Control)vSash, 0);
        rightData.bottom = new FormAttachment(100, 0);
        right.setLayoutData((Object)rightData);
    }

    private Composite createLeftComposite(Composite parent) {
        final Composite all = new Composite(parent, 0);
        Composite topArea = new Composite(all, 0);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        topArea.setLayout((Layout)gl);
        this.content = new Composite(topArea, 0);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.contentLayout = new StackLayout();
        this.contentLayout.marginHeight = 0;
        this.contentLayout.marginWidth = 0;
        this.content.setLayout((Layout)this.contentLayout);
        final Sash hSash = new Sash(all, 256);
        this.messageArea = new Composite(all, 2048);
        this.messageAreaLayout = new StackLayout();
        this.messageAreaLayout.marginHeight = 0;
        this.messageAreaLayout.marginWidth = 0;
        this.messageArea.setLayout((Layout)this.messageAreaLayout);
        this.addStartAnalysis(false);
        FormLayout form = new FormLayout();
        all.setLayout((Layout)form);
        FormData topAreaData = new FormData();
        topAreaData.left = new FormAttachment(0, 0);
        topAreaData.right = new FormAttachment(100, 0);
        topAreaData.top = new FormAttachment(0, 0);
        topAreaData.bottom = new FormAttachment((Control)hSash, 0);
        topArea.setLayoutData((Object)topAreaData);
        final FormData hSashData = new FormData();
        hSashData.left = new FormAttachment(0, 0);
        hSashData.right = new FormAttachment(100, 0);
        hSashData.top = new FormAttachment(100, 0);
        hSash.setLayoutData((Object)hSashData);
        this.expandMessages.setSelection(false);
        FormData messageData = new FormData();
        messageData.left = new FormAttachment(0, 0);
        messageData.right = new FormAttachment(100, 0);
        messageData.top = new FormAttachment((Control)hSash, 0);
        messageData.bottom = new FormAttachment(100, 0);
        this.messageArea.setLayoutData((Object)messageData);
        hSash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = hSash.getBounds();
                Rectangle shellRect = all.getClientArea();
                int top = shellRect.height - sashRect.height - 20;
                e.y = Math.max(Math.min(e.y, top), 20);
                if (e.y != sashRect.y) {
                    BrowserPanel.this.sashY = e.y;
                    hSashData.top = new FormAttachment(0, BrowserPanel.this.sashY);
                    all.layout();
                }
            }
        });
        this.expandAdapter = new ExpandMessagesAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                this.state = expandMessages.getSelection();
                this.update();
            }

            @Override
            protected void update() {
                hSashData.top = this.state ? (sashY >= 0 ? new FormAttachment(0, sashY) : new FormAttachment(90, 0)) : new FormAttachment(100, 0);
                all.layout();
            }
        };
        this.expandMessages.addSelectionListener((SelectionListener)this.expandAdapter);
        return all;
    }

    public void addStartAnalysis(boolean isExploreProjects) {
        this.addStartAnalysis(isExploreProjects, this.aId);
    }

    public void addStartAnalysis(boolean isExploreProjects, String aId) {
        IActionDescriptor descriptor;
        IActionContext ctx = isExploreProjects ? null : this.startContext;
        boolean addContext = false;
        if (ctx == null) {
            descriptor = this.bm.getAnalysis(aId);
            if (descriptor == null) {
                L.error("null descriptor for {}", (Object)aId);
            }
            this.startContext = new NullContext(descriptor == null ? null : descriptor.getId());
            if (!this.bm.isUsagesView()) {
                addContext = true;
            }
            ctx = this.startContext;
        } else {
            descriptor = null;
            if (ctx != null) {
                descriptor = this.bm.getAnalysis(ctx.getId());
            }
            if (descriptor == null) {
                descriptor = this.bm.getAnalysis(aId);
            }
            addContext = true;
        }
        if (addContext) {
            this.add(descriptor, ctx);
            List history = (List)ctx.getData().get("IActionContext.actions.path");
            if (history != null) {
                for (IActionContext c : history) {
                    IActionDescriptor d = this.bm.getAnalysis(c.getId());
                    this.add(d, c);
                }
            }
        }
    }

    public List<IActionDescriptor> removeFromCurrent() {
        ArrayList<IActionDescriptor> descriptors = new ArrayList<IActionDescriptor>();
        if (this.stb != null) {
            if (this.current > 0) {
                List<EntryInfo> slist = this.entries.subList(this.current, this.entries.size());
                for (EntryInfo ei : slist) {
                    descriptors.add(ei.getDescriptor());
                    ei.setContent(null);
                    ei.setDescriptor(null);
                    ScrollableToolbar.Item it = ei.getTabItem();
                    this.stb.remove(it);
                    ei.setTabItem(null);
                }
                this.current = this.stb.getSelected();
                slist.clear();
            }
        } else {
            L.warn("null scrollableToolabar in removeFromCurrent()");
        }
        return descriptors;
    }

    public IActionDescriptor removeCurrent() {
        IActionDescriptor removed = null;
        if (this.stb != null) {
            EntryInfo info = this.entries.remove(this.current);
            removed = info.getDescriptor();
            info.setContent(null);
            info.setDescriptor(null);
            this.stb.remove(info.getTabItem());
            info.setTabItem(null);
            this.bm.setCurrentContext(null);
            this.current = this.stb.getSelected();
        } else {
            L.warn("null scrollableToolabar in removeFromCurrent()");
        }
        return removed;
    }

    private void removeOthers() {
        if (this.stb != null) {
            ArrayList<EntryInfo> toRemove = new ArrayList<EntryInfo>();
            EntryInfo keep = this.entries.get(this.current);
            ScrollableToolbar.Item keepItem = keep.getTabItem();
            int ref = this.stb.getIndex(keepItem);
            for (EntryInfo ei : this.entries) {
                if (this.stb.getIndex(ei.getTabItem()) == ref) continue;
                toRemove.add(ei);
            }
            for (EntryInfo ei : toRemove) {
                this.entries.remove(ei);
                IActionDescriptor removed = ei.getDescriptor();
                removed.dispose();
                ei.setContent(null);
                ei.setDescriptor(null);
                this.stb.remove(ei.getTabItem());
                ei.setTabItem(null);
            }
            this.current = this.stb.getSelected();
        } else {
            L.warn("null scrollableToolabar in removeFromCurrent()");
        }
    }

    void refreshCurrent() {
        if (this.entries.size() > 0 && this.current >= 0) {
            EntryInfo ei = this.entries.get(this.current);
            IActionDescriptor descriptor = ei.getDescriptor();
            String name = descriptor.getName();
            IActionContext selContext = null;
            if (descriptor.getState() != null && descriptor.getState().getData() != null) {
                selContext = (IActionContext)descriptor.getState().getData().get("selectedContext");
            }
            if (selContext == null) {
                this.bm.setCurrentContext(descriptor.getState());
            } else {
                this.bm.setCurrentContext(selContext);
            }
            this.bm.setViewHint(name);
            this.doLayout(ei);
        } else {
            this.clearCurrent();
        }
    }

    private void clearCurrent() {
        this.bm.setCurrentContext(null);
        this.bm.setViewHint(null);
    }

    public void add(final IActionDescriptor descriptor, IActionContext ac) {
        if (ac == null) {
            ac = new NullContext(descriptor.getId());
        }
        IActionContext context = ac;
        final EntryInfo entryInfo = new EntryInfo();
        this.entries.add(entryInfo);
        int pos = this.entries.size() - 1;
        IAction action = null;
        Map<String, Object> cdata = context.getData();
        String persistentHint = null;
        this.current = pos;
        if (((AbstractActionDescriptor)descriptor).isSaveStateCandidate()) {
            this.toSave = pos;
        }
        entryInfo.setDescriptor(descriptor);
        entryInfo.setInput(context);
        if (cdata != null) {
            persistentHint = (String)cdata.get("IActionContext.persistent.hint.key");
        }
        if (persistentHint != null) {
            descriptor.loadState(persistentHint);
        } else {
            action = descriptor.getAction();
            if (action != null) {
                action.setInputContext(context);
            }
        }
        String name = descriptor.getName();
        String tooltip = descriptor.getShortDescription();
        ImageDescriptor imgDescriptor = descriptor.getImageDescriptor();
        this.bm.setViewHint(name);
        this.bm.updateTools(false);
        ScrollableToolbar.Item item = null;
        if (this.stb != null) {
            item = this.stb.addItem(name, true);
            item.setTooltip(tooltip);
            item.setImageDescriptor(imgDescriptor);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserPanel.this.current = BrowserPanel.this.stb.getSelected();
                    if (((AbstractActionDescriptor)descriptor).isSaveStateCandidate()) {
                        BrowserPanel.this.toSave = BrowserPanel.this.current;
                    }
                    BrowserPanel.this.refreshCurrent();
                    BrowserPanel.this.expandAdapter.update();
                }
            });
            item.setClosingListener(new ClosingListener(){

                @Override
                public void closing() {
                    IActionDescriptor rem = BrowserPanel.this.removeCurrent();
                    rem.dispose();
                    BrowserPanel.this.refreshCurrent();
                    BrowserPanel.this.bm.updateTools();
                }

                @Override
                public void closeOthers() {
                    BrowserPanel.this.removeOthers();
                    BrowserPanel.this.refreshCurrent();
                }
            });
            entryInfo.setTabItem(item);
        }
        if (action == null) {
            Composite result = descriptor.getResultViewer().create(this.content, descriptor.getAction(), this.bm);
            entryInfo.setContent(result);
            this.contentLayout.topControl = result;
            this.content.layout(true, true);
        } else {
            this.refreshCurrent();
            ProgressPanel pp = new ProgressPanel(this.content, 0);
            entryInfo.setContent(pp);
            pp.addFinishedListener(new RunProgressFinishedListener(entryInfo, descriptor, pp));
            try {
                pp.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (!monitor.isCanceled()) {
                            descriptor.getAction().execute(monitor);
                            L.debug("Action finished");
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                L.error("", (Throwable)e);
            }
            catch (InterruptedException e) {
                L.error("", (Throwable)e);
            }
        }
        if (item != null) {
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserPanel.this.doLayout(entryInfo);
                }
            });
        }
        this.doLayout(entryInfo);
    }

    public void runInPlace(final IAction action, IFinishedListener onFinish) {
        this.expandAdapter.show(true);
        this.saved = this.contentLayout.topControl.getCursor();
        this.contentLayout.topControl.setCursor(this.busy);
        this.contentLayout.topControl.setEnabled(false);
        this.content.layout(true, true);
        EntryInfo ei = this.entries.get(this.current);
        this.pp = new ProgressPanel(this.messageArea, 0);
        this.pp.addFinishedListener(new ProgressFinishedListener(onFinish, this.pp, ei));
        ei.setMessageAreaControl((Control)this.pp);
        this.messageAreaLayout.topControl = this.pp;
        this.messageArea.layout(true, true);
        try {
            this.pp.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        action.execute(monitor);
                    }
                    catch (RuntimeException re) {
                        L.error("", (Throwable)re);
                        LogUtil.displayErrorMessage((Throwable)re, (String)re.getMessage(), (Plugin)Activator.getDefault());
                        throw re;
                    }
                    catch (Throwable t) {
                        L.error("", t);
                        LogUtil.displayErrorMessage((Throwable)t, (String)t.getMessage(), (Plugin)Activator.getDefault());
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            L.error("", (Throwable)e);
        }
        catch (InterruptedException e) {
            L.error("", (Throwable)e);
        }
    }

    private Composite createRightComposite(Composite parent) {
        Composite ac = this.createActionsComposite(parent);
        return ac;
    }

    private Composite createPropertiesComposite(Composite parent) {
        Composite properties = new Composite(parent, 0);
        properties.setLayout((Layout)new GridLayout());
        Table table = new Table(properties, 67586);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        String[] titles = new String[]{Messages.getString(BrowserPanel.class, "properties.title1"), Messages.getString(BrowserPanel.class, "properties.title2")};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        int count = 50;
        int i2 = 0;
        while (i2 < count) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, "p" + i2);
            item.setText(1, "" + (int)(Math.random() * 100.0));
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            table.getColumn(i2).pack();
            ++i2;
        }
        return properties;
    }

    public IActionDescriptor getCurrent() {
        EntryInfo ei = this.entries.get(this.current);
        return ei.getDescriptor();
    }

    public EntryInfo getCurrentEntryInfo() {
        return this.entries.get(this.current);
    }

    public IActionDescriptor getToSave() {
        if (this.toSave < 0 || this.toSave >= this.entries.size()) {
            return null;
        }
        EntryInfo ei = this.entries.get(this.toSave);
        return ei.getDescriptor();
    }

    private Composite createActionsComposite(Composite parent) {
        Composite actions = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        actions.setLayout((Layout)gl);
        PatternFilter filter = new PatternFilter();
        final ActionsFilteredTree tree = new ActionsFilteredTree(actions, 772, filter, true);
        tree.setInitialText(Messages.getString(BrowserPanel.class, "actions.filter.message"));
        TreeViewer viewer = tree.getViewer();
        viewer.setContentProvider((IContentProvider)this.bm.getActionsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.bm.getActionsLabelProvider());
        viewer.setInput((Object)"root");
        viewer.expandToLevel(2);
        viewer.setComparator(new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (CategoryManager.FAVOURITE_NAME.equals(o1)) {
                    return -1;
                }
                if (CategoryManager.FAVOURITE_NAME.equals(o2)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        }));
        viewer.addDoubleClickListener((IDoubleClickListener)new CategoryDoubleClick());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button fBtn;
                TreeSelection sel = (TreeSelection)event.getSelection();
                if (!sel.isEmpty() && (fBtn = (Button)tree.getData("favourite.btn")) != null && !fBtn.isDisposed()) {
                    fBtn.setEnabled(true);
                    ICategory catSel = (ICategory)sel.getFirstElement();
                    if (catSel instanceof CategoryEntry) {
                        fBtn.setEnabled(true);
                        if ("com.ez.category.favourite".equals(catSel.getCategory())) {
                            fBtn.setImage(ActionsFilteredTree.frImage);
                            fBtn.setToolTipText("Remove analysis from Favorites");
                        } else {
                            fBtn.setImage(ActionsFilteredTree.fImage);
                            fBtn.setToolTipText("Add analysis to Favorites");
                        }
                    } else {
                        fBtn.setImage(ActionsFilteredTree.fImage);
                        fBtn.setToolTipText("Handle selected analysis as Favorites");
                        fBtn.setEnabled(false);
                    }
                }
            }
        });
        this.installContextMenu(viewer);
        this.bm.registerActionsViewer(viewer);
        tree.setLayoutData(new GridData(4, 4, true, true));
        return actions;
    }

    private void installContextMenu(final TreeViewer viewer) {
        final MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection iss;
                if (viewer.getSelection().isEmpty()) {
                    return;
                }
                if (viewer.getSelection() instanceof IStructuredSelection && (iss = (IStructuredSelection)viewer.getSelection()).getFirstElement() instanceof ICategoryEntry) {
                    ICategoryEntry ce = (ICategoryEntry)iss.getFirstElement();
                    IActionContext context = BrowserPanel.this.bm.getCurrentContext();
                    BrowserPanel.this.bm.contributeToContextMenu(ce.getId(), menuMgr, context);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        viewer.getControl().setMenu(menu);
    }

    private void doLayout(EntryInfo entryInfo) {
        this.contentLayout.topControl = entryInfo.getContent();
        this.content.layout(true, true);
        this.messageAreaLayout.topControl = entryInfo.getMessageAreaControl();
        this.messageArea.layout(true, true);
    }

    public int getTabSize() {
        return this.entries.size();
    }

    public void cancelAction() {
        if (this.pp != null && !this.pp.isDisposed()) {
            this.pp.cancelProgressMonitor();
        }
    }

    private BrowserManager openView(IActionContext context, String viewID) {
        BrowserManager bm = null;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getWorkbenchWindows()[0];
            AbstractScrollableItemsView analysisBrowserViewPart = (AbstractScrollableItemsView)window.getActivePage().showView(viewID, null, 1);
            bm = analysisBrowserViewPart.bm;
        }
        catch (PartInitException e) {
            L.error("while activating view: {}", (Object)viewID, (Object)e);
        }
        return bm;
    }

    boolean isEmpty() {
        return this.entries.size() == 0;
    }

    private final class CategoryDoubleClick
    implements IDoubleClickListener {
        private CategoryDoubleClick() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection iss;
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (iss = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof ICategoryEntry) {
                ICategoryEntry ce = (ICategoryEntry)iss.getFirstElement();
                L.debug("will launch {}", (Object)ce);
                IActionContext context = BrowserPanel.this.bm.getCurrentContext();
                String viewID = ce.getViewId();
                BrowserManager newBm = null;
                if (viewID != null) {
                    newBm = BrowserPanel.this.openView(context, viewID);
                } else {
                    L.debug("analysis without viewId in definition: {}", (Object)ce.getId());
                }
                if (newBm != null) {
                    newBm.launch(ce.getId(), context);
                } else {
                    BrowserPanel.this.bm.launch(ce.getId(), context);
                }
            }
        }
    }

    public class EntryInfo {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private Composite content;
        private ScrollableToolbar.Item tabItem;
        private IActionDescriptor descriptor;
        private IActionContext input;
        private Control msgArea;

        public Composite getContent() {
            return this.content;
        }

        public void dispose() {
            this.setTabItem(null);
            if (this.content != null) {
                this.content.dispose();
            }
            this.content = null;
            this.msgArea = null;
            IActionContext state = this.descriptor.getState();
            if (state instanceof AbstractActionContext) {
                ((AbstractActionContext)state).dispose();
            }
            ((AbstractActionDescriptor)this.descriptor).cancel();
            this.setDescriptor(null);
        }

        public void setMessageAreaControl(Control msgArea) {
            this.msgArea = msgArea;
        }

        public Control getMessageAreaControl() {
            return this.msgArea;
        }

        public IActionContext getInput() {
            return this.input;
        }

        public void setInput(IActionContext input) {
            this.input = input;
        }

        public ScrollableToolbar.Item getTabItem() {
            return this.tabItem;
        }

        public IActionDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(IActionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void setContent(Composite content) {
            if (this.content != null && !this.content.isDisposed()) {
                this.content.dispose();
                this.content = null;
            }
            this.content = content;
        }

        public void setTabItem(ScrollableToolbar.Item item) {
            this.tabItem = item;
        }
    }

    private abstract class ExpandMessagesAdapter
    extends SelectionAdapter {
        protected boolean state = false;

        private ExpandMessagesAdapter() {
        }

        public void show(boolean state) {
            this.state = state;
            BrowserPanel.this.expandMessages.setSelection(state);
            this.update();
        }

        protected abstract void update();
    }

    private final class ProgressFinishedListener
    implements IFinishedListener {
        private final IFinishedListener onFinish;
        private final ProgressPanel pp;
        private final EntryInfo ei;

        private ProgressFinishedListener(IFinishedListener onFinish, ProgressPanel pp, EntryInfo ei) {
            this.onFinish = onFinish;
            this.pp = pp;
            this.ei = ei;
        }

        @Override
        public void finished(boolean canceled, Throwable t) {
            if (this.pp.isDisposed()) {
                return;
            }
            this.pp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BrowserPanel.this.expandAdapter.show(false);
                    BrowserPanel.this.bm.updateTools();
                    if (ProgressFinishedListener.this.ei.getContent() != null && !ProgressFinishedListener.this.ei.getContent().isDisposed()) {
                        ProgressFinishedListener.this.ei.getContent().setCursor(BrowserPanel.this.saved);
                        BrowserPanel.this.saved = null;
                        ProgressFinishedListener.this.ei.getContent().setEnabled(true);
                    }
                    ProgressFinishedListener.this.ei.setMessageAreaControl(null);
                    if (((Object)((Object)ProgressFinishedListener.this.pp)).equals(((BrowserPanel)((ProgressFinishedListener)ProgressFinishedListener.this).BrowserPanel.this).messageAreaLayout.topControl)) {
                        ((BrowserPanel)((ProgressFinishedListener)ProgressFinishedListener.this).BrowserPanel.this).messageAreaLayout.topControl = null;
                        BrowserPanel.this.messageArea.layout(true, true);
                    }
                    ProgressFinishedListener.this.pp.dispose();
                }
            });
            if (this.onFinish != null) {
                try {
                    this.onFinish.finished(canceled, t);
                }
                catch (Exception e) {
                    L.debug("", (Throwable)e);
                }
            }
        }
    }

    private final class RunProgressFinishedListener
    implements IFinishedListener {
        private final EntryInfo entryInfo;
        private final IActionDescriptor descriptor;
        private final ProgressPanel pp;

        private RunProgressFinishedListener(EntryInfo entryInfo, IActionDescriptor descriptor, ProgressPanel pp) {
            this.entryInfo = entryInfo;
            this.descriptor = descriptor;
            this.pp = pp;
        }

        @Override
        public void finished(final boolean canceled, final Throwable t) {
            if (this.pp.isDisposed()) {
                return;
            }
            if (t != null) {
                L.debug("there was an error");
                L.error("", t);
                LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(BrowserPanel.class, "execution.error.msg"), (Plugin)Activator.getDefault(), (boolean)false);
            }
            if (canceled) {
                L.debug("action was canceled");
            }
            this.pp.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Composite result = null;
                    if (canceled && t == null) {
                        BrowserPanel.this.clearCurrent();
                        BrowserPanel.this.bm.updateTools();
                        result = new ErrorPane(BrowserPanel.this.content, RunProgressFinishedListener.this.descriptor, Messages.getString(BrowserPanel.class, "canceled.msg"));
                    } else if (t != null) {
                        result = new ExceptionPane(BrowserPanel.this.content, RunProgressFinishedListener.this.descriptor, t);
                    } else {
                        IResultViewer resultViewer = RunProgressFinishedListener.this.descriptor.getResultViewer();
                        if (resultViewer == null) {
                            result = new ErrorPane(BrowserPanel.this.content, RunProgressFinishedListener.this.descriptor);
                        } else {
                            try {
                                result = resultViewer.create(BrowserPanel.this.content, RunProgressFinishedListener.this.descriptor.getAction(), BrowserPanel.this.bm);
                            }
                            catch (Exception e) {
                                L.error("while creating viewer", (Throwable)e);
                                LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(BrowserPanel.class, "creating.viewer.error.msg"), (Plugin)Activator.getDefault(), (boolean)false);
                            }
                            if (result == null) {
                                result = new ErrorPane(BrowserPanel.this.content, RunProgressFinishedListener.this.descriptor);
                            }
                            BrowserPanel.this.bm.updateTools();
                        }
                    }
                    if (BrowserPanel.this.stb != null) {
                        int newIdx = BrowserPanel.this.stb.getIndex(RunProgressFinishedListener.this.entryInfo.tabItem);
                        if (BrowserPanel.this.stb.getSelected() != newIdx) {
                            BrowserPanel.this.stb.select(newIdx);
                        }
                    } else {
                        L.warn("null scrollToolbar at selection of tab");
                    }
                    RunProgressFinishedListener.this.entryInfo.setContent(result);
                    ((BrowserPanel)((RunProgressFinishedListener)RunProgressFinishedListener.this).BrowserPanel.this).contentLayout.topControl = result;
                    BrowserPanel.this.content.layout(true, true);
                }
            });
        }
    }
}

