/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.Activator;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionDescriptor;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.actions.NullContext;
import com.ez.analysisbrowser.internal.DescriptorFactory;
import com.ez.analysisbrowser.internal.Messages;
import com.ez.analysisbrowser.views.AbstractScrollableItemsView;
import com.ez.analysisbrowser.views.ActionsContentProvider;
import com.ez.analysisbrowser.views.ActionsLabelProvider;
import com.ez.analysisbrowser.views.BrowserPanel;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.model.CategoryManager;
import com.ez.workspace.model.EZWorkspace;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserManager
implements IActionManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BrowserManager.class);
    public static final int ACTIONS_DEFAULT_EXPAND_LEVEL = 2;
    private ActionsContentProvider actionsContentProvider;
    private ILabelProvider actionsLabelProvider;
    private CategoryManager cm = Activator.getDefault().getCategoryManager();
    private BrowserPanel browserPanel;
    private IActionContext startContext;
    private IActionContext currentContext;
    private AbstractScrollableItemsView view;
    private TreeViewer actionsViewer;
    private ImageRegistry imageRegistry;

    public BrowserManager(AbstractScrollableItemsView view, ImageRegistry imageRegistry) {
        this.view = view;
        this.imageRegistry = imageRegistry;
        this.actionsContentProvider = new ActionsContentProvider();
        this.actionsLabelProvider = new ActionsLabelProvider(imageRegistry);
    }

    public ITreeContentProvider getActionsContentProvider() {
        return this.actionsContentProvider;
    }

    public ILabelProvider getActionsLabelProvider() {
        return this.actionsLabelProvider;
    }

    public void setStartAnalysis(IActionContext context) {
        this.currentContext = this.startContext = context;
    }

    public IActionContext getStartContext() {
        return this.startContext;
    }

    public IActionDescriptor getAnalysis(String id) {
        if (id != null) {
            EZAnalysisType analysisType = EZWorkspace.getInstance().getAnalysisById(id);
            ICategoryEntry ce = this.cm.getCategoryEntry(id);
            if (ce != null) {
                return DescriptorFactory.getActionDescriptor(ce);
            }
            if (analysisType != null) {
                return DescriptorFactory.getActionDescriptor(analysisType);
            }
        }
        return null;
    }

    public Collection<ICategory> getEntries(String cid) {
        return this.cm.getEntries(cid);
    }

    @Override
    public void launch(String actionDescriptorID, IActionContext iActionContext) {
        IActionDescriptor descriptor = this.getAnalysis(actionDescriptorID);
        this.launch(descriptor, iActionContext);
    }

    public void launch(IActionDescriptor descriptor, IActionContext iActionContext) {
        if (descriptor == null) {
            throw new IllegalStateException("null descriptor");
        }
        if (descriptor.isEmbedded()) {
            this.browserPanel.add(descriptor, iActionContext);
        } else {
            this.runExternal(descriptor, iActionContext);
        }
    }

    public void runExternal(final IActionDescriptor descriptor, IActionContext actionContext) {
        if (descriptor == null) {
            throw new IllegalStateException("null descriptor");
        }
        if (actionContext == null) {
            actionContext = new NullContext(descriptor.getId());
        }
        final IActionContext ac = actionContext;
        final IAction action = descriptor.getAction();
        if (action == null) {
            L.warn("no action was configured for descriptor: {}", (Object)descriptor.getId());
        } else {
            Job j = new Job(Messages.getString(BrowserManager.class, "job.name", new String[]{descriptor.getName()})){

                protected IStatus run(IProgressMonitor monitor) {
                    int status = 0;
                    Throwable rt = null;
                    try {
                        action.setInputContext(ac);
                        action.execute(monitor);
                    }
                    catch (Throwable t) {
                        status = 4;
                        rt = t;
                        L.error("{} failed", (Object)descriptor.getName(), (Object)t);
                    }
                    return new Status(status, "com.ez.analysisbrowser", Messages.getString(BrowserManager.class, "status.message", new String[]{descriptor.getName()}), rt);
                }
            };
            j.schedule();
        }
    }

    @Override
    public void runInPlace(IAction action, IFinishedListener onFinish) {
        this.updateTools(false);
        this.browserPanel.runInPlace(action, onFinish);
    }

    public void setPanel(BrowserPanel browserPanel) {
        this.browserPanel = browserPanel;
    }

    public IActionDescriptor getCurrent() {
        return this.browserPanel.getCurrent();
    }

    public BrowserPanel.EntryInfo getCurrentEntryInfo() {
        return this.browserPanel.getCurrentEntryInfo();
    }

    public IActionDescriptor getToSave() {
        return this.browserPanel.getToSave();
    }

    public void setViewHint(String name) {
    }

    public IActionContext getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public void setCurrentContext(IActionContext context) {
        this.currentContext = context;
        if (context != null) {
            Map<String, Object> data = context.getData();
            if (data != null && data.containsKey("selection")) {
                Object sel = data.get("selection");
                if (sel instanceof ISelection) {
                    this.view.setSelection((ISelection)sel);
                }
            } else {
                this.view.setSelection((ISelection)new StructuredSelection());
            }
        }
        this.updateActions();
    }

    public void registerActionsViewer(TreeViewer viewer) {
        this.actionsViewer = viewer;
    }

    public void updateActions() {
        this.actionsContentProvider.contextChanged(this.currentContext);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BrowserManager.this.actionsViewer != null && !BrowserManager.this.actionsViewer.getControl().isDisposed()) {
                    BrowserManager.this.actionsViewer.setInput((Object)"root");
                    BrowserManager.this.actionsViewer.expandToLevel(2);
                }
            }
        });
    }

    public void contributeToContextMenu(String actionDescriptorID, MenuManager menuMgr, IActionContext context) {
        IActionDescriptor descriptor = this.getAnalysis(actionDescriptorID);
        if (descriptor != null) {
            descriptor.contributeContextMenu(menuMgr, context);
        } else {
            L.warn("contributeToContextMenu: could not get descriptor for {}", (Object)actionDescriptorID);
        }
    }

    public ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    public void cancelAction() {
        this.browserPanel.cancelAction();
    }

    public boolean isUsagesView() {
        return "com.ez.analysisbrowser.views.UsagesView".equals(((IViewSite)this.view.getSite()).getId());
    }

    public void updateTools(boolean enable) {
        IActionBars actionBars = this.view.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        ActionContributionItem item = (ActionContributionItem)toolBar.find("move to separate view Id");
        if (item == null) {
            L.debug("tollbar item not found {}", (Object)"move to separate view Id");
            return;
        }
        if (this.browserPanel.getTabSize() <= 1) {
            item.getAction().setEnabled(false);
        } else {
            item.getAction().setEnabled(enable);
        }
    }

    public void updateTools() {
        this.updateTools(true);
    }

    public void addExploreProjectsAnalysis() {
        this.browserPanel.addStartAnalysis(true);
    }

    public void addExploreAnalysis(String analysisId, boolean isExploreProjects) {
        this.browserPanel.addStartAnalysis(isExploreProjects, analysisId);
    }

    public String getViewSecondaryId() {
        return this.view.getSid();
    }
}

