/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.internal.Messages;
import com.ez.workspace.analysis.category.ICategory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

class ActionsLabelProvider
extends LabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ImageRegistry registry;
    private static final Point size = new Point(16, 16);

    public ActionsLabelProvider(ImageRegistry registry) {
        this.registry = registry;
    }

    public String getText(Object elem) {
        String label = elem.toString();
        label = elem instanceof ICategory ? ((ICategory)elem).getName() : Messages.getString(ActionsLabelProvider.class, "unknown.element.label");
        return label;
    }

    public Image getImage(Object elem) {
        Image img = null;
        if (elem instanceof ICategory) {
            ImageDescriptor descriptor = ((ICategory)elem).getImageDescriptor();
            String eId = ((ICategory)elem).getId();
            boolean hasSettings = ((ICategory)elem).hasSettings();
            if (descriptor != null && this.registry != null) {
                img = hasSettings ? this.getDecoratedImage(this.registry, eId, descriptor) : this.getImage(this.registry, eId, descriptor);
            }
        }
        return img;
    }

    private Image getImage(ImageRegistry registry, String eId, ImageDescriptor descriptor) {
        Image img = registry.get(eId);
        if (img == null) {
            registry.put(eId, descriptor);
            img = registry.get(eId);
        }
        return img;
    }

    private String getDecoratedId(String baseId, String decoration) {
        if (decoration != null) {
            return String.valueOf(baseId) + decoration;
        }
        return baseId;
    }

    private Image getDecoratedImage(ImageRegistry registry, String baseImageId, ImageDescriptor descriptor) {
        ImageDescriptor overlay = null;
        Image baseImage = this.getImage(registry, baseImageId, descriptor);
        overlay = registry.getDescriptor("SETTINGS");
        String decoratedImageId = this.getDecoratedId(baseImageId, "settings");
        if (registry.get(decoratedImageId) == null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[3] = overlay;
            DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(baseImage, imageDescriptorArray, size){};
            registry.put(decoratedImageId, (ImageDescriptor)decoratedImage);
        }
        return registry.get(decoratedImageId);
    }
}

