/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.Activator;
import com.ez.workspace.model.CategoryEntry;
import com.ez.workspace.model.CategoryManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ActionsFilteredTree
extends FilteredTree {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final String FAVOURITE_BTN = "favourite.btn";
    protected static final Image fImage = Activator.getImageDescriptor("icons/favourite.png").createImage();
    protected static final Image frImage = Activator.getImageDescriptor("icons/favourite-remove.png").createImage();
    protected static final Image pressedImage = new Image((Device)Display.getCurrent(), fImage, 2);

    public ActionsFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, treeStyle, filter, useNewLook);
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        GridData treeCompositeGD = (GridData)this.treeComposite.getLayoutData();
        treeCompositeGD.horizontalSpan = 2;
    }

    protected Composite createFilterControls(Composite parent) {
        Composite fctrl = super.createFilterControls(parent);
        Composite p = fctrl.getParent();
        GridLayout upLayout = (GridLayout)this.getLayout();
        upLayout.numColumns = 2;
        final Button fButton = new Button(p, 8);
        fButton.setText("");
        fButton.setImage(fImage);
        fButton.setEnabled(false);
        fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fButton.setImage(pressedImage);
                TreeSelection sel = (TreeSelection)ActionsFilteredTree.this.getViewer().getSelection();
                if (!sel.isEmpty()) {
                    CategoryEntry catSel = (CategoryEntry)sel.getFirstElement();
                    CategoryManager cm = Activator.getDefault().getCategoryManager();
                    cm.switchCategory(catSel);
                    ActionsFilteredTree.this.getViewer().refresh();
                }
                super.widgetSelected(e);
            }
        });
        p.setData(FAVOURITE_BTN, (Object)fButton);
        return fctrl;
    }

    public void dispose() {
        if (fImage != null && !fImage.isDisposed()) {
            fImage.dispose();
        }
        if (frImage != null && !frImage.isDisposed()) {
            frImage.dispose();
        }
        if (pressedImage != null && !pressedImage.isDisposed()) {
            pressedImage.dispose();
        }
        super.dispose();
    }
}

