/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysisbrowser.views;

import com.ez.analysisbrowser.Activator;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionDescriptor;
import com.ez.analysisbrowser.internal.DescriptorFactory;
import com.ez.workspace.analysis.category.ICategory;
import com.ez.workspace.analysis.category.ICategoryEntry;
import com.ez.workspace.model.CategoryManager;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionsContentProvider
implements ITreeContentProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ActionsContentProvider.class);
    private CategoryManager cm = Activator.getDefault().getCategoryManager();
    IActionContext context = null;

    ActionsContentProvider() {
    }

    public Object[] getChildren(Object elem) {
        Object[] rez = null;
        if (elem instanceof ICategory) {
            String cid = ((ICategory)elem).getId();
            Collection elems = this.cm.getEntries(cid);
            rez = this.filterElems(elems, this.context);
        }
        return rez;
    }

    public Object getParent(Object elem) {
        ICategory parent = null;
        if (elem instanceof ICategory) {
            parent = this.cm.getCategory(((ICategory)elem).getCategory());
        }
        return parent;
    }

    public boolean hasChildren(Object elem) {
        String cid;
        Collection elems;
        Object[] filtered;
        return elem instanceof ICategory && (filtered = this.filterElems(elems = this.cm.getEntries(cid = ((ICategory)elem).getId()), this.context)) != null && filtered.length > 0;
    }

    public Object[] getElements(Object elem) {
        String cid;
        Collection elems;
        Collection all;
        Object[] rez = null;
        rez = elem.equals("root") ? ((all = this.cm.getTopCategories()) == null ? new String[]{"noActions"} : this.filterElems(all, this.context)) : (elem instanceof ICategory ? ((elems = this.cm.getEntries(cid = ((ICategory)elem).getId())) != null ? this.filterElems(elems, this.context) : new Object[]{}) : new Object[]{});
        return rez;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public void contextChanged(IActionContext context) {
        this.context = context;
    }

    private boolean canHandle(ICategory cat, IActionContext context) {
        boolean ret;
        block4: {
            block3: {
                ret = false;
                if (!(cat instanceof ICategoryEntry)) break block3;
                IActionDescriptor actionDescriptor = DescriptorFactory.getActionDescriptor((ICategoryEntry)cat);
                if (actionDescriptor == null) {
                    L.error("can't get a descriptor for {}", (Object)cat.getName());
                    return false;
                }
                IAction action = actionDescriptor.getAction();
                if (action == null) break block4;
                ret = action.canHandle(context);
                break block4;
            }
            Collection ents = this.cm.getEntries(cat.getId());
            if (ents != null) {
                for (ICategory cc : ents) {
                    if (!this.canHandle(cc, context)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private Object[] filterElems(Collection<ICategory> cats, IActionContext context) {
        if (cats == null || cats.isEmpty()) {
            return new Object[0];
        }
        ArrayList<ICategory> filtered = new ArrayList<ICategory>();
        for (ICategory cat : cats) {
            if (!this.canHandle(cat, context)) continue;
            filtered.add(cat);
        }
        return filtered.toArray();
    }
}

